/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.test.xtext.GlobalRegistries2;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.registry.CompleteOCLRegistry;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class RegistryTests
extends TestCase {
    public String getName() {
        return TestUtil.getName((String)ClassUtil.nonNullState((Object)super.getName()));
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.uninstall();
    }

    public void testCompleteOCLRegistry_Access() {
        GlobalRegistries2.GlobalStateMemento copyOfGlobalState2 = null;
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            copyOfGlobalState2 = GlobalRegistries2.makeCopyOfGlobalState();
        }
        try {
            EcorePlugin.ExtensionProcessor.process(null);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            new ProjectMap(false).initializeResourceSet((ResourceSet)resourceSet);
            resourceSet.getResource(URI.createPlatformPluginURI((String)"/org.eclipse.emf.ecore/model/Ecore.ecore", (boolean)true), true);
            CompleteOCLRegistry registry = CompleteOCLRegistry.INSTANCE;
            Set registeredResourceURIs = registry.getResourceURIs((ResourceSet)resourceSet);
            int expectedSize = 2;
            RegistryTests.assertEquals((String)registeredResourceURIs.toString(), (int)expectedSize, (int)registeredResourceURIs.size());
        }
        finally {
            if (copyOfGlobalState2 != null) {
                copyOfGlobalState2.restoreGlobalState();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testCompleteOCLRegistry_Rebuild() {
        @NonNull URI uriA = URI.createURI((String)"A");
        @NonNull HashSet<@NonNull E> setOf = new HashSet();
        @NonNull @NonNull HashSet setOf_A = Sets.newHashSet((Object[])new URI[]{uriA});
        @NonNull @NonNull ArrayList listOf_a1 = Lists.newArrayList((Object[])new String[]{"a1"});
        @NonNull @NonNull ArrayList listOf_a2 = Lists.newArrayList((Object[])new String[]{"a2"});
        @NonNull @NonNull ArrayList listOf_a1_a2 = Lists.newArrayList((Object[])new String[]{"a1", "a2"});
        CompleteOCLRegistry.Registration reg_A_a1 = new CompleteOCLRegistry.Registration(uriA, (Iterable)listOf_a1);
        CompleteOCLRegistry.Registration reg_A_a2 = new CompleteOCLRegistry.Registration(uriA, (Iterable)listOf_a2);
        CompleteOCLRegistry.Registration reg_A_a1_a2 = new CompleteOCLRegistry.Registration(uriA, (Iterable)listOf_a1_a2);
        CompleteOCLRegistry registry = new CompleteOCLRegistry();
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        registry.addRegistration(reg_A_a1_a2);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1_a2));
        registry.addRegistration(reg_A_a1);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1_a2));
        registry.removeRegistration(reg_A_a2);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1_a2));
        registry.removeRegistration(reg_A_a1_a2);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1_a2));
        registry.removeRegistration(reg_A_a1);
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a2));
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a1_a2));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testCompleteOCLRegistry_Rebuild_Counted() {
        @NonNull URI uriA = URI.createURI((String)"A");
        @NonNull HashSet<@NonNull E> setOf = new HashSet();
        @NonNull @NonNull HashSet setOf_A = Sets.newHashSet((Object[])new URI[]{uriA});
        @NonNull @NonNull ArrayList listOf_a1 = Lists.newArrayList((Object[])new String[]{"a1"});
        CompleteOCLRegistry.Registration reg_A_a1 = new CompleteOCLRegistry.Registration(uriA, (Iterable)listOf_a1);
        CompleteOCLRegistry registry = new CompleteOCLRegistry();
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        registry.addRegistration(reg_A_a1);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        registry.addRegistration(reg_A_a1);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        registry.removeRegistration(reg_A_a1);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        registry.removeRegistration(reg_A_a1);
        RegistryTests.assertEquals(setOf, (Object)registry.getResourceURIs((Iterable)listOf_a1));
        registry.addRegistration(reg_A_a1);
        RegistryTests.assertEquals((Object)setOf_A, (Object)registry.getResourceURIs((Iterable)listOf_a1));
    }
}

