/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class JUnitPluginFileSystem
extends TestFileSystem {
    protected final @NonNull Map<@NonNull String, @NonNull JUnitPluginTestProject> projectName2testProject = new HashMap<String, JUnitPluginTestProject>();

    public static @NonNull JUnitPluginFileSystem create(@NonNull TestFileSystemHelper helper) {
        TestUIUtil.closeIntro();
        return new JUnitPluginFileSystem(helper);
    }

    public JUnitPluginFileSystem(@NonNull TestFileSystemHelper helper) {
        super(helper);
    }

    @Override
    public @NonNull TestProject getTestProject(@NonNull String projectName, boolean cleanProject) {
        JUnitPluginTestProject testProject = this.projectName2testProject.get(projectName);
        if (testProject == null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(projectName);
            assert (project != null);
            if (cleanProject) {
                try {
                    if (!project.exists()) {
                        project.create(null);
                    }
                    if (!project.isOpen()) {
                        project.open(null);
                    }
                    IFolder settingsFolder = project.getFolder(".settings");
                    settingsFolder.create(true, true, null);
                    IFile resourcesFile = settingsFolder.getFile("org.eclipse.core.resources.prefs");
                    String resourcesContents = this.getResourcesPreferenceContents();
                    URIConverter.ReadableInputStream resourcesStream = new URIConverter.ReadableInputStream(resourcesContents, "UTF-8");
                    resourcesFile.create((InputStream)resourcesStream, true, null);
                    IFile runtimeFile = settingsFolder.getFile("org.eclipse.core.runtime.prefs");
                    String runtimeContents = this.getRuntimePreferenceContents();
                    URIConverter.ReadableInputStream runtimeStream = new URIConverter.ReadableInputStream(runtimeContents, "UTF-8");
                    runtimeFile.create((InputStream)runtimeStream, true, null);
                    IProjectDescription projectDescription = project.getDescription();
                    if (projectDescription != null && (projectDescription = this.helper.updateProjectDescription(projectDescription)) != null) {
                        project.setDescription(projectDescription, null);
                    }
                    project.refreshLocal(2, null);
                    TestUIUtil.flushEvents();
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
            testProject = new JUnitPluginTestProject(this, URI.createPlatformResourceURI((String)projectName, (boolean)true), project);
            this.projectName2testProject.put(projectName, testProject);
        }
        return testProject;
    }

    protected static class JUnitPluginTestFile
    implements TestFile {
        protected final @NonNull URI platformURI;
        protected final @NonNull File file;

        public JUnitPluginTestFile(@NonNull URI platformURI, @NonNull File file) {
            this.platformURI = platformURI;
            this.file = file;
        }

        @Override
        public @NonNull File getFile() {
            return this.file;
        }

        @Override
        public @NonNull String getFileString() {
            return String.valueOf(this.file);
        }

        @Override
        public @NonNull URI getFileURI() {
            return URI.createFileURI((String)this.file.toString());
        }

        @Override
        public @NonNull String getName() {
            return this.file.getName();
        }

        @Override
        public @NonNull URI getURI() {
            return this.platformURI;
        }

        public String toString() {
            return String.valueOf(this.platformURI.toString()) + " => " + this.file.toString();
        }
    }

    protected static class JUnitPluginTestFolder
    extends JUnitPluginTestFile
    implements TestFile {
        protected final @NonNull IContainer container;

        public JUnitPluginTestFolder(@NonNull URI platformURI, @NonNull IContainer container) {
            super(platformURI, (File)ClassUtil.nonNullState((Object)container.getLocation().toFile()));
            this.container = container;
        }

        public @NonNull JUnitPluginTestFile createFile(@NonNull String name, @Nullable InputStream inputStream) {
            URI newURI = this.platformURI.appendSegment(name);
            IFile newFile = (IFile)ClassUtil.nonNullState((Object)this.container.getFile((IPath)new Path(name)));
            if (inputStream != null) {
                try {
                    newFile.create(inputStream, true, null);
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
            return new JUnitPluginTestFile(newURI, (File)ClassUtil.nonNullState((Object)newFile.getLocation().toFile()));
        }

        public @NonNull JUnitPluginTestFolder createFolder(@NonNull String name) {
            URI newURI = this.platformURI.appendSegment(name);
            IFolder newFolder = (IFolder)ClassUtil.nonNullState((Object)this.container.getFolder((IPath)new Path(name)));
            if (!newFolder.exists()) {
                try {
                    newFolder.create(true, true, null);
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
            return new JUnitPluginTestFolder(newURI, (IContainer)newFolder);
        }
    }

    protected static class JUnitPluginTestProject
    extends JUnitPluginTestFolder
    implements TestProject {
        protected @NonNull IProject javaProject;

        public JUnitPluginTestProject(@NonNull JUnitPluginFileSystem testFileSystem, @NonNull URI platformURI, @NonNull IProject javaProject) {
            super(platformURI, (IContainer)javaProject);
            this.javaProject = javaProject;
        }

        protected @NonNull JUnitPluginTestFile createFilePath(@NonNull String testFilePath, @Nullable InputStream inputStream) {
            JUnitPluginTestFolder node = this;
            @NonNull String[] testFileSegments = testFilePath.split("/");
            if (testFilePath.endsWith("/")) {
                int i = 0;
                while (i < testFileSegments.length) {
                    node = node.createFolder(testFileSegments[i]);
                    ++i;
                }
                TestUIUtil.flushEvents();
                return node;
            }
            if (testFileSegments.length > 1) {
                int i = 0;
                while (i < testFileSegments.length - 1) {
                    node = node.createFolder(testFileSegments[i]);
                    ++i;
                }
            }
            JUnitPluginTestFile createFile = node.createFile(testFileSegments[testFileSegments.length - 1], inputStream);
            TestUIUtil.flushEvents();
            return createFile;
        }

        protected @NonNull JUnitPluginTestFolder createFolderPath(@NonNull String[] testFileSegments, int lastIndex) throws CoreException {
            JUnitPluginTestFolder testFolder = this;
            int i = 0;
            while (i < lastIndex) {
                String pathSegment = testFileSegments[i];
                testFolder = testFolder.createFolder(pathSegment);
                ++i;
            }
            return testFolder;
        }

        @Override
        public @NonNull ProjectManager createTestProjectManager() {
            return new ProjectMap(false);
        }

        @Override
        public @NonNull IProject getIProject() {
            return this.javaProject;
        }

        @Override
        public @NonNull String getName() {
            return this.platformURI.segment(1);
        }

        @Override
        public @NonNull JUnitPluginTestFile getOutputFile(@NonNull String testFilePath) {
            return this.createFilePath(testFilePath, null);
        }

        @Override
        public @NonNull JUnitPluginTestFile getOutputFile(@NonNull String testFilePath, @Nullable InputStream inputStream) {
            return this.createFilePath(testFilePath, inputStream);
        }

        @Override
        public @NonNull JUnitPluginTestFolder getOutputFolder(@NonNull String testFilePath) {
            @NonNull String[] testFileSegments = testFilePath.split("/");
            try {
                return this.createFolderPath(testFileSegments, testFileSegments.length);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
    }
}

