/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.Ecore2Moniker;
import org.eclipse.ocl.pivot.internal.ecore.es2as.AbstractExternal2AS;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2ASDeclarationSwitch;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2ASReferenceSwitch;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.AliasAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.model.OCLmetamodel;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class Ecore2AS
extends AbstractExternal2AS {
    public static final @NonNull TracingOption NOT_OPTIONAL = new TracingOption("org.eclipse.ocl.pivot", "ecore2as/notOptional");
    private Map<@NonNull String, @NonNull Element> oldIdMap = null;
    private Map<@NonNull EObject, @NonNull Element> newCreateMap = null;
    private Set<@NonNull EObject> referencers = null;
    private Set<@NonNull Ecore2AS> allConverters = new HashSet<Ecore2AS>();
    private List<@NonNull EGenericType> genericTypes = null;
    private List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Resource.Diagnostic> errors = null;
    protected final @NonNull Resource ecoreResource;
    protected Model pivotModel = null;
    protected final Ecore2ASDeclarationSwitch declarationPass = new Ecore2ASDeclarationSwitch(this);
    protected final Ecore2ASReferenceSwitch referencePass = new Ecore2ASReferenceSwitch(this);
    private HashMap<EClassifier, @NonNull Type> ecore2asMap = null;
    private URI ecoreURI = null;
    private Set<EPackage> asMetamodels = null;
    private Set<EObject> importedEObjects = null;

    public static @NonNull Ecore2AS getAdapter(@NonNull Resource resource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        External2AS adapter = Ecore2AS.findAdapter(resource, environmentFactory);
        Ecore2AS castAdapter = (Ecore2AS)adapter;
        if (castAdapter == null) {
            castAdapter = new Ecore2AS(resource, environmentFactory);
        }
        return castAdapter;
    }

    public static @NonNull Model importFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, String alias, @NonNull Resource ecoreResource) {
        Ecore2AS conversion = Ecore2AS.getAdapter(ecoreResource, environmentFactory);
        return conversion.getASModel();
    }

    public static boolean isEcore(@NonNull Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof EPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullFree(@NonNull ETypedElement eObject) {
        EAnnotation eAnnotation = eObject.getEAnnotation("http://www.eclipse.org/OCL/Collection");
        boolean isNullFree = eAnnotation != null ? Boolean.valueOf((String)eAnnotation.getDetails().get((Object)"nullFree")) : true;
        return isNullFree;
    }

    public static Ecore2AS loadFromEcore(@NonNull ASResource ecoreASResource, @NonNull URI ecoreURI) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)ecoreASResource);
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        Resource ecoreResource = resourceSet.getResource(ecoreURI, true);
        if (ecoreResource == null) {
            return null;
        }
        Ecore2AS conversion = Ecore2AS.getAdapter(ecoreResource, environmentFactory);
        conversion.loadImports(ecoreResource);
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        conversion.pivotModel = PivotUtil.createModel(ecoreASResource.getURI().toString());
        conversion.update((Resource)ecoreASResource, (Collection)ClassUtil.nonNullEMF(ecoreResource.getContents()));
        AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(ecoreResource);
        if (ecoreAdapter != null) {
            Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
            AliasAdapter pivotAdapter = AliasAdapter.getAdapter((Resource)ecoreASResource);
            Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
            for (EObject eObject : ecoreAliasMap.keySet()) {
                String alias = ecoreAliasMap.get(eObject);
                Element element = conversion.newCreateMap.get(eObject);
                pivotAliasMap.put(element, alias);
            }
        }
        metamodelManager.installResource((Resource)ecoreASResource);
        conversion.installImports();
        return conversion;
    }

    public static Element importFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, String alias, @NonNull EObject eObject) {
        Resource ecoreResource = ClassUtil.nonNullEMF(eObject.eResource());
        Ecore2AS conversion = Ecore2AS.getAdapter(ecoreResource, environmentFactory);
        Model pivotModel = conversion.getASModel();
        return conversion.newCreateMap.get(eObject);
    }

    public Ecore2AS(@NonNull Resource ecoreResource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
        this.ecoreResource = ecoreResource;
        this.environmentFactory.addExternal2AS(this);
    }

    protected void addCreated(@NonNull EObject eObject, @NonNull Element pivotElement) {
        Element oldElement = this.newCreateMap.put(eObject, pivotElement);
    }

    @Override
    public void addGenericType(@NonNull EGenericType eObject) {
        this.genericTypes.add(eObject);
    }

    @Override
    public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
        Type pivotType;
        if (pivotElement instanceof PivotObjectImpl) {
            ((PivotObjectImpl)((Object)pivotElement)).setESObject(eObject);
        }
        Element pivotElement1 = pivotElement;
        if (eObject instanceof EDataType && (pivotType = this.getEcore2ASMap().get(eObject)) != null) {
            pivotElement1 = pivotType;
        }
        this.addCreated(eObject, pivotElement1);
    }

    @Override
    protected Model basicGetPivotModel() {
        return this.pivotModel;
    }

    protected @NonNull URI createPivotURI() {
        if (this.ecoreURI != null) {
            return PivotUtilInternal.getASURI(this.ecoreURI.trimFragment());
        }
        URI uri = this.ecoreResource.getURI();
        if (uri == null) {
            throw new IllegalStateException("Missing resource URI");
        }
        return PivotUtilInternal.getASURI(uri);
    }

    @Override
    public void error(@Nullable String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends Element> T getASElement(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        Element element;
        if (this.pivotModel == null) {
            this.getASModel();
        }
        if ((element = this.newCreateMap.get(eObject)) == null) {
            Ecore2AS converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2AS.getAdapter(resource, this.environmentFactory))) {
                converter.getASModel();
                for (Map.Entry<EObject, Element> entry : converter.newCreateMap.entrySet()) {
                    this.newCreateMap.put(entry.getKey(), entry.getValue());
                }
            }
            element = this.newCreateMap.get(eObject);
        }
        if (element == null) {
            this.error("Unresolved " + eObject);
        } else if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    @Override
    public @NonNull Model getASModel() {
        Model pivotModel2 = this.pivotModel;
        if (pivotModel2 == null) {
            this.loadImports(this.ecoreResource);
            pivotModel2 = this.pivotModel = this.importObjects((Collection)ClassUtil.nonNullEMF(this.ecoreResource.getContents()), this.createPivotURI());
            this.installImports();
        }
        return pivotModel2;
    }

    public <T extends Element> @Nullable T getASOfEcore(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        Element element;
        if (this.pivotModel == null) {
            this.getASModel();
        }
        if ((element = this.newCreateMap.get(eObject)) == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public Type getASType(@NonNull EObject eObject) {
        Element pivotElement = this.newCreateMap.get(eObject);
        if (pivotElement == null) {
            Ecore2AS converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2AS.getAdapter(resource, this.environmentFactory))) {
                converter.getASModel();
                for (Map.Entry<EObject, Element> entry : converter.newCreateMap.entrySet()) {
                    this.newCreateMap.put(entry.getKey(), entry.getValue());
                }
            }
            pivotElement = this.newCreateMap.get(eObject);
        }
        if (pivotElement == null) {
            this.error("Unresolved " + eObject);
        } else if (!(pivotElement instanceof Type)) {
            this.error("Incompatible " + eObject);
        } else {
            return (Type)pivotElement;
        }
        return null;
    }

    protected @Nullable URI getBaseURI(@NonNull Resource ecoreResource) {
        URI ecoreURI = ecoreResource.getURI();
        if (ecoreURI == null) {
            return null;
        }
        if (ClassUtil.isRegistered(ecoreResource)) {
            ProjectManager projectManager = this.environmentFactory.getProjectManager();
            ProjectManager.IPackageDescriptor packageDescriptor = projectManager.getPackageDescriptor(ecoreURI);
            if (packageDescriptor == null) {
                return null;
            }
            return packageDescriptor.getResourceDescriptor().getPlatformPluginURI();
        }
        if (!ecoreURI.isHierarchical() || ecoreURI.isRelative()) {
            return null;
        }
        return ecoreURI;
    }

    public @Nullable Element getCreated(@NonNull EObject eObject) {
        return this.newCreateMap.get(eObject);
    }

    @Override
    public <T extends Element> @Nullable T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        return this.getASOfEcore(requiredClass, eObject);
    }

    @Override
    public @Nullable Map<@NonNull EObject, @NonNull Element> getCreatedMap() {
        return this.newCreateMap;
    }

    public @NonNull Map<EClassifier, Type> getEcore2ASMap() {
        HashMap<Object, @NonNull Type> ecore2asMap2 = this.ecore2asMap;
        if (ecore2asMap2 == null) {
            ecore2asMap2 = this.ecore2asMap = new HashMap();
            this.initializeEcore2ASMap();
        }
        return ecore2asMap2;
    }

    public @Nullable Resource getEcoreResource() {
        return this.ecoreResource;
    }

    @Override
    public @Nullable Resource getResource() {
        return this.ecoreResource;
    }

    @Override
    public @NonNull URI getURI() {
        return ClassUtil.nonNullEMF(this.ecoreResource.getURI());
    }

    public @NonNull Model importObjects(@NonNull Collection<EObject> ecoreContents, @NonNull URI pivotURI) {
        List<Resource.Diagnostic> errors2;
        EObject eObject;
        String nsURI;
        EPackage libraryEPackage = this.isLibrary(ecoreContents);
        if (libraryEPackage != null) {
            this.newCreateMap = new HashMap<EObject, Element>();
            Package asLibrary = this.standardLibrary.getPackage();
            this.newCreateMap.put((EObject)libraryEPackage, asLibrary);
            List<Class> ownedType = asLibrary.getOwnedClasses();
            for (EClassifier eClassifier : libraryEPackage.getEClassifiers()) {
                String name = this.environmentFactory.getTechnology().getOriginalName((ENamedElement)eClassifier);
                Type asType = NameUtil.getNameable(ownedType, name);
                if (asType == null) continue;
                this.newCreateMap.put((EObject)eClassifier, asType);
            }
            Model containingRoot = PivotUtil.getContainingModel(asLibrary);
            return ClassUtil.nonNullModel(containingRoot);
        }
        @NonNull ASResource asResource = this.metamodelManager.getResource(pivotURI, "org.eclipse.ocl.oclas.ecore");
        if (this.metamodelManager.getLibraryResource() == null && this.isPivot(ecoreContents) && (nsURI = ((EPackage)ecoreContents.iterator().next()).getNsURI()) != null) {
            String stdlibASUri = "http://www.eclipse.org/ocl/2015/Library.oclas";
            OCLstdlib library = OCLstdlib.create(stdlibASUri);
            this.metamodelManager.installResource((Resource)library);
        }
        URI uri = this.ecoreURI != null ? this.ecoreURI : this.ecoreResource.getURI();
        Model pivotModel2 = null;
        if (asResource.getContents().size() > 0 && (eObject = (EObject)asResource.getContents().get(0)) instanceof Model) {
            pivotModel2 = (Model)eObject;
        }
        if (pivotModel2 == null) {
            pivotModel2 = this.pivotModel = PivotUtil.createModel(uri.toString());
        }
        this.pivotModel = pivotModel2;
        this.newCreateMap = this.synthesizeCreateMap(asResource);
        if (this.newCreateMap == null) {
            this.update((Resource)asResource, ecoreContents);
        }
        if ((errors2 = this.errors) != null) {
            asResource.getErrors().addAll(ClassUtil.nullFree(errors2));
        }
        return pivotModel2;
    }

    private @Nullable Map<@NonNull EObject, @NonNull Element> synthesizeCreateMap(@NonNull ASResource asResource) {
        if (asResource instanceof OCLmetamodel) {
            HashMap<@NonNull EObject, @NonNull Element> newCreateMap = new HashMap<EObject, Element>();
            TreeIterator tit = this.pivotModel.eAllContents();
            while (tit.hasNext()) {
                Element asElement;
                EObject esObject;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Element) || (esObject = (asElement = (Element)eObject).getESObject()) == null) continue;
                newCreateMap.put(esObject, asElement);
            }
            newCreateMap.put((EObject)ClassUtil.nonNullEMF(PivotPackage.Literals.BOOLEAN), this.standardLibrary.getBooleanType());
            newCreateMap.put((EObject)ClassUtil.nonNullEMF(PivotPackage.Literals.INTEGER), this.standardLibrary.getIntegerType());
            newCreateMap.put((EObject)ClassUtil.nonNullEMF(PivotPackage.Literals.REAL), this.standardLibrary.getRealType());
            newCreateMap.put((EObject)ClassUtil.nonNullEMF(PivotPackage.Literals.STRING), this.standardLibrary.getStringType());
            newCreateMap.put((EObject)ClassUtil.nonNullEMF(PivotPackage.Literals.UNLIMITED_NATURAL), this.standardLibrary.getUnlimitedNaturalType());
            return newCreateMap;
        }
        return null;
    }

    public void initializeEcore2ASMap() {
        this.ecore2asMap.put((EClassifier)EcorePackage.Literals.EBOOLEAN, this.standardLibrary.getBooleanType());
        this.ecore2asMap.put((EClassifier)EcorePackage.Literals.EBIG_INTEGER, this.standardLibrary.getIntegerType());
        this.ecore2asMap.put((EClassifier)EcorePackage.Literals.EBIG_DECIMAL, this.standardLibrary.getRealType());
        this.ecore2asMap.put((EClassifier)EcorePackage.Literals.ESTRING, this.standardLibrary.getStringType());
    }

    protected void installImports() {
        URI baseURI = this.getBaseURI(this.ecoreResource);
        List<Import> allImports = this.pivotModel.getOwnedImports();
        for (EObject eContent : this.ecoreResource.getContents()) {
            EAnnotation importAnnotation;
            if (!(eContent instanceof EModelElement) || (importAnnotation = ((EModelElement)eContent).getEAnnotation("http://www.eclipse.org/OCL/Import")) == null) continue;
            EMap details = importAnnotation.getDetails();
            for (String key : details.keySet()) {
                String value = (String)details.get((Object)key);
                if (value == null) {
                    value = key;
                    key = "";
                }
                URI uri = URI.createURI((String)value);
                if (baseURI != null) {
                    uri = uri.resolve(baseURI);
                }
                try {
                    assert (uri != null);
                    Element importedObject = this.metamodelManager.loadResource(uri, null, this.ecoreResource.getResourceSet());
                    if (!(importedObject instanceof Namespace)) continue;
                    Import anImport = PivotFactory.eINSTANCE.createImport();
                    anImport.setName(key);
                    anImport.setImportedNamespace((Namespace)importedObject);
                    allImports.add(anImport);
                }
                catch (ParserException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    protected EPackage isLibrary(@NonNull Collection<EObject> ecoreContents) {
        if (ecoreContents.size() != 1) {
            return null;
        }
        EObject ecoreRoot = ecoreContents.iterator().next();
        if (!(ecoreRoot instanceof EPackage)) {
            return null;
        }
        EPackage ecorePackage = (EPackage)ecoreRoot;
        EAnnotation asLibraryAnnotation = ecorePackage.getEAnnotation("http://www.eclipse.org/OCL/ASLibrary");
        return asLibraryAnnotation != null ? ecorePackage : null;
    }

    protected boolean isPivot(@NonNull Collection<EObject> ecoreContents) {
        if (ecoreContents.size() != 1) {
            return false;
        }
        EObject ecoreRoot = ecoreContents.iterator().next();
        if (!(ecoreRoot instanceof EPackage)) {
            return false;
        }
        EPackage ecorePackage = (EPackage)ecoreRoot;
        if (ClassUtil.basicGetMetamodelAnnotation(ecorePackage) != null) {
            return true;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return ecorePackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    protected void loadImports(@NonNull Resource ecoreResource) {
        String nsURI;
        URI baseURI = this.getBaseURI(ecoreResource);
        for (EObject eContent : ecoreResource.getContents()) {
            if (!(eContent instanceof EPackage)) continue;
            this.loadImports((EPackage)eContent, baseURI);
        }
        if (this.asMetamodels != null && this.metamodelManager.getLibraryResource() == null && (nsURI = this.asMetamodels.iterator().next().getNsURI()) != null) {
            OCLstdlib library = OCLstdlib.getDefault();
            this.metamodelManager.installResource((Resource)library);
        }
    }

    protected void loadImports(@NonNull EPackage ePackage, @Nullable URI baseURI) {
        EAnnotation importAnnotation;
        if (ClassUtil.basicGetMetamodelAnnotation(ePackage) != null) {
            if (this.asMetamodels == null) {
                this.asMetamodels = new HashSet<EPackage>();
            }
            this.asMetamodels.add(ePackage);
        }
        if ((importAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/Import")) != null) {
            EMap details = importAnnotation.getDetails();
            for (String key : details.keySet()) {
                Resource importedResource;
                String value = (String)details.get((Object)key);
                if (value == null) {
                    value = key;
                    key = "";
                }
                URI uri = URI.createURI((String)value);
                uri = this.resolveImportURI(uri, ePackage, baseURI);
                assert (uri != null);
                ResourceSet resourceSet = this.environmentFactory.getResourceSet();
                Object importedEObject = null;
                String fragment = uri.fragment();
                importedEObject = fragment == null ? resourceSet.getPackageRegistry().getEPackage(uri.toString()) : resourceSet.getEObject(uri, true);
                if (importedEObject == null) continue;
                if (this.importedEObjects == null) {
                    this.importedEObjects = new HashSet<EObject>();
                }
                if (!this.importedEObjects.add((EObject)importedEObject) || !(importedEObject instanceof EPackage) || (importedResource = importedEObject.eResource()) == null) continue;
                URI baseURI2 = this.getBaseURI(importedResource);
                this.loadImports((EPackage)importedEObject, baseURI2);
            }
        }
        for (EPackage eSubPackage : ePackage.getESubpackages()) {
            if (eSubPackage == null) continue;
            this.loadImports(eSubPackage, baseURI);
        }
    }

    private @NonNull URI resolveImportURI(@NonNull URI uri, @NonNull EPackage ePackage, @Nullable URI baseURI) {
        Collection<ProjectManager.IResourceDescriptor> resourceDescriptors;
        String projectName;
        ProjectManager.IProjectDescriptor projectDescriptor;
        if (baseURI == null) {
            return uri;
        }
        ProjectManager projectManager = this.environmentFactory.getProjectManager();
        if (!(projectManager instanceof StandaloneProjectMap)) {
            return uri;
        }
        StandaloneProjectMap projectMap = (StandaloneProjectMap)projectManager;
        if ((uri = uri.resolve(baseURI)).isPlatformPlugin() && ClassUtil.safeEquals(ePackage.getNsURI(), String.valueOf(ePackage.eResource().getURI())) && uri.segmentCount() >= 1 && (projectDescriptor = projectMap.getProjectDescriptor(projectName = uri.segment(1))) instanceof ProjectManager.IProjectDescriptor.IProjectDescriptorExtension && (resourceDescriptors = projectDescriptor.getResourceDescriptors()) != null) {
            for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                Iterator<ProjectManager.IPackageDescriptor> iterator;
                if (!ClassUtil.safeEquals(uri.trimFragment(), resourceDescriptor.getPlatformPluginURI())) continue;
                Iterable<@NonNull ProjectManager.IPackageDescriptor> packageDescriptors = ((ProjectManager.IProjectDescriptor.IProjectDescriptorExtension)projectDescriptor).getPackageDescriptors();
                if (packageDescriptors == null || !(iterator = packageDescriptors.iterator()).hasNext()) break;
                ProjectManager.IPackageDescriptor packageDescriptor = iterator.next();
                uri = packageDescriptor.getNsURI();
                break;
            }
        }
        return uri;
    }

    @Override
    public void queueReference(@NonNull EObject eObject) {
        this.referencers.add(eObject);
    }

    @Override
    public <T extends NamedElement> T refreshElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull EModelElement eModelElement) {
        String id;
        Object pivotElement = null;
        if (this.oldIdMap != null && (id = ((XMLResource)eModelElement.eResource()).getID((EObject)eModelElement)) != null && (pivotElement = (EObject)this.oldIdMap.get(id)) != null && pivotElement.eClass() != pivotEClass) {
            pivotElement = null;
        }
        if (pivotElement == null) {
            EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
            pivotElement = eFactoryInstance.create(pivotEClass);
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        Element oldElement = this.newCreateMap.put((EObject)eModelElement, castElement);
        assert (oldElement == null);
        return (T)castElement;
    }

    protected Type resolveDataType(@NonNull EDataType eClassifier) {
        Type pivotType = this.getEcore2ASMap().get(eClassifier);
        if (pivotType == null) {
            pivotType = this.getASType((EObject)eClassifier);
        }
        return pivotType;
    }

    protected Type resolveGenericType(@NonNull Map<String, Type> resolvedSpecializations, @NonNull EGenericType eGenericType) {
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (!eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters.size() == eTypeArguments.size());
        Type unspecializedPivotType = this.getASType((EObject)eClassifier);
        if (unspecializedPivotType == null) {
            return null;
        }
        ArrayList<@NonNull Type> templateArguments = new ArrayList<Type>();
        for (EGenericType eTypeArgument : eTypeArguments) {
            Type typeArgument;
            if (eTypeArgument == null || (typeArgument = this.resolveType(resolvedSpecializations, eTypeArgument)) == null) continue;
            templateArguments.add(typeArgument);
        }
        Class unspecializedPivotClass = unspecializedPivotType.isClass();
        assert (unspecializedPivotClass != null);
        return this.metamodelManager.getLibraryType(unspecializedPivotClass, templateArguments);
    }

    protected Type resolveSimpleType(@NonNull EClassifier eClassifier) {
        return this.getASType((EObject)eClassifier);
    }

    protected Type resolveType(@NonNull Map<String, Type> resolvedSpecializations, @NonNull EGenericType eGenericType) {
        Type pivotType = this.getCreated(Type.class, (EObject)eGenericType);
        if (pivotType != null) {
            return pivotType;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        if (eTypeParameter != null) {
            pivotType = this.resolveTypeParameter(eGenericType);
        } else if (eClassifier == null) {
            pivotType = this.resolveWildcardType(eGenericType);
        } else if (!eTypeArguments.isEmpty()) {
            String ecoreMoniker = Ecore2Moniker.toString(eGenericType);
            pivotType = resolvedSpecializations.get(ecoreMoniker);
            if (pivotType == null) {
                pivotType = this.resolveGenericType(resolvedSpecializations, eGenericType);
                resolvedSpecializations.put(ecoreMoniker, pivotType);
            }
        } else if (eClassifier instanceof EDataType) {
            assert (eGenericType.getETypeArguments().isEmpty());
            pivotType = this.resolveDataType((EDataType)eClassifier);
        } else {
            assert (eGenericType.getETypeArguments().isEmpty());
            pivotType = this.resolveSimpleType(eClassifier);
        }
        if (pivotType != null) {
            this.newCreateMap.put((EObject)eGenericType, pivotType);
        }
        return pivotType;
    }

    protected Type resolveTypeParameter(@NonNull EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (eClassifier == null);
        assert (eTypeArguments.isEmpty());
        Type pivotType = null;
        if (eTypeParameter != null) {
            pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
        }
        return pivotType;
    }

    protected Type resolveWildcardType(@NonNull EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        return this.metamodelManager.createWildcardType(null, null);
    }

    public void setEcoreURI(URI ecoreURI) {
        this.ecoreURI = ecoreURI;
    }

    public String toString() {
        return String.valueOf(this.ecoreResource.getURI());
    }

    public void update(@NonNull Resource asResource, @NonNull Collection<EObject> ecoreContents) {
        Element element;
        this.newCreateMap = new HashMap<EObject, Element>();
        this.referencers = new HashSet<EObject>();
        this.genericTypes = new ArrayList<EGenericType>();
        PivotUtilInternal.refreshList(asResource.getContents(), Collections.singletonList(ClassUtil.nonNull(this.pivotModel)));
        ArrayList<Package> newPackages = new ArrayList<Package>();
        for (EObject eObject : ecoreContents) {
            EClass eClass = eObject.eClass();
            if (eClass.getEPackage() != EcorePackage.eINSTANCE) {
                this.error("Non Ecore " + eClass.getName() + " for Ecore2AS.update");
                continue;
            }
            Object pivotElement = this.declarationPass.doInPackageSwitch(eObject);
            if (pivotElement instanceof Package) {
                newPackages.add((Package)pivotElement);
                continue;
            }
            this.error("Bad ecore content");
        }
        PivotUtilInternal.refreshList(this.pivotModel.getOwnedPackages(), newPackages);
        AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(this.ecoreResource);
        if (ecoreAdapter != null) {
            Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
            AliasAdapter pivotAdapter = AliasAdapter.getAdapter(asResource);
            Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
            for (EObject eObject : ecoreAliasMap.keySet()) {
                String alias = ecoreAliasMap.get(eObject);
                element = this.newCreateMap.get(eObject);
                pivotAliasMap.put(element, alias);
            }
        }
        this.metamodelManager.installResource(asResource);
        HashMap<@NonNull String, @NonNull Type> resolvedSpecializations = new HashMap<String, Type>();
        for (EGenericType eGenericType : this.genericTypes) {
            Type pivotType = this.resolveType(resolvedSpecializations, eGenericType);
            if (pivotType == null) continue;
            this.newCreateMap.put((EObject)eGenericType, pivotType);
        }
        for (EObject eObject : this.referencers) {
            this.referencePass.doInPackageSwitch(eObject);
        }
        for (EObject eObject : this.referencers) {
            Property oppositeProperty;
            Property pivotElement;
            if (!(eObject instanceof EReference) || (pivotElement = this.getCreated(Property.class, eObject)) == null || (oppositeProperty = pivotElement.getOpposite()) != null || !(eObject.eContainer() instanceof EClass)) continue;
            this.metamodelManager.installPropertyDeclaration(pivotElement);
        }
        this.referencers = null;
        this.genericTypes = null;
        this.oldIdMap = new HashMap<String, Element>();
        for (EObject ecoreContent : ecoreContents) {
            Resource resource = ecoreContent.eResource();
            if (!(resource instanceof XMLResource)) continue;
            XMLResource xmlResource = (XMLResource)resource;
            String id = xmlResource.getID(ecoreContent);
            if (id != null && (element = this.newCreateMap.get(ecoreContent)) != null) {
                this.oldIdMap.put(id, element);
            }
            TreeIterator tit = ecoreContent.eAllContents();
            while (tit.hasNext()) {
                Element element2;
                EObject eObject = (EObject)tit.next();
                id = xmlResource.getID(eObject);
                if (id == null || (element2 = this.newCreateMap.get(eObject)) == null) continue;
                this.oldIdMap.put(id, element2);
            }
        }
    }
}

