/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiteralExpOperations
extends OCLExpressionOperations {
    protected CollectionLiteralExpOperations() {
    }

    public static <C> boolean checkNoCollectionInstances(CollectionLiteralExp<C> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = collectionLiteralExp.getKind() != CollectionKind.COLLECTION_LITERAL;
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 3, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkNoCollectionInstances", EObjectValidator.getObjectLabel(collectionLiteralExp, context)}), new Object[]{collectionLiteralExp}));
        }
        return result;
    }

    public static <C> boolean checkSetKind(CollectionLiteralExp<C> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        CollectionKind kind = collectionLiteralExp.getKind();
        boolean bl = result = kind != CollectionKind.SET_LITERAL || TypesPackage.Literals.SET_TYPE.isInstance(collectionLiteralExp.getType());
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 4, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkSetKind", EObjectValidator.getObjectLabel(collectionLiteralExp, context)}), new Object[]{collectionLiteralExp}));
        }
        return result;
    }

    public static <C> boolean checkSequenceKind(CollectionLiteralExp<C> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        CollectionKind kind = collectionLiteralExp.getKind();
        boolean bl = result = kind != CollectionKind.SEQUENCE_LITERAL || TypesPackage.Literals.SEQUENCE_TYPE.isInstance(collectionLiteralExp.getType());
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 5, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkSequenceKind", EObjectValidator.getObjectLabel(collectionLiteralExp, context)}), new Object[]{collectionLiteralExp}));
        }
        return result;
    }

    public static <C> boolean checkBagKind(CollectionLiteralExp<C> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        CollectionKind kind = collectionLiteralExp.getKind();
        boolean bl = result = kind != CollectionKind.BAG_LITERAL || TypesPackage.Literals.BAG_TYPE.isInstance(collectionLiteralExp.getType());
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 6, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkBagKind", EObjectValidator.getObjectLabel(collectionLiteralExp, context)}), new Object[]{collectionLiteralExp}));
        }
        return result;
    }

    public static <C> boolean checkElementType(CollectionLiteralExp<C> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object type;
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(collectionLiteralExp, context);
        if (env != null && (type = collectionLiteralExp.getType()) instanceof CollectionType) {
            CollectionType ctype = (CollectionType)type;
            EList<CollectionLiteralPart<C>> parts = collectionLiteralExp.getPart();
            if (parts.isEmpty()) {
                if (!(ctype.getElementType() instanceof VoidType)) {
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceEmptyCollection_ERROR_, collectionLiteralExp.toString());
                }
            } else {
                Object partsType = ((CollectionLiteralPart)parts.get(0)).getType();
                for (CollectionLiteralPart part : parts) {
                    partsType = TypeUtil.commonSuperType(null, env, partsType, part.getType());
                }
                if (partsType == null || !TypeUtil.exactTypeMatch(env, partsType, ctype.getElementType())) {
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceCollectionElementType_ERROR_, collectionLiteralExp.toString());
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 7, message, new Object[]{collectionLiteralExp}));
        }
        return result;
    }
}

