/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.context.ModelContext;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.values.CollectionTypeParametersImpl;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.pivot.values.CollectionTypeParameters;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.junit.Before;

public class EditTests
extends XtextTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        TestUtil.doCompleteOCLSetup();
        TestUtil.doOCLstdlibSetup();
        super.setUp();
    }

    private void assertHasComments(@NonNull Resource aResource, @NonNull String @NonNull [] comments) {
        Integer count;
        String comment;
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        String[] stringArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            comment = stringArray[n2];
            count = (Integer)expected.get(comment);
            count = count != null ? count + 1 : 1;
            expected.put(comment, count);
            ++n2;
        }
        TreeIterator tit = aResource.getAllContents();
        while (tit.hasNext()) {
            EAnnotation eAnnotation;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof EModelElement) || (eAnnotation = ((EModelElement)eObject).getEAnnotation("http://www.eclipse.org/emf/2002/GenModel")) == null) continue;
            String comment2 = (String)eAnnotation.getDetails().get((Object)"documentation");
            count = (Integer)expected.get(comment2);
            EditTests.assertTrue((String)("Expected comment '" + comment2 + "' exists"), (count != null && count > 0 ? 1 : 0) != 0);
            expected.put(comment2, (count != null ? count : 0) - 1);
        }
        stringArray = comments;
        n = comments.length;
        int n3 = 0;
        while (n3 < n) {
            comment = stringArray[n3];
            Integer occurences = (Integer)expected.get(comment);
            assert (occurences != null);
            EditTests.assertEquals((String)("Expected comment '" + comment + "' extra occurences"), (int)0, (int)occurences);
            ++n3;
        }
    }

    public boolean debugStateRef(WeakReference<Type> sequenceMyType) {
        DebugRef debugRef = new DebugRef(sequenceMyType.get());
        return debugRef.object == null;
    }

    protected @NonNull Resource doRename(@NonNull OCL ocl, @NonNull CSResource xtextResource, @NonNull Resource asResource, @NonNull String oldString, @NonNull String newString, @NonNull String @NonNull [] asErrors, @NonNull String @NonNull [] ecoreErrors) throws IOException {
        boolean validSave;
        String contextMessage = "Renaming '" + oldString + "' to '" + newString + "'";
        this.replace(xtextResource, oldString, newString);
        EditTests.assertResourceErrors(contextMessage, (Resource)xtextResource, asErrors);
        EditTests.assertNoResourceErrors(contextMessage, asResource);
        boolean bl = validSave = asErrors.length == 0;
        if (validSave) {
            EditTests.assertNoValidationErrors(contextMessage, asResource);
        }
        Resource ecoreResource = EditTests.as2ecore(ocl, asResource, this.getTestFileURI("test.ecore"), ecoreErrors);
        EditTests.assertNoResourceErrors(contextMessage, ecoreResource);
        return ecoreResource;
    }

    protected @NonNull Resource getEcoreFromCS(@NonNull OCL ocl, @NonNull String testDocument, @NonNull URI ecoreURI) throws IOException {
        @NonNull URI xtextURI = URI.createURI((String)"test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(xtextURI, testDocument);
        EditTests.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource ecoreResource = EditTests.as2ecore(ocl, asResource, ecoreURI, NO_MESSAGES);
        return ecoreResource;
    }

    protected void replace(@NonNull CSResource xtextResource, String oldString, String newString) {
        String xtextContent = ((EObject)xtextResource.getContents().get(0)).toString();
        int index = xtextContent.indexOf(oldString);
        assert (index >= 0);
        xtextResource.update(index, oldString.length(), newString);
    }

    public void testEdit_Paste_NsURI() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testDocument = "package example : ex = 'http://www.example.org/examples/example.ecore'\n{\n\tclass Example\n\t{\n\t\tattribute name : String[?];\n\t\tproperty children : Example[*] { ordered composes };\n\t}\n}\n";
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource resource = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        this.replace(xtextResource, "http://www.example.org/examples/example.ecore", "http://www.example.org/examples/example1.ecore");
        EditTests.assertNoResourceErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        URI ecoreURI2 = this.getTestFileURI("test2.ecore");
        Resource resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        this.replace(xtextResource, "http://www.example.org/examples/example1.ecore", "http://www.example.org/examples/example.ecore");
        EditTests.assertNoResourceErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Unpasting operation", asResource);
        EditTests.assertNoValidationErrors("Unpasting operation", asResource);
        URI ecoreURI3 = this.getTestFileURI("test3.ecore");
        resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        ocl.dispose();
    }

    public void testEdit_Paste_OCLinEcore() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String oldDocument = "package example : ex = 'http://www.example.org/examples/example.ecore'\n{\n\tclass Example\n\t{\n\t\tattribute name : String[?];\n\t\tproperty children : Example[*] { ordered composes };\n\t}\n}\n";
        String newDocument = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\n\npackage tutorial : tut = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n  class Library\n  {\n    attribute name : String;\n    property loans : Loan[*] { composes };\n  }\n  \n  class Loan\n  {\n  }\n}\n";
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, oldDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource resource = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        this.replace(xtextResource, oldDocument.trim(), newDocument.trim());
        EditTests.assertNoResourceErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        URI ecoreURI2 = this.getTestFileURI("models2/test2.ecore");
        Resource resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        this.replace(xtextResource, newDocument.trim(), oldDocument.trim());
        EditTests.assertNoResourceErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Unpasting operation", asResource);
        EditTests.assertNoValidationErrors("Unpasting operation", asResource);
        URI ecoreURI3 = this.getTestFileURI("models2/test3.ecore");
        resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        ocl.dispose();
    }

    public void testEdit_Paste_operation_394057() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testDocument = "package tutorial : tuttut = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Library\n\t{\n\t\tproperty books#library : Book[*] { composes };\n\t\t/*$$*/\n\t}\n\tclass Book\n\t{\n\t\tattribute name : String;\n\t\tproperty library#books : Library[?];\n\t}\n}\n";
        String pasteText = "operation packageLabels(packages : Book[*] { !unique, ordered }) : String\n{\n\tbody: packages?->sortedBy(name)?->iterate(p; acc : String = '' | acc + ' ' + p.name);\n}";
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource resource = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        this.replace(xtextResource, "/*$$*/", pasteText);
        EditTests.assertNoResourceErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        URI ecoreURI2 = this.getTestFileURI("test2.ecore");
        Resource resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        this.replace(xtextResource, pasteText, "/*$$*/");
        EditTests.assertNoResourceErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Unpasting operation", asResource);
        EditTests.assertNoValidationErrors("Unpasting operation", asResource);
        URI ecoreURI3 = this.getTestFileURI("test3.ecore");
        resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        ocl.dispose();
    }

    public void testEdit_Paste_473249() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        UMLStandaloneSetup.init();
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testDocument = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore' ;\nimport uml : 'http://www.eclipse.org/uml2/5.0.0/UML' ;\n\npackage UML2EcoreMapping : u2e = 'http://www.eclipse.org/ocl/2012/UML2EcoreMapping'\n{\n\tclass CreateOperation extends OperationMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(newName) + ' <= ' + 'operationLabels(oldOperations)';\n\t\t}\n\t\tattribute newName : String[1];\n\t}\n\tclass CreatePackage extends PackageMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(newName) + ' <= ' + packageLabels(oldPackages);\n\t\t}\n\t\tattribute newName : String[1];\n\t\tattribute nsPrefix : String[1];\n\t\tattribute nsURI : String[1];\n\t\tattribute isASmetamodel : Boolean[1] = 'false';\n\t\tattribute ecoreFileStem : String[?];\n\t\tproperty typeMappings : TypeMapping[*] { ordered composes };\n\t}\n\tclass CreateProperty extends PropertyMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(newName) + ' <= ' + propertyLabels(oldProperties);\n\t\t}\n\t\tattribute newName : String[1];\n\t\tattribute newIsDerived : ecore::EBooleanObject[?];\n\t\tattribute newIsNullFree : ecore::EBooleanObject[?];\n\t\tattribute newIsResolveProxies : ecore::EBooleanObject[?];\n\t\tattribute newIsTransient : ecore::EBooleanObject[?];\n\t\tattribute newIsUnsettable : ecore::EBooleanObject[?];\n\t\tattribute newIsVolatile : ecore::EBooleanObject[?];\n\t\tattribute newLowerBound : ecore::EIntegerObject[?];\n\t\tproperty opposite : uml::Property[?];\n\t}\n\tclass CreateType extends TypeMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(newName) + ' <= ' + typeLabels(oldTypes);\n\t\t}\n\t\tattribute newName : String[1];\n\t\tattribute newInstanceTypeName : String[?];\n\t\tattribute newIsSerializable : ecore::EBooleanObject[?];\n\t\tproperty orderedSuperTypes : uml::Type[*] { ordered };\n\t\tproperty excludeProperties : uml::Property[*] { ordered };\n\t\tproperty includeProperties : uml::Property[*] { ordered };\n\t\tproperty excludeTypes : uml::Type[*] { ordered };\n\t\tproperty operationMappings : OperationMapping[*] { ordered composes };\n\t\tproperty propertyMappings : PropertyMapping[*] { ordered composes };\n\t\tinvariant UniqueCreatePropertyNames: propertyMappings->selectByKind(CreateProperty)->isUnique(newName);\n\t}\n\tclass DeleteOperation extends OperationMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(oldName) + ' <= ' + operationLabels(oldOperations);\n\t\t}\n\t\tattribute oldName : String[1];\n\t}\n\tclass DeletePackage extends PackageMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: oldName;\n\t\t}\n\t\tattribute oldName : String[1];\n\t\tproperty deleteTypes : DeleteType[*] { ordered composes };\n\t}\n\tclass DeleteProperty extends PropertyMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(oldName) + ' <= ' + propertyLabels(oldProperties);\n\t\t}\n\t\tattribute oldName : String[1];\n\t}\n\tclass DeleteType extends TypeMapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: nameLabel(oldName) + ' <= ' + typeLabels(oldTypes);\n\t\t}\n\t\tattribute oldName : String[1];\n\t\tproperty operationMappings : OperationMapping[*] { ordered composes };\n\t\tproperty propertyMappings : PropertyMapping[*] { ordered composes };\n\t}\n\tabstract class Mapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: 'default-label';\n\t\t}\n\t\toperation nameLabel(name : String[1]) : String[1]\n\t\t{\n\t\t\tbody: if name = null then 'null' else name endif;\n\t\t}\n\t\toperation operationLabels(operations : uml::Operation[*] { ordered }) : String[1]\n\t\t{\n\t\t\tbody: operations->sortedBy(nameLabel(name))->iterate(p; acc : String = '' | let type : uml::Type = if p.class <> null then p.class else p.interface endif in acc + ' ' + nameLabel(p.class.package.name) + '::' + nameLabel(p.class.name) + '::' + nameLabel(p.name));\n\t\t}\n\t\toperation packageLabel(p : uml::Package[1]) : String[1]\n\t\t{\n\t\t\tbody: if p <> null then nameLabel(p.name) else 'null' endif;\n\t\t}\n\t\toperation packageLabels(packages : uml::Package[*] { ordered }) : String[1]\n\t\t{\n\t\t\tbody: packages->sortedBy(nameLabel(name))->iterate(p; acc : String = '' | acc + ' ' + packageLabel(p));\n\t\t}\n\t\toperation propertyLabel(p : uml::Property[1]) : String[1]\n\t\t{\n\t\t\tbody: if p <> null then let t = if p.class <> null then p.class else p.association endif in typeLabel(t) + '::' + nameLabel(p.name) else 'null' endif;\n\t\t}\n\t\toperation propertyLabels(properties : uml::Property[*] { ordered }) : String[1]\n\t\t{\n\t\t\tbody: properties->sortedBy(nameLabel(name))->iterate(p; acc : String = '' | acc + ' ' + propertyLabel(p));\n\t\t}\n\t\toperation typeLabel(t : uml::Type[1]) : String[1]\n\t\t{\n\t\t\tbody: if t <> null then packageLabel(t.package) + '::' + nameLabel(t.name) else 'null' endif;\n\t\t}\n\t\toperation typeLabels(types : uml::Type[*] { ordered }) : String[1]\n\t\t{\n\t\t\tbody: types->sortedBy(nameLabel(name))->iterate(t; acc : String = '' | acc + ' ' + typeLabel(t));\n\t\t}\n\t\tattribute label : String[1] { transient }\n\t\t{\n\t\t\tinitial: label();\n\t\t}\n\t}\n\tclass Mappings\n\t{\n\t\tproperty mappings : Mapping[*] { ordered composes };\n\t}\n\tabstract class PackageMapping extends Mapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: packageLabels(oldPackages);\n\t\t}\n\t\tproperty oldPackages : uml::Package[*] { ordered };\n\t}\n\tabstract class OperationMapping extends Mapping\n\t{\n\t\tproperty oldOperations : uml::Operation[*] { ordered };\n\t}\n\tabstract class PropertyMapping extends Mapping\n\t{\n\t\tproperty oldProperties : uml::Property[*] { ordered };\n\t}\n\tabstract class TypeMapping extends Mapping\n\t{\n\t\toperation label() : String[1]\n\t\t{\n\t\t\tbody: typeLabels(oldTypes);\n\t\t}\n\t\tproperty oldTypes : uml::Type[*] { ordered };\n\t}\n}";
        URI ecoreURI1 = this.getTestFileURI("Bug473249a.ecore");
        URI outputURI = this.getTestFileURI("Bug473249.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource resource = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        this.replace(xtextResource, "'operationLabels(oldOperations)'", "operationLabels(oldOperations)");
        EditTests.assertNoResourceErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        URI ecoreURI2 = this.getTestFileURI("Bug473249b.ecore");
        Resource resource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        ocl.dispose();
    }

    public void testEdit_Reclass_ecore_383285() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        String testDocument_class = "package p1 : p2 = 'p3' {\n    class C : 'java.lang.Object';\n}\n";
        String testDocument_datatype = "package p1 : p2 = 'p3' {\n    datatype C : 'java.lang.Object';\n}\n";
        URI ecoreURI_class = this.getTestFileURI("test-class.ecore");
        URI ecoreURI_datatype = this.getTestFileURI("test-datatype.ecore");
        OCL ocl_class = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        OCL ocl_datatype = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        Resource ecoreResource_class = this.getEcoreFromCS(ocl_class, testDocument_class, ecoreURI_class);
        Resource ecoreResource_datatype = this.getEcoreFromCS(ocl_datatype, testDocument_datatype, ecoreURI_datatype);
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument_class);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource ecoreResource1 = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource_class, ecoreResource1);
        this.replace(xtextResource, "class", "datatype");
        EditTests.assertNoResourceErrors("Reclassing to datatype", (Resource)xtextResource);
        URI ecoreURI2 = this.getTestFileURI("test2.ecore");
        Resource ecoreResource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource_datatype, ecoreResource2);
        this.replace(xtextResource, "datatype", "class");
        EditTests.assertNoResourceErrors("Reclassing to class", (Resource)xtextResource);
        URI ecoreURI3 = this.getTestFileURI("test3.ecore");
        Resource ecoreResource3 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource_class, ecoreResource3);
        ocl_class.dispose();
        ocl_datatype.dispose();
        ocl.dispose();
    }

    public void testEdit_Comments() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        String testDocument_uncommented = "package p1 : p2 = 'p3' {\n    class C : 'java.lang.Object';\n}\n";
        String testDocument_commented = "package p1 : p2 = 'p3' {\n    /* a comment */\n    class C : 'java.lang.Object';\n}\n";
        String testDocument_recommented = "package p1 : p2 = 'p3' {\n    /*\n\t  *\tyet \n\t  *\tanother \n\t  *\tcomment\n\t  */\n    class C : 'java.lang.Object';\n}\n";
        URI ecoreURI_uncommented = this.getTestFileURI("test-uncommented.ecore");
        URI ecoreURI_commented = this.getTestFileURI("test-commented.ecore");
        URI ecoreURI_recommented = this.getTestFileURI("test-recommented.ecore");
        OCL ocl_uncommented = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        OCL ocl_commented = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        OCL ocl_recommented = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        Resource ecoreResource_uncommented = this.getEcoreFromCS(ocl_uncommented, testDocument_uncommented, ecoreURI_uncommented);
        Resource ecoreResource_commented = this.getEcoreFromCS(ocl_commented, testDocument_commented, ecoreURI_commented);
        Resource ecoreResource_recommented = this.getEcoreFromCS(ocl_recommented, testDocument_recommented, ecoreURI_recommented);
        this.assertHasComments(ecoreResource_uncommented, new String[0]);
        this.assertHasComments(ecoreResource_commented, new String[]{"a comment"});
        this.assertHasComments(ecoreResource_recommented, new String[]{"yet\nanother\ncomment"});
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument_uncommented);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource ecoreResource1 = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource_uncommented, ecoreResource1);
        this.replace(xtextResource, "class", "/* a comment */class");
        EditTests.assertNoResourceErrors("Adding comment", (Resource)xtextResource);
        URI ecoreURI2 = this.getTestFileURI("test2.ecore");
        Resource ecoreResource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource_commented, ecoreResource2);
        this.replace(xtextResource, "/* a comment */", "/* yet\n* another\n * comment */");
        EditTests.assertNoResourceErrors("Changing comment", (Resource)xtextResource);
        URI ecoreURI3 = this.getTestFileURI("test3.ecore");
        Resource ecoreResource3 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource_recommented, ecoreResource3);
        this.replace(xtextResource, "/* yet\n* another\n * comment */", "");
        EditTests.assertNoResourceErrors("Removing comment", (Resource)xtextResource);
        URI ecoreURI4 = this.getTestFileURI("test4.ecore");
        Resource ecoreResource4 = EditTests.as2ecore(ocl, asResource, ecoreURI4, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource_uncommented, ecoreResource4);
        ocl_uncommented.dispose();
        ocl_commented.dispose();
        ocl_recommented.dispose();
        ocl.dispose();
    }

    public void testEdit_Refresh_ecore_382230() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl0 = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        String testDocument = "package tutorial : tuttut = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Library\n\t{\n\t\tproperty books#library : Book[*] { composes };\n\t}\n\tclass Book\n\t{\n\t\tproperty library#books : Library[?];\n\t\tproperty name : String;\n\t\tinvariant NameNotEmpty: name->notEmpty();\n\t}\n}\n";
        URI ecoreURI = this.createEcoreFile(ocl0, "RefreshTest.ecore", testDocument, true);
        ocl0.dispose();
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)EditTests.getProjectMap(), null);
        Resource ecoreResource = (Resource)ClassUtil.nonNullEMF((Object)ocl1.getResourceSet().getResource(ecoreURI, true));
        EditTests.assertNoResourceErrors("Ecore load", ecoreResource);
        EditTests.assertNoValidationErrors("Ecore load", ecoreResource);
        ASResource asResource = ocl1.ecore2as(ecoreResource);
        EditTests.assertNoResourceErrors("Pivot load", (Resource)asResource);
        EditTests.assertNoValidationErrors("Pivot load", (Resource)asResource);
        HashSet<EObject> loadPivotContent = new HashSet<EObject>();
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            loadPivotContent.add(eObject);
        }
        BaseCSResource xtextResource1 = (BaseCSResource)ocl1.getResourceSet().createResource(ecoreURI.appendFileExtension("oclinecore"), "org.eclipse.ocl.xtext.oclinecore");
        xtextResource1.setURI(ecoreURI);
        ocl1.as2cs(asResource, (CSResource)xtextResource1);
        EditTests.assertNoResourceErrors("Xtext load", (Resource)xtextResource1);
        EditTests.assertNoValidationErrors("Xtext load", (Resource)xtextResource1);
        ListBasedDiagnosticConsumer diagnosticsConsumer1 = new ListBasedDiagnosticConsumer();
        xtextResource1.update((IDiagnosticConsumer)diagnosticsConsumer1);
        HashSet<EObject> parsePivotContent = new HashSet<EObject>();
        TreeIterator tit2 = asResource.getAllContents();
        while (tit2.hasNext()) {
            EObject eObject = (EObject)tit2.next();
            parsePivotContent.add(eObject);
        }
        EditTests.assertEquals((int)loadPivotContent.size(), (int)parsePivotContent.size());
        EditTests.assertEquals(loadPivotContent, parsePivotContent);
        StringWriter writer = new StringWriter();
        URIConverter.WriteableOutputStream outputStream = new URIConverter.WriteableOutputStream((Writer)writer, "UTF-8");
        ecoreResource.save((OutputStream)outputStream, XMIUtil.createSaveOptions());
        ecoreResource.unload();
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(writer.toString().replace("tuttut", "tut"), "UTF-8");
        ecoreResource.load((InputStream)inputStream, null);
        EditTests.assertNoResourceErrors("Ecore reload", ecoreResource);
        EditTests.assertNoValidationErrors("Ecore reload", ecoreResource);
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)ocl1.getEnvironmentFactory());
        ecore2as.update((Resource)asResource, (Collection)ClassUtil.nonNullEMF((Object)ecoreResource.getContents()));
        EditTests.assertNoResourceErrors("Pivot reload", ecoreResource);
        EditTests.assertNoValidationErrors("Pivot reload", ecoreResource);
        HashSet<EObject> newPivotContent = new HashSet<EObject>();
        TreeIterator tit3 = asResource.getAllContents();
        while (tit3.hasNext()) {
            EObject eObject = (EObject)tit3.next();
            newPivotContent.add(eObject);
        }
        EditTests.assertEquals((int)loadPivotContent.size(), (int)newPivotContent.size());
        EditTests.assertEquals(loadPivotContent, newPivotContent);
        BaseCSResource xtextResource2 = (BaseCSResource)ocl1.getResourceSet().createResource(ecoreURI.appendFileExtension("oclinecore"), "org.eclipse.ocl.xtext.oclinecore");
        xtextResource2.setURI(ecoreURI);
        ocl1.as2cs(asResource, (CSResource)xtextResource2);
        EditTests.assertNoResourceErrors("Xtext load", (Resource)xtextResource2);
        EditTests.assertNoValidationErrors("Xtext load", (Resource)xtextResource2);
        ListBasedDiagnosticConsumer diagnosticsConsumer2 = new ListBasedDiagnosticConsumer();
        xtextResource2.update((IDiagnosticConsumer)diagnosticsConsumer2);
        HashSet<EObject> reparsePivotContent = new HashSet<EObject>();
        TreeIterator tit4 = asResource.getAllContents();
        while (tit4.hasNext()) {
            EObject eObject = (EObject)tit4.next();
            reparsePivotContent.add(eObject);
        }
        EditTests.assertEquals((int)loadPivotContent.size(), (int)reparsePivotContent.size());
        EditTests.assertEquals(loadPivotContent, reparsePivotContent);
        ocl.dispose();
    }

    public void testEdit_Rename_ecore() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        String testDocument = "module m1 \npackage p1 : p2 = 'p3' {\n}\n";
        URI ecoreURI0 = this.getTestFileURI("test0.ecore");
        OCL ocl1 = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        Resource ecoreResource0 = this.getEcoreFromCS(ocl1, testDocument, ecoreURI0);
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        Resource ecoreResource1 = EditTests.as2ecore(ocl, asResource, ecoreURI1, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource0, ecoreResource1);
        xtextResource.update(0, 0, " ");
        EditTests.assertNoResourceErrors("Adding space", (Resource)xtextResource);
        URI ecoreURI2 = this.getTestFileURI("test2.ecore");
        Resource ecoreResource2 = EditTests.as2ecore(ocl, asResource, ecoreURI2, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource0, ecoreResource2);
        xtextResource.update(0, 1, "");
        EditTests.assertNoResourceErrors("Deleting space", (Resource)xtextResource);
        URI ecoreURI3 = this.getTestFileURI("test3.ecore");
        Resource ecoreResource3 = EditTests.as2ecore(ocl, asResource, ecoreURI3, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource0, ecoreResource3);
        this.replace(xtextResource, "p1", "pkg");
        EditTests.assertNoResourceErrors("Renaming", (Resource)xtextResource);
        URI ecoreURI4 = this.getTestFileURI("test4.ecore");
        Resource ecoreResource4 = EditTests.as2ecore(ocl, asResource, ecoreURI4, NO_MESSAGES);
        ((EPackage)ecoreResource0.getContents().get(0)).setName("pkg");
        TestUtil.assertSameModel(ecoreResource0, ecoreResource4);
        ocl1.dispose();
        ocl.dispose();
    }

    public void testEdit_Rename_Restore_ecore() throws Exception {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)EditTests.getProjectMap(), null);
        String testDocument = "package TestPackage : tp = 'TestPackage'\n{\n\tclass TestClass1 {\n\t\tproperty testProperty1 : Integer;\n\t\toperation testOperation(i : Integer) : Integer;\n\t\tinvariant testInvariant: 1 = 0;\n\t}\n\tclass TestClass2 {\n\t\tproperty testProperty2 : TestClass1[1];\n\t\tproperty testProperty3 : Integer[*];\n\t\tinvariant testInvariant: testProperty2.testProperty1 = testProperty2.testOperation(123456);\n\t}\n}\n";
        URI ecoreURI0 = this.getTestFileURI("test0.ecore");
        OCL ocl1 = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        Resource ecoreResource0 = this.getEcoreFromCS(ocl1, testDocument, ecoreURI0);
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = (CSResource)ClassUtil.nonNullState((Object)ocl.getCSResource(outputURI, testDocument));
        Resource asResource = EditTests.cs2as((OCL)ocl, xtextResource, null);
        Resource ecoreResource1 = EditTests.as2ecore((OCL)ocl, asResource, ecoreURI1, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource0, ecoreResource1);
        Type pivotTestClass1 = (Type)ClassUtil.nonNullState((Object)ocl.getMetamodelManager().getPrimaryType("TestPackage", "TestClass1", new String[0]));
        this.doRename((OCL)ocl, xtextResource, asResource, "TestClass1", "Testing", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", pivotTestClass1.getName()}), StringUtil.bind((String)PivotMessagesInternal.UnresolvedProperty_ERROR_, (Object[])new Object[]{"OclInvalid", "testProperty1"}), StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"OclInvalid", "testOperation", "123456"})), SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "Testing", "TestClass1", NO_MESSAGES, NO_MESSAGES));
        pivotTestClass1 = ocl.getMetamodelManager().getPrimaryType("TestPackage", "TestClass1", new String[0]);
        this.doRename((OCL)ocl, xtextResource, asResource, "testProperty1", "tProperty", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedProperty_ERROR_, (Object[])new Object[]{"" + pivotTestClass1, "testProperty1"})), SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "tProperty", "testProperty1", NO_MESSAGES, NO_MESSAGES));
        this.doRename((OCL)ocl, xtextResource, asResource, "testOperation", "tOperation", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"" + pivotTestClass1, "testOperation", "123456"})), SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "tOperation", "testOperation", NO_MESSAGES, NO_MESSAGES));
        this.doRename((OCL)ocl, xtextResource, asResource, "testOperation(i : Integer)", "testOperation()", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"" + pivotTestClass1, "testOperation", "123456"})), SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "testOperation()", "testOperation(i : Integer)", NO_MESSAGES, NO_MESSAGES));
        this.doRename((OCL)ocl, xtextResource, asResource, "testOperation(i : Integer)", "testOperation(s : String)", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"" + pivotTestClass1, "testOperation", "Integer"})), SUPPRESS_VALIDATION);
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "testOperation(s : String)", "testOperation(i : Integer)", NO_MESSAGES, NO_MESSAGES));
        ocl1.dispose();
        ocl.dispose();
    }

    public void testEdit_StaleReference_ecore() throws Exception {
        String targetRelease = System.getProperty("targetRelease");
        if (targetRelease != null) {
            System.err.println(String.valueOf(this.getTestName()) + " skipped for " + targetRelease + " - parse failure");
            return;
        }
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)EditTests.getProjectMap(), null);
        String testDocument = "package TestPackage : tp = 'TestPackage'\n{\n\tclass TestClass1 {\n\t\tproperty testProperty1 : Integer;\n\t\toperation testOperation() : Integer;\n\t\tinvariant testInvariant: 1 = 0;\n\t}\n\tclass TestClass2 {\n\t\tproperty testProperty2 : TestClass1[*];\n\t\tinvariant testInvariant: testProperty2?->select(testOperation() = testProperty1)->isEmpty();\n\t}\n}\n";
        URI ecoreURI0 = this.getTestFileURI("test0.ecore");
        OCL ocl1 = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        Resource ecoreResource0 = this.getEcoreFromCS(ocl1, testDocument, ecoreURI0);
        URI ecoreURI1 = this.getTestFileURI("test1.ecore");
        URI outputURI = this.getTestFileURI("test.oclinecore");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as((OCL)ocl, xtextResource, null);
        Resource ecoreResource1 = EditTests.as2ecore((OCL)ocl, asResource, ecoreURI1, NO_MESSAGES);
        TestUtil.assertSameModel(ecoreResource0, ecoreResource1);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        Type pivotTestClass1 = (Type)ClassUtil.nonNullState((Object)metamodelManager.getPrimaryType("TestPackage", "TestClass1", new String[0]));
        String testClassName2 = NameUtil.qualifiedNameFor((Object)metamodelManager.getPrimaryType("TestPackage", "TestClass2", new String[0]));
        String message2 = StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, (Object[])new Object[]{"\u00abinvariant\u00bb", testClassName2, "\"testProperty2?->select(testOperation() = testProperty1)->isEmpty()\"\n\tThe 'CallExp::TypeIsNotInvalid' constraint is violated for '1_.oclBadOperation()'\n\tThe 'VariableExp::TypeIsNotInvalid' constraint is violated for '1_'\n\tThe 'VariableDeclaration::TypeIsNotInvalid' constraint is violated for '1_ : OclInvalid[1]'"});
        this.doRename((OCL)ocl, xtextResource, asResource, "TestClass1", "Testing", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", pivotTestClass1.getName()})), EditTests.getMessages(message2));
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "Testing", "TestClass1", NO_MESSAGES, NO_MESSAGES));
        pivotTestClass1 = (Type)ClassUtil.nonNullState((Object)metamodelManager.getPrimaryType("TestPackage", "TestClass1", new String[0]));
        this.doRename((OCL)ocl, xtextResource, asResource, "TestClass1", "Testing", EditTests.getMessages(StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", pivotTestClass1.getName()})), EditTests.getMessages(message2));
        TestUtil.assertSameModel(ecoreResource0, this.doRename((OCL)ocl, xtextResource, asResource, "Testing", "TestClass1", NO_MESSAGES, NO_MESSAGES));
        pivotTestClass1 = metamodelManager.getPrimaryType("TestPackage", "TestClass1", new String[0]);
        ocl1.dispose();
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testEdit_StaleSpecialization() throws Exception {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)EditTests.getProjectMap(), null);
        String testDocument = "import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\ntype MyType conformsTo OclAny{\noperation testFunction() : Boolean;\n}\n}\n";
        URI outputURI = this.getTestFileURI("test.oclstdlib");
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        CompleteModelInternal completeModel = metamodelManager.getCompleteModel();
        ModelContext modelContext = new ModelContext((EnvironmentFactory)ocl.getEnvironmentFactory(), outputURI);
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)modelContext.createBaseResource(testDocument);
        Resource asResource = EditTests.cs2as((OCL)ocl, (CSResource)xtextResource, null);
        EditTests.assertResourceErrors("Loading input", (Resource)xtextResource, new String[0]);
        EditTests.assertNoResourceErrors("Loading input", asResource);
        Type myType = (Type)ClassUtil.nonNullState((Object)metamodelManager.getPrimaryType("http://www.eclipse.org/ocl/2015/Library", "MyType", new String[0]));
        SequenceType sequenceType = ocl.getStandardLibrary().getSequenceType();
        @NonNull CollectionTypeParametersImpl typeParameters = new CollectionTypeParametersImpl(myType, true, null, null);
        CompleteClassInternal sequenceCompleteClass = metamodelManager.getCompleteClass((Type)sequenceType);
        WeakReference<CollectionType> sequenceMyType = new WeakReference<CollectionType>(completeModel.findCollectionType(sequenceCompleteClass, (CollectionTypeParameters)typeParameters));
        EditTests.assertNull(sequenceMyType.get());
        this.doRename((OCL)ocl, (CSResource)xtextResource, asResource, "Boolean", "Sequence(MyType)", NO_MESSAGES, NO_MESSAGES);
        sequenceMyType = new WeakReference<CollectionType>(completeModel.findCollectionType(sequenceCompleteClass, (CollectionTypeParameters)typeParameters));
        EditTests.assertNotNull(sequenceMyType.get());
        this.doRename((OCL)ocl, (CSResource)xtextResource, asResource, "Sequence(MyType)", "Set(MyType)", NO_MESSAGES, NO_MESSAGES);
        System.gc();
        sequenceMyType = new WeakReference<CollectionType>(completeModel.findCollectionType(sequenceCompleteClass, (CollectionTypeParameters)typeParameters));
        boolean isNull = this.debugStateRef(sequenceMyType);
        sequenceMyType = null;
        EditTests.assertTrue((boolean)isNull);
        ocl.dispose();
    }

    public void testEdit_Paste_CompleteOCL() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testDocument = "package ocl\ncontext IterateExp\ninv True: true\n/*$$*/\ncontext IteratorExp\ndef: IsTrue() : Boolean = true\ninv True: IsTrue()\nendpackage\n";
        String pasteText = "context IterateExp\ninv False: true\n";
        URI outputURI = this.getTestFileURI("test.ocl");
        CSResource xtextResource = ocl.getCSResource(outputURI, testDocument);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        EditTests.assertNoResourceErrors("Loading", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Loading", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Loading", asResource);
        EditTests.assertNoValidationErrors("Loading", asResource);
        this.replace(xtextResource, "/*$$*/", pasteText);
        EditTests.assertNoResourceErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Pasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        ocl.dispose();
    }

    public void testEdit_Paste_OCLstdlib() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)EditTests.getProjectMap());
        String goodString = "coercion toUnlimitedNatural";
        String badString = "coer cion toUnlimitedNatural";
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        ProjectManager projectMap = ocl.getProjectManager();
        projectMap.initializeResourceSet(ocl.getResourceSet());
        @NonNull URI libURI = URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model/OCL-2.5.oclstdlib", (boolean)true);
        CSResource xtextResource = ocl.getCSResource(libURI);
        Resource asResource = EditTests.cs2as(ocl, xtextResource, null);
        EditTests.assertNoResourceErrors("Loading", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Loading", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Loading", asResource);
        EditTests.assertNoValidationErrors("Loading", asResource);
        this.replace(xtextResource, goodString, badString);
        EditTests.assertResourceErrors("Pasting operation", (Resource)xtextResource, "mismatched input 'coer' expecting '}'", "missing EOF at 'type'");
        EditTests.assertNoResourceErrors("Pasting operation", asResource);
        EditTests.assertNoValidationErrors("Pasting operation", asResource);
        this.replace(xtextResource, badString, goodString);
        EditTests.assertNoResourceErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoValidationErrors("Unpasting operation", (Resource)xtextResource);
        EditTests.assertNoResourceErrors("Unpasting operation", asResource);
        EditTests.assertNoValidationErrors("Unpasting operation", asResource);
        ocl.dispose();
    }

    public class DebugRef {
        public final Object object;

        DebugRef(Object object) {
            this.object = object;
        }
    }
}

