/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.examples.xtext.tests.bug477283.a.Bug477283APackage;
import org.eclipse.ocl.examples.xtext.tests.bug477283.b.Bug477283BPackage;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;

public class ImportTests
extends XtextTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ImportTests.configurePlatformResources();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected @NonNull TestOCL createOCL() {
        TestCaseAppender.INSTANCE.uninstall();
        return new TestOCL(this.getTestFileSystem(), "ImportTests", this.getName(), (ProjectManager)ImportTests.getProjectMap());
    }

    protected void createTestImport_OCLinEcore_Bug353793_Files() throws IOException {
        TestOCL ocl = this.createOCL();
        String testFileA = "package A1 : A2 = 'http://A3'{\n    class A;\n}\n";
        this.createOCLinEcoreFile("Bug353793A.oclinecore", testFileA);
        String testFileB = "package B1 : B2 = 'http://B3'{\n    class B;\n}\n";
        this.createOCLinEcoreFile("Bug353793B.oclinecore", testFileB);
        String testFileE = "package E1 : E2 = 'http://E3'{\n    class E;\n}\n";
        this.createEcoreFile((OCL)ocl, "Bug353793E", testFileE);
        String testFileF = "package F1 : F2 = 'http://F3'{\n    class F;\n}\n";
        this.createEcoreFile((OCL)ocl, "Bug353793F", testFileF);
        ocl.dispose();
    }

    protected String getNoSuchFileMessage() {
        if (ImportTests.isWindows()) {
            return String.valueOf(FileNotFoundException.class.getName()) + ": {0} (The system cannot find the file specified)";
        }
        return String.valueOf(FileNotFoundException.class.getName()) + ": {0} (No such file or directory)";
    }

    public void testImport_CompleteOCL_Ecore() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.ecore", (OCL)ocl, ImportTests.getTestModelURI("models/ecore/Names.ecore"));
        String testFile = "import 'Names.ecore'\npackage names\ncontext Named\ninv Bogus: r.toString() = s.toString()\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_EcoreAS() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.ecore", (OCL)ocl, ImportTests.getTestModelURI("models/ecore/Names.ecore"));
        String testFile = "import 'Names.ecore.oclas#/'\npackage names\ncontext Named\ninv Bogus: r.toString() = s.toString()\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_OCLinEcore() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.oclinecore", (OCL)ocl, ImportTests.getTestModelURI("models/oclinecore/Names.oclinecore"));
        String testFile = "import 'Names.oclinecore'\npackage EMOF\ncontext Class\ninv Bogus: isAbstract <> null\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_OCLstdlib() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.ecore", (OCL)ocl, ImportTests.getTestModelURI("models/ecore/Names.ecore"));
        this.getTestFileURI("minimal.oclstdlib", (OCL)ocl, ImportTests.getTestModelURI("models/oclstdlib/minimal.oclstdlib"));
        String testFile = "library 'minimal.oclstdlib'\nimport 'Names.ecore'\npackage names\ncontext Named\ninv Bogus: r.toString() and s.toString()\nendpackage\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperation_ERROR_, (Object[])new Object[]{"String", "toString"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperation_ERROR_, (Object[])new Object[]{"Real", "toString"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"OclInvalid", "and", "OclInvalid"}));
        this.doBadLoadFromString(ocl, "string.ocl", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_custom_OCLstdlib() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.ecore", (OCL)ocl, ImportTests.getTestModelURI("models/ecore/Names.ecore"));
        this.getTestFileURI("minimal.oclstdlib", (OCL)ocl, ImportTests.getTestModelURI("models/oclstdlib/minimal.oclstdlib"));
        String customLibrary = "library lib {\ntype Real : PrimitiveType {\noperation spacedOut() : String => 'org.eclipse.ocl.examples.test.xtext.ImportTests$SpacedOut';\n}\n}\n";
        this.createOCLinEcoreFile("custom.oclstdlib", customLibrary);
        String testFile = "library 'minimal.oclstdlib'\nlibrary 'custom.oclstdlib'\nimport 'Names.ecore'\npackage names\ncontext Named\ninv Custom_Real_SpacedOut_Exists: r.spacedOut()\ninv Standard_Real_ToString_DoesNotExist: r.toString()\nendpackage\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperation_ERROR_, (Object[])new Object[]{"Real", "toString"}));
        this.doBadLoadFromString(ocl, "string.ocl", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_custom_OCLstdlib_eval() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        TestOCL ocl = this.createOCL();
        String customLibrary = "library lib : lib = 'http://custom.oclstdlib' {\n\ttype Real : PrimitiveType {\n\t\toperation spacedOut() : String => 'org.eclipse.ocl.examples.test.xtext.ImportTests$SpacedOut';\n\t}\n}";
        ClassLoader classLoader = SpacedOut.class.getClassLoader();
        assert (classLoader != null);
        ocl.getMetamodelManager().addClassLoader(classLoader);
        this.doLoadFromString((OCL)ocl, "custom.oclstdlib", customLibrary);
        ocl.assertQueryEquals(null, "42", "42.spacedOut()");
        ocl.dispose();
    }

    public void testImport_CompleteOCL_UML() throws Exception {
        UMLStandaloneSetup.init();
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.uml", (OCL)ocl, ImportTests.getTestModelURI("models/uml/Names.uml"));
        String testFile = "import 'Names.uml'\npackage unames\ncontext UNamed\ninv Bogus: r.toString() = s.toString()\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_NoSuchFile() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFile = "import 'NoSuchFile1'\nimport 'NoSuchFile2.ocl'\nimport 'NoSuchFile1'\n";
        BagImpl bag = new BagImpl();
        String template2 = this.getNoSuchFileMessage();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile2.ocl", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile2.ocl").toFileString()})}));
        this.doBadLoadFromString(ocl, "string.ocl", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_CompleteOCLAS() throws Exception {
        TestOCL ocl = this.createOCL();
        String moreCompleteOCL = "package ocl\ncontext _'Real'\ndef: isPositive(z : Integer) : Boolean = true\nendpackage\n";
        this.createOCLinEcoreFile("more.ocl", moreCompleteOCL);
        String testFile = "import 'more.ocl.oclas#/'\npackage ocl\ncontext _'Real'\ndef: signum : Integer = 0\ncontext _'Integer'\ninv CheckIt: isPositive(1) = signum > 0\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_OCLinEcore_Bug353793_Good() throws Exception {
        TestOCL ocl = this.createOCL();
        this.createTestImport_OCLinEcore_Bug353793_Files();
        String testFileGood = "import 'http://www.eclipse.org/emf/2002/Ecore';\nimport A0 : 'Bug353793A.oclinecore';\nimport 'Bug353793B.oclinecore';\nimport 'Bug353793E.ecore';\nimport F0 : 'Bug353793F.ecore';\nimport G0 : 'Bug353793F.ecore#/';\npackage C1 : C2 = 'C3'\n{\n    class AD01 extends A0::A1::A;\n    class BD1 extends B1::B;\n    class ED1 extends E1::E;\n    class FD01 extends F0::F1::F;\n    class GD0 extends G0::F;\n}\n";
        this.doLoadFromString((OCL)ocl, "Bug353793good.oclinecore", testFileGood);
        ocl.dispose();
    }

    public void testImport_OCLinEcore_Bug353793_Bad() throws Exception {
        TestOCL ocl = this.createOCL();
        this.createTestImport_OCLinEcore_Bug353793_Files();
        String testFileBad = "import 'http://www.eclipse.org/emf/2002/Ecore';\nimport A0 : 'Bug353793A.oclinecore';\nimport 'Bug353793B.oclinecore';\nimport 'Bug353793E.ecore';\nimport F0 : 'Bug353793F.ecore';\nimport G0 : 'Bug353793F.ecore#/';\npackage C1 : C2 = 'C3'\n{\n    class AD0 extends A0::A;\n    class AD1 extends A1::A;\n    class AD2 extends _'http://A3'::A;\n    class AD3 extends A2::A;\n    class AD4 extends A3::A;\n    class AD011 extends A0::A1::A1::A;\n    class BD0 extends B0::B;\n    class BD01 extends B0::B1::B;\n    class BD11 extends B1::B1::B;\n    class BD2 extends B2::B;\n    class BD3 extends B3::B;\n    class GDC extends G0::C1::GD01;\n    class GD01 extends G0::F1::F;\n}\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", "A"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "A2"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "A3"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "A1"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "B0"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "B0"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "B1"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "B2"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "B3"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "C1"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "F1"}));
        this.doBadLoadFromString(ocl, "Bug353793bad.oclinecore", testFileBad, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLinEcore_Ecore() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.ecore", (OCL)ocl, ImportTests.getTestModelURI("models/ecore/Names.ecore"));
        String testFile = "import 'Names.ecore';\nimport nnnn : 'Names.ecore#/';\npackage moreNames {\nclass MoreNames {\nattribute n1 : names::Named;\nattribute n2 : nnnn::Named;\nattribute n3 : xyzzy::Named;\nattribute n4 : Named;\n}\n}\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedNamespace_ERROR_, (Object[])new Object[]{"", "xyzzy"}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", "Named"}));
        this.doBadLoadFromString(ocl, "string.oclinecore", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLinEcore_OCLinEcore() throws Exception {
        TestOCL ocl = this.createOCL();
        this.getTestFileURI("Names.oclinecore", (OCL)ocl, ImportTests.getTestModelURI("models/oclinecore/Names.oclinecore"));
        String testFile = "import 'Names.oclinecore';\npackage moreNames {\nclass MoreNames {\nattribute n1 : EMOF::Class;\n}\n}\n";
        BagImpl bag = new BagImpl();
        this.doBadLoadFromString(ocl, "string.oclinecore", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLinEcore_NoSuchFile() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFile = "import 'NoSuchFile1';\nimport 'NoSuchFile2.ecore';\nimport 'NoSuchFile1';\n";
        BagImpl bag = new BagImpl();
        String template2 = this.getNoSuchFileMessage();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile2.ecore", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile2.ecore").toFileString()})}));
        this.doBadLoadFromString(ocl, "string.oclinecore", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLstdlib_OCLstdlib() throws Exception {
        TestOCL ocl = this.createOCL();
        String customLibrary = "library ocl {\ntype Complex : PrimitiveType {\noperation spacedOut() : String => 'org.eclipse.ocl.examples.test.xtext.ImportTests$SpacedOut';\n}\n}\n";
        this.createOCLinEcoreFile("custom.oclstdlib", customLibrary);
        String testFile = "import 'http://www.eclipse.org/ocl/2015/Library';\nimport 'custom.oclstdlib';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\ntype MyType conformsTo OclAny{\noperation mixIn(r : Real, z : Complex, t : MyType) : Boolean;\noperation mixOut(q : WhatsThis) : Boolean;\n}\n}\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedType_ERROR_, (Object[])new Object[]{"", "WhatsThis"}));
        this.doBadLoadFromString(ocl, "string.oclstdlib", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLstdlib_NoSuchFile() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFile = "import 'http://www.eclipse.org/ocl/2015/Library';\nimport 'NoSuchFile1';\nimport 'NoSuchFile2.oclstdlib';\nimport 'NoSuchFile1';\nlibrary anotherOne : xxx = 'http://www.eclipse.org/ocl/2015/Library'{}\n";
        BagImpl bag = new BagImpl();
        String template2 = this.getNoSuchFileMessage();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile1", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile1").toFileString()})}));
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object[])new Object[]{"NoSuchFile2.oclstdlib", StringUtil.bind((String)template2, (Object[])new Object[]{this.getTestFileURI("NoSuchFile2.oclstdlib").toFileString()})}));
        this.doBadLoadFromString(ocl, "string.oclstdlib", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_OCLstdlib_NoURI() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFile = "library anotherOne{}\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)PivotMessagesInternal.MissingLibraryURI_ERROR_);
        this.doBadLoadFromString(ocl, "string.oclstdlib", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testInclude_CompleteOCL() throws Exception {
        TestOCL ocl = this.createOCL();
        String moreCompleteOCL = "package ocl\ncontext _'Real'\ndef: isPositive(z : Integer) : Boolean = true\nendpackage\n";
        this.createOCLinEcoreFile("more.ocl", moreCompleteOCL);
        String testFile = "import 'more.ocl'\npackage ocl\ncontext _'Real'\ndef: signum : Integer = 0\ncontext _'Integer'\ninv CheckIt: isPositive(1) = signum > 0\nendpackage\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public void testInclude_CompleteOCL_UnresolvedOperation() throws Exception {
        TestOCL ocl = this.createOCL();
        String moreCompleteOCL = "package ocl\ncontext _'Real'\ndef: isPositive() : Boolean = true\nendpackage\n";
        this.createOCLinEcoreFile("more.ocl", moreCompleteOCL);
        String testFile = "import 'more.ocl'\npackage ocl\ncontext _'Real'\ndef: signum : Integer = 0\ncontext _'Integer'\ninv CheckIt: isPositive() = signum > 0\ninv unCheckIt: isNegative() = signum < 0\nendpackage\n";
        BagImpl bag = new BagImpl();
        bag.add((Object)StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperation_ERROR_, (Object[])new Object[]{"Integer", "isNegative"}));
        this.doBadLoadFromString(ocl, "string.ocl", testFile, (Bag<String>)bag);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_Bug450196() throws Exception {
        TestOCL ocl = this.createOCL();
        String moreCompleteOCL = "package ocl\ncontext _'Integer'\ndef: isPositive() : Boolean = true\nendpackage\n";
        this.createOCLinEcoreFile("imported.ocl", moreCompleteOCL);
        String testFile = "import 'imported.ocl'\npackage ocl\nendpackage\n";
        ASResource resource = this.doLoadASResourceFromString((OCL)ocl, "importer.ocl", testFile);
        Model root = (Model)resource.getContents().get(0);
        ImportTests.assertEquals((int)1, (int)root.getOwnedImports().size());
        ImportTests.assertNotNull(root.getOwnedImports().get(0));
        ocl.dispose();
    }

    public void testImport_CompleteOCL_NestedPackage_477283() throws Exception {
        Bug477283APackage.eINSTANCE.getClass();
        Bug477283BPackage.eINSTANCE.getClass();
        TestOCL ocl = this.createOCL();
        String testFile = "import 'http://www.eclipse.org/ocl/Bug477283b'\nimport 'http://www.eclipse.org/ocl/Bug477283asubsub'\ncontext b::B\ndef: x(y : asubsub::ASubSub) : Boolean = true\n";
        this.doLoadFromString((OCL)ocl, "Bug477283.ocl", testFile);
        ocl.dispose();
    }

    public void testImport_CompleteOCL_DisposeNoISE() throws Exception {
        Bug477283APackage.eINSTANCE.getClass();
        Bug477283BPackage.eINSTANCE.getClass();
        TestOCL ocl = this.createOCL();
        String testFile = "import 'http://www.eclipse.org/ocl/Bug477283b'\nimport 'http://www.eclipse.org/ocl/Bug477283asub'\ncontext b::B\ndef: x(a : asub::ASub) : Boolean = true\n";
        this.doLoadFromString((OCL)ocl, "string.ocl", testFile);
        ocl.dispose();
    }

    public static class SpacedOut
    extends AbstractSimpleUnaryOperation {
        public static final SpacedOut INSTANCE = new SpacedOut();

        public Object evaluate(@Nullable Object sourceValue) {
            String string = sourceValue == null ? "invalid" : ValueUtil.oclToString((Object)sourceValue);
            return string;
        }
    }
}

