/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.model.OCLmetamodel;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;

public class OCLstdlibTests
extends XtextTestCase {
    public Map<String, Element> computeMoniker2ASMap(Collection<? extends Resource> pivotResources) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Resource resource : pivotResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                assert (eObject.eResource() == resource);
                if (!(eObject instanceof Element) || eObject instanceof TemplateParameter || eObject instanceof Comment) continue;
                Element newElement = (Element)eObject;
                String moniker = AS2Moniker.toString((Element)newElement);
                assert (moniker != null);
                Element oldElement = (Element)map.get(moniker);
                if (oldElement == null) {
                    map.put(moniker, newElement);
                    continue;
                }
                assert (newElement.getClass() == oldElement.getClass());
            }
        }
        return map;
    }

    protected Resource doLoadAS(@NonNull ResourceSet resourceSet, @NonNull URI libraryURI, @NonNull Resource javaResource, boolean validateMonikers) {
        Resource asResource = resourceSet.getResource(libraryURI, true);
        OCLstdlibTests.assertNoResourceErrors("Load failed", asResource);
        OCLstdlibTests.assertNoUnresolvedProxies("File Model", asResource);
        OCLstdlibTests.assertNoValidationErrors("File Model", asResource);
        OCLstdlibTests.assertNoResourceErrors("Java Model", javaResource);
        OCLstdlibTests.assertNoUnresolvedProxies("Java Model", javaResource);
        OCLstdlibTests.assertNoValidationErrors("Java Model", javaResource);
        if (!validateMonikers) {
            return asResource;
        }
        Map<String, Element> fileMoniker2asMap = this.computeMoniker2ASMap(Collections.singletonList(asResource));
        Map<String, Element> javaMoniker2asMap = this.computeMoniker2ASMap(Collections.singletonList(javaResource));
        for (String moniker : fileMoniker2asMap.keySet()) {
            Element fileElement = fileMoniker2asMap.get(moniker);
            Element javaElement = javaMoniker2asMap.get(moniker);
            if (javaElement == null) {
                boolean isExpression = false;
                Element eObject = fileElement;
                while (eObject != null) {
                    if (eObject instanceof ExpressionInOCL || eObject instanceof Constraint || eObject instanceof Annotation) {
                        isExpression = true;
                        break;
                    }
                    eObject = eObject.eContainer();
                }
                if (isExpression) continue;
            }
            OCLstdlibTests.assertNotNull((String)("Missing java element for '" + moniker + "'"), (Object)javaElement);
            java.lang.Class<?> javaElementClass = javaElement.getClass();
            OCLstdlibTests.assertEquals(fileElement.getClass(), javaElementClass);
            if (fileElement instanceof TypedElement) {
                Type fileType = ((TypedElement)fileElement).getType();
                Type javaType = ((TypedElement)javaElement).getType();
                OCLstdlibTests.assertEquals(fileType.getClass(), javaType.getClass());
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                OCLstdlibTests.assertEquals((String)fileMoniker, (String)javaMoniker);
            }
            if (fileElement instanceof Feature) {
                LibraryFeature implementation;
                String fileClass = ((Feature)fileElement).getImplementationClass();
                String javaClass = ((Feature)javaElement).getImplementationClass();
                if (fileClass == null && (implementation = ((Feature)fileElement).getImplementation()) != null) {
                    fileClass = implementation.getClass().getCanonicalName();
                }
                if (javaClass == null && (implementation = ((Feature)javaElement).getImplementation()) != null) {
                    javaClass = implementation.getClass().getCanonicalName();
                }
                OCLstdlibTests.assertEquals((String)fileClass, (String)javaClass);
            }
            if (!(fileElement instanceof Class)) continue;
            ArrayList fileTypes = new ArrayList(((Class)fileElement).getSuperClasses());
            ArrayList javaTypes = new ArrayList(((Class)javaElement).getSuperClasses());
            Collections.sort(fileTypes, MonikeredComparator.INSTANCE);
            Collections.sort(javaTypes, MonikeredComparator.INSTANCE);
            OCLstdlibTests.assertEquals((int)fileTypes.size(), (int)javaTypes.size());
            int i = 0;
            while (i < fileTypes.size()) {
                Element fileType = (Element)fileTypes.get(i);
                Element javaType = (Element)javaTypes.get(i);
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                OCLstdlibTests.assertEquals((String)fileMoniker, (String)javaMoniker);
                ++i;
            }
        }
        return asResource;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadAsString() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCLstdlibTests.getProjectMap());
        String testFile = "library lib : lib = 'http://mylib'{\n    type OclAny : AnyType {\n    \toperation a(elem : Boolean) : Integer {\n           post a: elem;\n       }\n    }\n    type Bag(T) : BagType conformsTo Collection(T) {}\n    type Class conformsTo OclAny {}\n    type Boolean : PrimitiveType conformsTo OclAny {}\n    type Collection(T) : CollectionType conformsTo OclAny {}\n    type Enumeration conformsTo OclAny {}\n    type Integer : PrimitiveType conformsTo Real {}\n    type OclComparable conformsTo OclAny {\n        operation compareTo(that : OclSelf) : Integer[1] => 'org.eclipse.ocl.pivot.library.oclany.OclComparableCompareToOperation';\n    }\n    type OclElement conformsTo OclAny {}\n    type OclInvalid : InvalidType {}\n    type OclSelf : SelfType conformsTo OclAny {}\n    type OrderedCollection(T) : CollectionType conformsTo Collection(T) {}\n    type OrderedSet(T) : OrderedSetType conformsTo Collection(T) {}\n    type Real : PrimitiveType conformsTo OclComparable {}\n    type Sequence(T) : SequenceType conformsTo Collection(T) {}\n    type Set(T) : SetType conformsTo Collection(T) {}\n    type String : PrimitiveType conformsTo OclAny {}\n    type UniqueCollection(T) : CollectionType conformsTo Collection(T) {}\n    type UnlimitedNatural : PrimitiveType conformsTo Integer {}\n}\n";
        this.doLoadFromString(ocl, "string.oclstdlib", testFile);
        ocl.dispose();
    }

    public void testImport() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCLstdlibTests.getProjectMap());
        this.getTestFileURI("minimal.oclstdlib", ocl, OCLstdlibTests.getTestModelURI("models/oclstdlib/minimal.oclstdlib"));
        String testFile = "import 'minimal.oclstdlib';\nimport 'minimal.oclstdlib';\nlibrary lib : lib = 'http://minimal.oclstdlib'{\n    type OclAny : AnyType {\n    \toperation a(elem : Boolean) : Boolean {\n           post a: result = elem;\n       }\n    }\n}\n";
        ASResource asResource = this.doLoadASResourceFromString(ocl, "string.oclstdlib", testFile);
        PivotMetamodelManager metamodelManager = PivotMetamodelManager.getAdapter((ResourceSet)asResource.getResourceSet());
        AnyType oclAnyType = metamodelManager.getStandardLibrary().getOclAnyType();
        Iterable ownedOperations = metamodelManager.getAllOperations((Type)oclAnyType, FeatureFilter.SELECT_NON_STATIC);
        OCLstdlibTests.assertEquals((int)2, (int)Iterables.size((Iterable)ownedOperations));
        ocl.dispose();
    }

    public void testOCLstdlib() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLstdlibTests.getProjectMap().initializeResourceSet(resourceSet);
        URI libraryURI = URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model/OCL-2.5.oclstdlib", (boolean)true);
        BaseCSResource xtextResource = (BaseCSResource)resourceSet.createResource(libraryURI);
        JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        InputStream inputStream = ocl.getResourceSet().getURIConverter().createInputStream(libraryURI);
        xtextResource.load(inputStream, null);
        CS2AS cs2as = xtextResource.findCS2AS();
        OCLstdlibTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource fileResource = cs2as.getASResource();
        OCLstdlibTests.assertNoResourceErrors("File Model", (Resource)fileResource);
        OCLstdlibTests.assertNoUnresolvedProxies("File Model", (Resource)fileResource);
        OCLstdlibTests.assertNoValidationErrors("File Model", (Resource)fileResource);
        OCLstdlib javaResource = OCLstdlib.getDefault();
        OCLstdlibTests.assertNoResourceErrors("Java Model", (Resource)javaResource);
        OCLstdlibTests.assertNoUnresolvedProxies("Java Model", (Resource)javaResource);
        OCLstdlibTests.assertNoValidationErrors("Java Model", (Resource)javaResource);
        Map<String, Element> fileMoniker2asMap = this.computeMoniker2ASMap(Collections.singletonList(fileResource));
        Map<String, Element> javaMoniker2asMap = this.computeMoniker2ASMap(Collections.singletonList(javaResource));
        for (String moniker : fileMoniker2asMap.keySet()) {
            Element fileElement = fileMoniker2asMap.get(moniker);
            Element javaElement = javaMoniker2asMap.get(moniker);
            if (javaElement == null) {
                boolean isExpression = false;
                Element eObject = fileElement;
                while (eObject != null) {
                    if (eObject instanceof ExpressionInOCL || eObject instanceof Constraint || eObject instanceof Annotation) {
                        isExpression = true;
                        break;
                    }
                    eObject = eObject.eContainer();
                }
                if (isExpression) continue;
            }
            OCLstdlibTests.assertNotNull((String)("Missing java element for '" + moniker + "'"), (Object)javaElement);
            java.lang.Class<?> javaElementClass = javaElement.getClass();
            OCLstdlibTests.assertEquals(fileElement.getClass(), javaElementClass);
            if (fileElement instanceof TypedElement) {
                Type fileType = ((TypedElement)fileElement).getType();
                Type javaType = ((TypedElement)javaElement).getType();
                OCLstdlibTests.assertEquals(fileType.getClass(), javaType.getClass());
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                OCLstdlibTests.assertEquals((String)fileMoniker, (String)javaMoniker);
            }
            if (fileElement instanceof Feature) {
                LibraryFeature implementation;
                String fileClass = ((Feature)fileElement).getImplementationClass();
                String javaClass = ((Feature)javaElement).getImplementationClass();
                if (fileClass == null && (implementation = ((Feature)fileElement).getImplementation()) != null) {
                    fileClass = implementation.getClass().getCanonicalName();
                }
                if (javaClass == null && (implementation = ((Feature)javaElement).getImplementation()) != null) {
                    javaClass = implementation.getClass().getCanonicalName();
                }
                OCLstdlibTests.assertEquals((String)fileClass, (String)javaClass);
            }
            if (!(fileElement instanceof Class)) continue;
            ArrayList fileTypes = new ArrayList(((Class)fileElement).getSuperClasses());
            ArrayList javaTypes = new ArrayList(((Class)javaElement).getSuperClasses());
            Collections.sort(fileTypes, MonikeredComparator.INSTANCE);
            Collections.sort(javaTypes, MonikeredComparator.INSTANCE);
            OCLstdlibTests.assertEquals((int)fileTypes.size(), (int)javaTypes.size());
            int i = 0;
            while (i < fileTypes.size()) {
                Element fileType = (Element)fileTypes.get(i);
                Element javaType = (Element)javaTypes.get(i);
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                OCLstdlibTests.assertEquals((String)fileMoniker, (String)javaMoniker);
                ++i;
            }
        }
        ocl.dispose();
    }

    public void testOCLstdlib_AS() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCLstdlibTests.getProjectMap());
        URI libraryURI = URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/OCL-2.5.oclas", (boolean)true);
        OCLstdlib javaResource = OCLstdlib.getDefault();
        Resource asResource = this.doLoadAS(ocl.getMetamodelManager().getASResourceSet(), libraryURI, (Resource)javaResource, true);
        ocl.dispose();
    }

    public void testPivot_AS() throws Exception {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)OCLstdlibTests.getProjectMap(), null);
        URI pivotURI = URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/Pivot.oclas", (boolean)true);
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Library asLibrary = (Library)standardLibrary.getPackage();
        Package oclMetamodel = OCLmetamodel.create((StandardLibraryInternal)standardLibrary, (String)asLibrary.getName(), (String)asLibrary.getNsPrefix(), (String)"http://www.eclipse.org/ocl/2015/Pivot");
        Resource javaResource = oclMetamodel.eResource();
        Resource asResource = this.doLoadAS(ocl.getMetamodelManager().getASResourceSet(), pivotURI, javaResource, false);
        ocl.dispose();
    }

    public static class MonikeredComparator
    implements Comparator<Element> {
        public static final Comparator<? super Element> INSTANCE = new MonikeredComparator();

        @Override
        public int compare(Element o1, Element o2) {
            String m1 = AS2Moniker.toString((Element)o1);
            String m2 = AS2Moniker.toString((Element)o2);
            return m1.compareTo(m2);
        }
    }
}

