/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.StandaloneExtraProjectsManager;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestFolder;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.resource.ProjectManager;

public class JUnitStandaloneFileSystem
extends TestFileSystem {
    protected final @NonNull Map<@NonNull String, @NonNull JUnitStandaloneTestProject> projectName2testProject = new HashMap<String, JUnitStandaloneTestProject>();

    public static @NonNull JUnitStandaloneFileSystem create(@NonNull TestFileSystemHelper helper) {
        return new JUnitStandaloneFileSystem(helper);
    }

    public JUnitStandaloneFileSystem(@NonNull TestFileSystemHelper helper) {
        super(helper);
    }

    @Override
    public @NonNull TestProject getTestProject(@NonNull String projectName, boolean cleanProject) {
        JUnitStandaloneTestProject testProject = this.projectName2testProject.get(projectName);
        if (testProject == null) {
            URI newUri = URI.createPlatformResourceURI((String)projectName, (boolean)true);
            File projectFolder = new File(projectName).getAbsoluteFile();
            if (cleanProject) {
                if (projectFolder.exists()) {
                    TestUtil.deleteDirectory(projectFolder);
                }
                projectFolder.mkdirs();
                File settingsFolder = new File(projectFolder, ".settings");
                settingsFolder.mkdir();
                File resourcesFile = new File(settingsFolder, "org.eclipse.core.resources.prefs");
                this.helper.createFile(resourcesFile, this.getResourcesPreferenceContents());
                File runtimeFile = new File(settingsFolder, "org.eclipse.core.runtime.prefs");
                this.helper.createFile(runtimeFile, this.getRuntimePreferenceContents());
                File dotProjectFile = new File(projectFolder, ".project");
                if (!dotProjectFile.exists()) {
                    this.helper.createDotProjectFile(projectFolder, projectName);
                    this.helper.createDotClasspathFile(projectFolder, projectName);
                    this.helper.createManifestFile(projectFolder, projectName);
                    this.helper.createBuildDotProperties(projectFolder, projectName);
                }
            }
            testProject = new JUnitStandaloneTestProject(newUri, projectFolder);
            this.projectName2testProject.put(projectName, testProject);
        }
        return testProject;
    }

    public String toString() {
        return "platform:/resource/* => .test*";
    }

    protected static class JUnitStandaloneTestFile
    implements TestFile {
        protected final @NonNull URI platformURI;
        protected final @NonNull File file;

        public JUnitStandaloneTestFile(@NonNull URI platformURI, @NonNull File file) {
            this.platformURI = platformURI;
            this.file = file;
        }

        @Override
        public @NonNull File getFile() {
            return this.file;
        }

        @Override
        public @NonNull String getFileString() {
            return String.valueOf(this.file);
        }

        @Override
        public @NonNull URI getFileURI() {
            return URI.createFileURI((String)this.file.toString());
        }

        @Override
        public @NonNull String getName() {
            return this.file.getName();
        }

        @Override
        public @NonNull URI getURI() {
            return this.platformURI;
        }

        public void mkdir() {
            if (!this.file.exists()) {
                this.file.mkdir();
            }
        }

        public String toString() {
            return String.valueOf(this.platformURI.toString()) + " => " + this.file.toString();
        }
    }

    protected static class JUnitStandaloneTestFolder
    extends JUnitStandaloneTestFile
    implements TestFolder {
        public JUnitStandaloneTestFolder(@NonNull URI platformURI, @NonNull File file) {
            super(platformURI, file);
            this.mkdir();
        }

        public @NonNull JUnitStandaloneTestFile createFile(@NonNull String name) {
            URI newURI = this.platformURI.appendSegment(name);
            File newFile = new File(this.file, name);
            return new JUnitStandaloneTestFile(newURI, newFile);
        }

        public @NonNull JUnitStandaloneTestFolder createFolder(@NonNull String name) {
            URI newURI = this.platformURI.appendSegment(name);
            File newFolder = new File(this.file, name);
            return new JUnitStandaloneTestFolder(newURI, newFolder);
        }

        @Override
        public @NonNull IContainer getIContainer() {
            throw new IllegalStateException();
        }
    }

    protected static class JUnitStandaloneTestProject
    extends JUnitStandaloneTestFolder
    implements TestProject {
        public JUnitStandaloneTestProject(@NonNull URI platformURI, @NonNull File file) {
            super(platformURI, file);
        }

        @Override
        public @NonNull TestFile copyFile(@NonNull URIConverter uriConverter, @Nullable TestFolder testFolder, @NonNull URI sourceURI) throws IOException {
            InputStream inputStream = uriConverter.createInputStream(sourceURI);
            String lastSegment = sourceURI.lastSegment();
            assert (lastSegment != null);
            if (testFolder != null) {
                lastSegment = String.valueOf(testFolder.getName()) + "/" + lastSegment;
            }
            return this.getOutputFile(lastSegment, inputStream);
        }

        protected @NonNull JUnitStandaloneTestFile createFilePath(@NonNull String testFilePath) {
            JUnitStandaloneTestFolder node = this;
            @NonNull String[] testFileSegments = testFilePath.split("/");
            if (testFilePath.endsWith("/")) {
                int i = 0;
                while (i < testFileSegments.length) {
                    node = node.createFolder(testFileSegments[i]);
                    ++i;
                }
                return node;
            }
            if (testFileSegments.length > 1) {
                int i = 0;
                while (i < testFileSegments.length - 1) {
                    node = node.createFolder(testFileSegments[i]);
                    ++i;
                }
            }
            return node.createFile(testFileSegments[testFileSegments.length - 1]);
        }

        protected @NonNull JUnitStandaloneTestFolder createFolderPath(@NonNull String testFilePath) {
            JUnitStandaloneTestFolder node = this;
            @NonNull String[] testFileSegments = testFilePath.split("/");
            int i = 0;
            while (i < testFileSegments.length) {
                node = node.createFolder(testFileSegments[i]);
                ++i;
            }
            return node;
        }

        @Override
        public @NonNull ProjectManager createTestProjectManager() {
            return new StandaloneExtraProjectsManager(String.valueOf(this.file));
        }

        @Override
        public @NonNull IProject getIProject() {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull String getName() {
            return this.platformURI.segment(1);
        }

        @Override
        public @NonNull JUnitStandaloneTestFile getOutputFile(@NonNull String testFilePath) {
            return this.createFilePath(testFilePath);
        }

        @Override
        public @NonNull JUnitStandaloneTestFile getOutputFile(@NonNull String testFilePath, @NonNull InputStream inputStream) throws IOException {
            String line;
            JUnitStandaloneTestFile node = this.createFilePath(testFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(node.getFile()), "UTF-8");
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
            ((Writer)writer).close();
            reader.close();
            return node;
        }

        @Override
        public @NonNull JUnitStandaloneTestFolder getOutputFolder(@NonNull String testFilePath) {
            JUnitStandaloneTestFile testFolder = this.createFilePath(testFilePath);
            testFolder.mkdir();
            return (JUnitStandaloneTestFolder)testFolder;
        }
    }
}

