/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.xtext.glue.editingdomain;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.editingdomain.ChangeAggregatorAdapter;
import org.eclipse.xtext.resource.XtextResource;

public class UpdateXtextResourceTextCommand {
    public static Command createEMFCommand(final XtextResource xtextResource, final int offset, final int length, final String newText) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)xtextResource);
        if (editingDomain == null) {
            return null;
        }
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final ChangeAggregatorAdapter changeAggregator = (ChangeAggregatorAdapter)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ChangeAggregatorAdapter.class);
        return new RecordingCommand(editingDomain, "update xtext resource"){

            protected void doExecute() {
                try {
                    if (changeAggregator != null) {
                        changeAggregator.setSuspended(true);
                    }
                    xtextResource.update(offset, length, newText);
                    xtextResource.setModified(true);
                }
                finally {
                    if (changeAggregator != null) {
                        changeAggregator.setSuspended(false);
                    }
                }
            }
        };
    }

    public static ICommand createUpdateCommand(final XtextResource xtextResource, final int offset, final int length, final String newText) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)xtextResource);
        if (editingDomain == null) {
            return null;
        }
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final ChangeAggregatorAdapter changeAggregator = (ChangeAggregatorAdapter)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ChangeAggregatorAdapter.class);
        return new AbstractTransactionalCommand(editingDomain, "update xtext resource", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    if (changeAggregator != null) {
                        changeAggregator.setSuspended(true);
                    }
                    xtextResource.update(offset, length, newText);
                    xtextResource.setModified(true);
                    CommandResult commandResult = CommandResult.newOKCommandResult();
                    return commandResult;
                }
                catch (Exception exc) {
                    CommandResult commandResult = CommandResult.newErrorCommandResult((Throwable)exc);
                    return commandResult;
                }
                finally {
                    if (changeAggregator != null) {
                        changeAggregator.setSuspended(false);
                    }
                }
            }
        };
    }
}

