/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.openelement.service.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.PapyrusPageInput;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.Activator;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenElementServiceImpl
implements OpenElementService {
    private ServicesRegistry registry;
    private static final String PAPYRUS_EDITOR_ID = "org.eclipse.papyrus.infra.core.papyrusEditor";

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    public IMultiDiagramEditor openElement(EObject viewElement) throws PartInitException, ServiceException {
        URI pageURI = this.getPageForViewElement(viewElement);
        if (pageURI == null) {
            return null;
        }
        IMultiDiagramEditor editor = this.openURI(pageURI);
        this.reveal(editor, viewElement);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    protected void reveal(final IMultiDiagramEditor editor, final EObject element) {
        if (editor != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        URI elementURI = EcoreUtil.getURI((EObject)element);
                        ModelSet modelSet = (ModelSet)editor.getServicesRegistry().getService(ModelSet.class);
                        EObject elementToReveal = modelSet.getEObject(elementURI, false);
                        if (elementToReveal == null) {
                            return;
                        }
                        NavigationService navigationService = (NavigationService)editor.getServicesRegistry().getService(NavigationService.class);
                        if (navigationService != null) {
                            navigationService.navigate((Object)elementToReveal);
                        }
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            });
        }
    }

    public IMultiDiagramEditor openSemanticElement(EObject semanticElement) throws PartInitException, ServiceException {
        URI[] pages = this.getPagesForSemanticElement(semanticElement);
        IMultiDiagramEditor editor = this.openSemanticElement(semanticElement, pages);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    public IMultiDiagramEditor openSemanticElement(EObject semanticElement, Object[] pages) throws PartInitException, ServiceException {
        URI[] pageURIs = new URI[pages.length];
        int i = 0;
        Object[] objectArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Object pageElement = objectArray[n2];
            URI uri = null;
            if (pageElement instanceof EObject) {
                uri = EcoreUtil.getURI((EObject)((EObject)pageElement));
            }
            pageURIs[i++] = uri;
            ++n2;
        }
        IMultiDiagramEditor editor = this.openSemanticElement(semanticElement, pageURIs);
        return editor;
    }

    private IMultiDiagramEditor openSemanticElement(EObject semanticElement, URI[] pageURIs) throws ServiceException, PartInitException {
        IMultiDiagramEditor editor = this.getCurrentEditor();
        if (editor == null) {
            IFile diFile = this.getDiFile(semanticElement);
            editor = this.openURIsInNewEditor(diFile, pageURIs);
        } else {
            final IPageManager pageMngr = (IPageManager)this.registry.getService(IPageManager.class);
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            final LinkedHashSet<EObject> pagesToOpen = new LinkedHashSet<EObject>();
            LinkedHashSet<EObject> pagesToSelect = new LinkedHashSet<EObject>();
            URI[] uRIArray = pageURIs;
            int n = pageURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI pageURI = uRIArray[n2];
                EObject page = modelSet.getEObject(pageURI, true);
                if (pageMngr.allPages().contains(page)) {
                    if (pageMngr.isOpen((Object)page)) {
                        pagesToSelect.add(page);
                    } else {
                        pagesToOpen.add(page);
                    }
                }
                ++n2;
            }
            if (!pagesToOpen.isEmpty()) {
                TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.registry.getService(TransactionalEditingDomain.class);
                RecordingCommand command = new RecordingCommand(editingDomain, "Open pages"){

                    protected void doExecute() {
                        for (EObject page : pagesToOpen) {
                            pageMngr.openPage((Object)page);
                        }
                    }
                };
                editingDomain.getCommandStack().execute((Command)command);
            }
            for (EObject page : pagesToSelect) {
                pageMngr.selectPage((Object)page);
            }
        }
        this.reveal(editor, semanticElement);
        if (editor != null) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        return editor;
    }

    /*
     * Unable to fully structure code
     */
    private URI[] getPagesForSemanticElement(EObject element) {
        try {
            pageManager = (IPageManager)this.registry.getService(IPageManager.class);
            usages = EMFHelper.getUsages((EObject)element);
            result = new LinkedList<URI>();
            block2: for (EStructuralFeature.Setting usage : usages) {
                referencer = usage.getEObject();
                do {
                    if (!pageManager.allPages().contains(referencer)) continue;
                    result.add(EcoreUtil.getURI((EObject)referencer));
                    continue block2;
                } while ((referencer = referencer.eContainer()) != null);
            }
            return result.toArray(new URI[result.size()]);
        }
        catch (ServiceException ex) {
            result = new HashSet<URI>();
            usages = EMFHelper.getUsages((EObject)element);
            ** for (usage : usages)
        }
lbl-1000:
        // 1 sources

        {
            referencer = usage.getEObject();
            while (result.add(EcoreUtil.getURI((EObject)referencer)) && (referencer = referencer.eContainer()) != null) {
            }
            continue;
        }
lbl23:
        // 1 sources

        return result.toArray(new URI[result.size()]);
    }

    private URI getPageForViewElement(EObject viewElement) {
        block5: {
            if (viewElement == null) {
                return null;
            }
            try {
                IPageManager pageManager = (IPageManager)this.registry.getService(IPageManager.class);
                EObject currentViewElement = viewElement;
                while (currentViewElement != null) {
                    if (pageManager.allPages().contains(currentViewElement)) break;
                    currentViewElement = currentViewElement.eContainer();
                }
                if (currentViewElement != null) {
                    return EcoreUtil.getURI((EObject)currentViewElement);
                }
            }
            catch (ServiceException ex) {
                EObject rootElement = EcoreUtil.getRootContainer((EObject)viewElement);
                if (rootElement == null) break block5;
                return EcoreUtil.getURI((EObject)rootElement);
            }
        }
        return null;
    }

    private IFile getDiFile(URI uri) {
        URI fileURI = uri.trimFileExtension().trimFragment();
        if ((fileURI = fileURI.appendFileExtension("di")).isPlatformResource()) {
            if (fileURI.segmentCount() > 1) {
                String projectName = fileURI.segment(1);
                URI baseURI = URI.createPlatformResourceURI((String)(String.valueOf(projectName) + "/"), (boolean)true);
                URI relativeFileURI = fileURI.deresolve(baseURI);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                IFile result = project.getFile(relativeFileURI.toString());
                if (result.exists()) {
                    return result;
                }
                Activator.log.warn("The resource doesn't exist: " + fileURI);
            }
        } else {
            Activator.log.warn("The element is not a platform resource. Cannot convert it to an IFile: " + fileURI);
        }
        return null;
    }

    private IFile getDiFile(EObject element) {
        Resource resource = element.eResource();
        URI fileURI = resource.getURI();
        return this.getDiFile(fileURI);
    }

    private IMultiDiagramEditor getCurrentEditor() {
        try {
            IMultiDiagramEditor currentEditor = (IMultiDiagramEditor)this.registry.getService(IMultiDiagramEditor.class);
            return currentEditor;
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    private IMultiDiagramEditor openURI(URI pageURI) throws ServiceException, PartInitException {
        IMultiDiagramEditor editor = this.getCurrentEditor();
        if (editor == null) {
            IFile diFile = this.getDiFile(pageURI);
            editor = this.openURIsInNewEditor(diFile, new URI[]{pageURI});
        } else {
            final IPageManager pageManager = (IPageManager)this.registry.getService(IPageManager.class);
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            final EObject page = modelSet.getEObject(pageURI, true);
            if (pageManager.allPages().contains(page)) {
                if (pageManager.isOpen((Object)page)) {
                    pageManager.selectPage((Object)page);
                } else {
                    TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.registry.getService(TransactionalEditingDomain.class);
                    RecordingCommand command = new RecordingCommand(editingDomain, "Open page"){

                        protected void doExecute() {
                            pageManager.openPage((Object)page);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)command);
                }
            }
        }
        return editor;
    }

    private IMultiDiagramEditor openURIsInNewEditor(IFile diFile, URI[] pageURIs) throws PartInitException {
        if (diFile == null) {
            return null;
        }
        PapyrusPageInput input = new PapyrusPageInput(diFile, pageURIs, false);
        RunnableWithResult.Impl runnable = new RunnableWithResult.Impl((IEditorInput)input){
            private final /* synthetic */ IEditorInput val$input;
            {
                this.val$input = iEditorInput;
            }

            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IMultiDiagramEditor openedEditor = (IMultiDiagramEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)this.val$input, (String)OpenElementServiceImpl.PAPYRUS_EDITOR_ID);
                    this.setResult(openedEditor);
                    this.setStatus(Status.OK_STATUS);
                }
                catch (PartInitException ex) {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.papyrus.infra.services.openelement", ex.getMessage(), (Throwable)ex));
                }
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getStatus().getSeverity() == 4) {
            throw (PartInitException)runnable.getStatus().getException();
        }
        return (IMultiDiagramEditor)runnable.getResult();
    }
}

