/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.service.types.utils.ClassifierUtils;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class AssociationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssociationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Association)) {
            return false;
        }
        if (this.getLink().getMemberEnds().size() != 2) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!this.getLink().getOwnedEnds().contains((Object)this.getSemanticSource())) {
            return this.getNewSource() instanceof Artifact || this.getNewSource() instanceof DataType || this.getNewSource() instanceof Interface || this.getNewSource() instanceof Signal || this.getNewSource() instanceof StructuredClassifier || this.getNewSource() instanceof Class;
        }
        return this.getNewSource() instanceof Classifier;
    }

    protected boolean canReorientTarget() {
        if (!this.getLink().getOwnedEnds().contains((Object)this.getSemanticTarget())) {
            return this.getNewTarget() instanceof Artifact || this.getNewTarget() instanceof DataType || this.getNewTarget() instanceof Interface || this.getNewTarget() instanceof Signal || this.getNewTarget() instanceof StructuredClassifier || this.getNewTarget() instanceof Class;
        }
        return this.getNewTarget() instanceof Classifier;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getOwnedEnds().contains((Object)this.getSemanticSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getOwnedEnds().contains((Object)this.getSemanticTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    @Deprecated
    private void reorientEnd(Property end, Classifier newEndType) throws ExecutionException {
        end.setType((Type)newEndType);
    }

    @Deprecated
    private void moveEnd(Property end, Classifier newOwner) throws ExecutionException {
        boolean added = ClassifierUtils.addOwnedAttribute(newOwner, end);
        if (!added) {
            throw new UnsupportedOperationException("Cannot add a Property on Classifier " + newOwner.getQualifiedName());
        }
    }

    protected Association getLink() {
        return (Association)this.getElementToEdit();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }

    protected Property getSemanticSource() {
        return (Property)this.getLink().getMemberEnds().get(0);
    }

    protected Property getSemanticTarget() {
        return (Property)this.getLink().getMemberEnds().get(1);
    }
}

