/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;
    private final View newEndView;
    private final View oppositeEndView;
    private final Edge reorientedEdgeView;
    private ConnectorUtils utils = new ConnectorUtils();

    public ConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
        this.reorientedEdgeView = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
        this.newEndView = RequestParameterUtils.getReconnectedEndView((IEditCommandRequest)request);
        this.oppositeEndView = this.reorientDirection == 1 ? this.reorientedEdgeView.getTarget() : this.reorientedEdgeView.getSource();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.getLink().getEnds().size() != 2) {
            return false;
        }
        return this.canReorient(this.newEndView, this.oppositeEndView);
    }

    private boolean canReorient(View newEndView, View oppositeEndView) {
        if (newEndView.getElement() == null || !(newEndView.getElement() instanceof ConnectableElement)) {
            return false;
        }
        if (newEndView != null && oppositeEndView != null) {
            if (newEndView == oppositeEndView) {
                return false;
            }
            if (newEndView.getChildren().contains((Object)oppositeEndView) || oppositeEndView.getChildren().contains((Object)newEndView)) {
                return false;
            }
            if (newEndView.getElement() instanceof Port && oppositeEndView.getElement() instanceof Port && ViewUtil.getContainerView((View)newEndView) == ViewUtil.getContainerView((View)oppositeEndView)) {
                return false;
            }
            if (this.utils.getStructureContainers(newEndView).contains(oppositeEndView) || this.utils.getStructureContainers(oppositeEndView).contains(newEndView)) {
                return false;
            }
            if (this.deduceContainer(newEndView, oppositeEndView) == null) {
                return false;
            }
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        EObject oldOwner = this.getLink().eContainer();
        if (this.reorientDirection == 1) {
            StructuredClassifier newOwner = this.deduceContainer(this.reorientedEdgeView.getTarget(), this.newEndView);
            if (oldOwner != newOwner) {
                this.replaceOwner(this.getLink(), newOwner);
            }
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            StructuredClassifier newOwner = this.deduceContainer(this.reorientedEdgeView.getSource(), this.newEndView);
            if (oldOwner != newOwner) {
                this.replaceOwner(this.getLink(), newOwner);
            }
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        ConnectorEnd reorientedEnd = (ConnectorEnd)this.getLink().getEnds().get(0);
        ConnectorEnd oppositeEnd = (ConnectorEnd)this.getLink().getEnds().get(1);
        return this.reorientEnd(reorientedEnd, oppositeEnd, (ConnectableElement)this.getNewSource(), this.getNewPartWithPort(), this.getNewOppositePartWithPort());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ConnectorEnd reorientedEnd = (ConnectorEnd)this.getLink().getEnds().get(1);
        ConnectorEnd oppositeEnd = (ConnectorEnd)this.getLink().getEnds().get(0);
        return this.reorientEnd(reorientedEnd, oppositeEnd, (ConnectableElement)this.getNewTarget(), this.getNewPartWithPort(), this.getNewOppositePartWithPort());
    }

    private CommandResult reorientEnd(ConnectorEnd end, ConnectorEnd oppositeEnd, ConnectableElement role, Property partWithPort, Property oppositePartWithPort) throws ExecutionException {
        end.setRole(role);
        end.setPartWithPort(partWithPort);
        oppositeEnd.setPartWithPort(oppositePartWithPort);
        return CommandResult.newOKCommandResult();
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }

    protected Element getEndParent(View endView) {
        EObject parent = ViewUtil.getContainerView((View)endView).getElement();
        return parent instanceof Element ? (Element)parent : null;
    }

    private void replaceOwner(Connector connector, StructuredClassifier newOwner) {
        if (newOwner.getOwnedConnector(connector.getName()) != null) {
            String replacementName = NamedElementHelper.getDefaultNameWithIncrementFromBase("connector", (Collection)newOwner.eContents());
            connector.setName(replacementName);
        }
        newOwner.getOwnedConnectors().add((Object)connector);
    }

    private Property getNewPartWithPort() {
        Property partWithPort = null;
        Element newEndParent = this.getEndParent(this.newEndView);
        if (this.newEnd instanceof Port && newEndParent != null && newEndParent instanceof Property && !(newEndParent instanceof Port) && !EcoreUtil.isAncestor((EObject)ViewUtil.getContainerView((View)this.newEndView), (EObject)this.oppositeEndView)) {
            partWithPort = (Property)newEndParent;
        }
        return partWithPort;
    }

    private Property getNewOppositePartWithPort() {
        Property partWithPort = null;
        Element oppositeEndParent = this.getEndParent(this.oppositeEndView);
        if (this.oppositeEndView.getElement() instanceof Port && oppositeEndParent != null && oppositeEndParent instanceof Property && !(oppositeEndParent instanceof Port) && !EcoreUtil.isAncestor((EObject)ViewUtil.getContainerView((View)this.oppositeEndView), (EObject)this.newEndView)) {
            partWithPort = (Property)oppositeEndParent;
        }
        return partWithPort;
    }

    private StructuredClassifier deduceContainer(View source, View target) {
        return new ConnectorUtils().deduceContainer(source, target);
    }
}

