/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.infra.services.edit.commands.IConfigureCommandFactory;
import org.eclipse.papyrus.uml.service.types.command.UnapplyAllStereotypesCommand;
import org.eclipse.papyrus.uml.service.types.helper.DefaultEditHelper;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementEditHelper
extends DefaultEditHelper {
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        if (req.getParameter("IConfigureCommandFactory_ID") != null) {
            IConfigureCommandFactory factory = (IConfigureCommandFactory)req.getParameter("IConfigureCommandFactory_ID");
            return factory.create(req);
        }
        return super.getConfigureCommand(req);
    }

    protected Map<EClass, EReference> getDefaultContainmentFeatures() {
        return super.getDefaultContainmentFeatures();
    }

    @Override
    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand destroyCommand = super.getDestroyElementCommand(req);
        UnapplyAllStereotypesCommand removeStereotypeCommand = null;
        EObject elementToDestroy = req.getElementToDestroy();
        if (elementToDestroy instanceof Element) {
            removeStereotypeCommand = new UnapplyAllStereotypesCommand(req.getEditingDomain(), req.getLabel(), (Element)elementToDestroy);
        }
        if ((destroyCommand = CompositeCommand.compose(removeStereotypeCommand, (ICommand)destroyCommand)) != null) {
            destroyCommand = destroyCommand.reduce();
        }
        return destroyCommand;
    }
}

