/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Dependency> dependentsToDestroy = new ArrayList<Dependency>();
        Collaboration collaboration = (Collaboration)request.getElementToDestroy();
        dependentsToDestroy.addAll(this.getRelatedRoleBindings(collaboration, null));
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        ICommand gmfCommand = null;
        EObject elementToEdit = request.getContainer();
        if (elementToEdit instanceof Collaboration && request.getContainingFeature() == UMLPackage.eINSTANCE.getCollaboration_CollaborationRole()) {
            Collaboration collaboration = (Collaboration)elementToEdit;
            for (Dependency binding : this.getRelatedRoleBindings(collaboration, (ConnectableElement)request.getReferencedObject())) {
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)binding.eContainer());
                if (provider == null) continue;
                DestroyElementRequest req = new DestroyElementRequest((EObject)binding, false);
                ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)req);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)deleteCommand);
            }
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand gmfCommand = null;
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit instanceof Collaboration && request.getFeature() == UMLPackage.eINSTANCE.getCollaboration_CollaborationRole()) {
            Collaboration collaboration = (Collaboration)elementToEdit;
            HashSet deletedRoles = new HashSet();
            deletedRoles.addAll(collaboration.getRoles());
            if (request.getValue() instanceof ConnectableElement) {
                deletedRoles.remove((ConnectableElement)request.getValue());
            } else if (request.getValue() instanceof List) {
                deletedRoles.removeAll((List)request.getValue());
            }
            for (ConnectableElement role : deletedRoles) {
                for (Dependency binding : this.getRelatedRoleBindings(collaboration, role)) {
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)binding.eContainer());
                    if (provider == null) continue;
                    DestroyElementRequest req = new DestroyElementRequest((EObject)binding, false);
                    ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)req);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)deleteCommand);
                }
            }
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private Set<Dependency> getRelatedRoleBindings(Collaboration collaboration, ConnectableElement role) {
        HashSet<Dependency> roleBindings = new HashSet<Dependency>();
        EReference[] ref = new EReference[]{UMLPackage.eINSTANCE.getCollaborationUse_Type()};
        Collection refs = EMFCoreUtil.getReferencers((EObject)collaboration, (EReference[])ref);
        for (Object object : refs) {
            if (!(object instanceof CollaborationUse)) continue;
            CollaborationUse collaborationUse = (CollaborationUse)object;
            for (Dependency roleBinding : collaborationUse.getRoleBindings()) {
                if (role != null && !roleBinding.getClients().contains((Object)role)) continue;
                roleBindings.add(roleBinding);
            }
        }
        return roleBindings;
    }
}

