/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.PopupEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.DefaultXtextSemanticValidator;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.uMLConnectionPointReference.ConnectionPointReferenceRule;
import org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.ui.internal.UMLConnectionPointReferenceActivator;
import org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.validation.UMLConnectionPointReferenceJavaValidator;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;

public class ConnectionPointReferencePopupEditorConfiguration
extends PopupEditorConfiguration {
    private ConnectionPointReference connectionPoint;
    private List<Pseudostate> newEntries = new ArrayList<Pseudostate>();
    private List<Pseudostate> newExits = new ArrayList<Pseudostate>();

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof ConnectionPointReference) {
            ConnectionPointReference ref = (ConnectionPointReference)editedObject;
            String label = "";
            if (!ref.getEntries().isEmpty()) {
                label = String.valueOf(label) + "entry ";
                boolean first = true;
                for (Pseudostate p : ref.getEntries()) {
                    if (!first) {
                        label = String.valueOf(label) + ", ";
                    } else {
                        first = false;
                    }
                    label = String.valueOf(label) + p.getName();
                }
            } else if (!ref.getExits().isEmpty()) {
                label = String.valueOf(label) + "exit ";
                boolean first = true;
                for (Pseudostate p : ref.getExits()) {
                    if (!first) {
                        label = String.valueOf(label) + ", ";
                    } else {
                        first = false;
                    }
                    label = String.valueOf(label) + p.getName();
                }
            }
            return label;
        }
        return "not a ConnectionPointReference";
    }

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        IGraphicalEditPart graphicalEditPart = null;
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        graphicalEditPart = (IGraphicalEditPart)editPart;
        if (!(graphicalEditPart.resolveSemanticElement() instanceof ConnectionPointReference)) {
            return null;
        }
        this.connectionPoint = (ConnectionPointReference)graphicalEditPart.resolveSemanticElement();
        UMLConnectionPointReferenceJavaValidator.init((Element)this.connectionPoint);
        Injector injector = UMLConnectionPointReferenceActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.UMLConnectionPointReference");
        String textToEdit = this.getTextToEdit(graphicalEditPart.resolveSemanticElement());
        String fileExtension = ".conncectionpointreference";
        IXtextEMFReconciler reconciler = new IXtextEMFReconciler(){

            public void reconcile(EObject modelObject, EObject xtextObject) {
                ConnectionPointReferencePopupEditorConfiguration.this.newEntries = new ArrayList();
                ConnectionPointReferencePopupEditorConfiguration.this.newExits = new ArrayList();
                ConnectionPointReferenceRule rule = (ConnectionPointReferenceRule)xtextObject;
                if (!rule.getEntry().isEmpty()) {
                    ConnectionPointReferencePopupEditorConfiguration.this.newEntries.addAll(rule.getEntry());
                } else if (!rule.getExit().isEmpty()) {
                    ConnectionPointReferencePopupEditorConfiguration.this.newExits.addAll(rule.getExit());
                }
                UpdateConnectionPointReferenceCommand updateCommand = new UpdateConnectionPointReferenceCommand(ConnectionPointReferencePopupEditorConfiguration.this.connectionPoint);
                try {
                    TransactionalEditingDomain domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)modelObject);
                    domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
                }
                catch (ServiceException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        return super.createPopupEditorHelper(graphicalEditPart, injector, reconciler, textToEdit, fileExtension, (IXTextSemanticValidator)new DefaultXtextSemanticValidator());
    }

    static TransactionalEditingDomain getEditingDomain(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    protected class UpdateConnectionPointReferenceCommand
    extends AbstractTransactionalCommand {
        private ConnectionPointReference connectionPointReference;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.connectionPointReference.getEntries().clear();
            this.connectionPointReference.getExits().clear();
            this.connectionPointReference.getEntries().addAll((Collection)ConnectionPointReferencePopupEditorConfiguration.this.newEntries);
            this.connectionPointReference.getExits().addAll((Collection)ConnectionPointReferencePopupEditorConfiguration.this.newExits);
            return CommandResult.newOKCommandResult((Object)this.connectionPointReference);
        }

        public UpdateConnectionPointReferenceCommand(ConnectionPointReference connectionPointReference) {
            super(ConnectionPointReferencePopupEditorConfiguration.getEditingDomain((EObject)connectionPointReference), "ConnectionPointReference Update", UpdateConnectionPointReferenceCommand.getWorkspaceFiles((EObject)connectionPointReference));
            this.connectionPointReference = connectionPointReference;
        }
    }
}

