/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.category.PapyrusModelFromExistingDomainModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRootElementPage;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.ui.IWorkbench;

public class InitModelWizard
extends CreateModelWizard {
    private SelectRootElementPage selectRootElementPage;
    private boolean isInitFromExistingDomainModel;

    public boolean isInitModelWizard() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        URI uri = WizardsHelper.getSelectedResourceURI(selection);
        this.isInitFromExistingDomainModel = InitModelWizard.isSupportedDomainModelResource(uri);
        super.init(workbench, selection);
        this.selectRootElementPage = this.createSelectRootElementPage(selection);
        if (this.isCreateFromExistingDomainModel()) {
            this.setWindowTitle(Messages.InitModelWizard_init_papyrus_diagram);
        }
    }

    protected SelectRootElementPage createSelectRootElementPage(IStructuredSelection selection) {
        if (!this.isCreateFromExistingDomainModel()) {
            return null;
        }
        return new SelectRootElementPage(selection);
    }

    protected SelectDiagramKindPage createSelectDiagramKindPage() {
        if (this.isCreateFromExistingDomainModel()) {
            return new SelectDiagramKindPage(false, new SelectDiagramKindPage.CategoryProvider(){

                public String[] getCurrentCategories() {
                    return InitModelWizard.this.getDiagramCategoryIds();
                }
            }, SelectDiagramKindPage.DEFAULT_CREATION_COMMAND_REGISTRY);
        }
        return super.createSelectDiagramKindPage();
    }

    public void addPages() {
        super.addPages();
        this.addPageIfNotNull((IWizardPage)this.selectRootElementPage);
    }

    public static boolean isSupportedDomainModelFile(IFile file) {
        return file != null && InitModelWizard.isSupportedDomainModelResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
    }

    public static boolean isSupportedDomainModelResource(URI uri) {
        return uri != null && "uml".equals(uri.fileExtension());
    }

    public static boolean isSupportedDomainModelFile(IStructuredSelection sselection) {
        URI uri = WizardsHelper.getSelectedResourceURI(sselection);
        return InitModelWizard.isSupportedDomainModelResource(uri);
    }

    protected void createPapyrusModels(ModelSet modelSet, URI newURI) {
        if (this.isCreateFromExistingDomainModel()) {
            PapyrusModelFromExistingDomainModelCommand command = new PapyrusModelFromExistingDomainModelCommand(modelSet, newURI, this.getRoot());
            this.getCommandStack(modelSet).execute((Command)command);
        } else {
            super.createPapyrusModels(modelSet, newURI);
        }
    }

    protected void initDomainModel(ModelSet modelSet, URI newURI, String diagramCategoryId) {
        if (!this.isCreateFromExistingDomainModel()) {
            super.initDomainModel(modelSet, newURI, diagramCategoryId);
        }
    }

    protected void initDiagrams(ModelSet modelSet, String categoryId) {
        this.initDiagrams(modelSet, this.getRoot(), categoryId);
    }

    public boolean isCreateFromExistingDomainModel() {
        return this.isInitFromExistingDomainModel;
    }

    public String getDiagramFileExtension(String diagramCategoryId) {
        if (this.isCreateFromExistingDomainModel()) {
            return "di";
        }
        return super.getDiagramFileExtension(diagramCategoryId);
    }

    private EObject getRoot() {
        if (this.selectRootElementPage != null) {
            return this.selectRootElementPage.getModelElement();
        }
        return null;
    }

    protected static class NewDiagramForExistingModelPage
    extends NewModelFilePage {
        private String myDiagramFileName;

        public NewDiagramForExistingModelPage(IStructuredSelection selection, String modelKindName, String defaultFileName, String diagramExtension) {
            super(selection, modelKindName);
            this.myDiagramFileName = defaultFileName;
            this.setFileName(defaultFileName);
            this.setFileExtension(diagramExtension);
            this.setTitle(Messages.InitModelWizard_init_papyrus_model);
            this.setDescription(Messages.InitModelWizard_init_papyrus_model_desc);
        }

        protected boolean validatePage() {
            if (!super.validatePage()) {
                return false;
            }
            if (!this.myDiagramFileName.equals(this.getFileName())) {
                this.setErrorMessage(Messages.bind((String)Messages.InitModelWizard_diagram_name_is_different_from_domain_model, (Object)this.myDiagramFileName));
                return false;
            }
            return true;
        }
    }
}

