/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewModelFilePage
extends WizardNewFileCreationPage {
    public static final String DEFAULT_NAME = Messages.NewModelFilePage_default_diagram_name;
    public static final String DEFAULT_DIAGRAM_EXTENSION = "di";
    public static final String PAGE_ID = "NewPapyrusModel";

    public NewModelFilePage(IStructuredSelection selection, String modelKindName) {
        this(PAGE_ID, selection, modelKindName);
    }

    public NewModelFilePage(String pageId, IStructuredSelection selection, String modelKindName) {
        super(pageId, selection);
        this.setTitle(NLS.bind((String)Messages.NewModelFilePage_3, (Object)modelKindName));
        this.setDescription(NLS.bind((String)Messages.NewModelFilePage_page_desc, (Object)modelKindName));
        this.setFileExtension(DEFAULT_DIAGRAM_EXTENSION);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(NewModelFilePage.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), this.getFileExtension()));
        this.setPageComplete(this.validatePage());
    }

    public IStatus diagramExtensionChanged(String newExtension) {
        String currentExtension = this.getFileExtension();
        if (!currentExtension.equals(newExtension)) {
            String oldFileName = this.getFileName();
            String newFileName = NewModelFilePage.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), newExtension);
            this.setFileName(newFileName);
            this.setFileExtension(newExtension);
            String message1 = Messages.NewModelFilePage_new_diagram_category_needs_specific_extension;
            String message2 = Messages.bind((String)Messages.NewModelFilePage_diagram_file_was_renamed, (Object)oldFileName, (Object)newFileName);
            String message = String.valueOf(message1) + message2;
            Status resultStatus = new Status(1, "org.eclipse.papyrus.uml.diagram.wizards", message);
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null) {
                resultStatus = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", errorMessage);
            }
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    protected static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (extension == null) {
            extension = "";
        }
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = DEFAULT_NAME;
        }
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        IPath filePath = containerFullPath.append(fileName);
        filePath = containerFullPath.append(fileName);
        filePath = filePath.addFileExtension(extension);
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected void createLinkTarget() {
    }
}

