/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.INewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.NewModelStorageProviderRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectStorageProviderPage
extends WizardPage
implements ISelectionProvider {
    public static final String PAGE_ID = "SelectStorageProvider";
    private final NewModelStorageProviderRegistry registry;
    private CopyOnWriteArrayList<ISelectionChangedListener> selectionListeners = new CopyOnWriteArrayList();
    private List<Button> providerRadioButtons = new ArrayList<Button>(3);
    private Button selection;

    public SelectStorageProviderPage(NewModelStorageProviderRegistry registry) {
        super(PAGE_ID);
        this.registry = registry;
        this.setTitle("Model Storage");
        this.setDescription("Select the kind of storage for the new model.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        SelectionListener buttonListener = this.createRadioButtonListener();
        Composite myComposite = new Composite(parent, 0);
        myComposite.setLayout((Layout)new GridLayout());
        new Label(myComposite, 0).setText("Where would you like to store the new model?");
        Composite selectionArea = new Composite(myComposite, 0);
        selectionArea.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)selectionArea);
        for (NewModelStorageProviderRegistry.Descriptor next : this.registry) {
            final Button newRadio = new Button(selectionArea, 16);
            newRadio.setText(next.getLabel());
            if (this.providerRadioButtons.isEmpty()) {
                newRadio.setSelection(true);
                this.selection = newRadio;
            }
            this.providerRadioButtons.add(newRadio);
            INewModelStorageProvider.ISelectProviderPart part = next.createSelectProviderPart();
            if (part != null) {
                Control partControl = part.createControl(selectionArea);
                GridDataFactory.fillDefaults().grab(true, false).indent(this.convertWidthInCharsToPixels(5), 0).applyTo(partControl);
                part.setEnabled(newRadio.getSelection());
                part.addPartCompleteListener(new INewModelStorageProvider.ISelectProviderPart.IPartCompleteListener(){

                    public void partCompletenessChanged(INewModelStorageProvider.ISelectProviderPart part) {
                        SelectStorageProviderPage.this.updatePageComplete(newRadio);
                    }
                });
            }
            newRadio.setData((Object)new ProviderPair(next, part));
            newRadio.addSelectionListener(buttonListener);
        }
        this.setControl((Control)myComposite);
    }

    private SelectionListener createRadioButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button selected = (Button)e.widget;
                if (selected.getSelection() && selected != SelectStorageProviderPage.this.selection) {
                    SelectStorageProviderPage.this.select(selected);
                }
            }
        };
    }

    private void select(Button radioButton) {
        this.selection.setSelection(false);
        this.updateEnablement(this.selection);
        this.selection = radioButton;
        this.updateEnablement(this.selection);
        this.updatePageComplete(this.selection);
        this.fireSelectionEvent();
    }

    private void updateEnablement(Button radioButton) {
        ProviderPair pair = this.getProvider(radioButton);
        if (pair.part != null) {
            pair.part.setEnabled(radioButton.getSelection());
        }
    }

    private ProviderPair getProvider(Button radioButton) {
        return (ProviderPair)radioButton.getData();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.addIfAbsent(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getProvider((Button)this.selection).provider);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            Button newSelection = null;
            for (Button next : this.providerRadioButtons) {
                if (this.getProvider(next) != first) continue;
                newSelection = next;
                break;
            }
            if (newSelection != null && newSelection != this.selection) {
                newSelection.setSelection(true);
                this.select(newSelection);
            }
        }
    }

    private void updatePageComplete(Button providerButton) {
        ProviderPair pair = this.getProvider(providerButton);
        this.setPageComplete(pair.part == null || pair.part.isPartComplete());
    }

    private void fireSelectionEvent() {
        if (!this.selectionListeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener next : this.selectionListeners) {
                try {
                    next.selectionChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in selection listener.", (Throwable)e);
                }
            }
        }
    }

    private static class ProviderPair {
        final INewModelStorageProvider provider;
        final INewModelStorageProvider.ISelectProviderPart part;

        ProviderPair(INewModelStorageProvider provider, INewModelStorageProvider.ISelectProviderPart part) {
            this.provider = provider;
            this.part = part;
        }
    }
}

