/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class InitFromTemplateCommand
extends RecordingCommand {
    private final Resource myModelUMLResource;
    private final Resource myModelDiResource;
    private final Resource myModelNotationResource;
    private final String myUmlTemplatePath;
    private final String myDiTemplatePath;
    private final String myNotationTemplatePath;
    private final String myPluginId;

    public InitFromTemplateCommand(TransactionalEditingDomain editingDomain, ModelSet modelSet, String pluginId, String umlTemplatePath, String notationTemplatePath, String diTemplatePath) {
        super(editingDomain);
        this.myModelUMLResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        this.myModelDiResource = DiModelUtils.getDiResource((ModelSet)modelSet);
        this.myModelNotationResource = NotationUtils.getNotationResource((ModelSet)modelSet);
        this.myPluginId = pluginId;
        this.myUmlTemplatePath = umlTemplatePath;
        this.myDiTemplatePath = diTemplatePath;
        this.myNotationTemplatePath = notationTemplatePath;
    }

    protected void doExecute() {
        try {
            this.initializeFromTemplate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeFromTemplate() throws IOException {
        Resource templateDiResource = null;
        Resource templateNotationResource = null;
        Resource templateUmlResource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        templateUmlResource = this.loadTemplateResource(this.myUmlTemplatePath, (ResourceSet)resourceSet);
        EList eObjectsToAdd = new ArrayList();
        eObjectsToAdd = templateUmlResource.getContents();
        if (this.myDiTemplatePath != null && this.myNotationTemplatePath != null) {
            String diFileName = WizardsHelper.getFileNameWithoutExtension(this.myDiTemplatePath);
            String umlFileName = WizardsHelper.getFileNameWithoutExtension(this.myUmlTemplatePath);
            String notationFileName = WizardsHelper.getFileNameWithoutExtension(this.myNotationTemplatePath);
            if (diFileName.contentEquals(umlFileName) && diFileName.contentEquals(notationFileName)) {
                if (this.myDiTemplatePath != null) {
                    templateDiResource = this.loadTemplateResource(this.myDiTemplatePath, (ResourceSet)resourceSet);
                }
                if (this.myNotationTemplatePath != null) {
                    templateNotationResource = this.loadTemplateResource(this.myNotationTemplatePath, (ResourceSet)resourceSet);
                }
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                if (templateNotationResource != null) {
                    eObjectsToAdd.addAll(templateNotationResource.getContents());
                }
                if (templateDiResource != null) {
                    eObjectsToAdd.addAll(templateDiResource.getContents());
                }
            }
        }
        ArrayList eObjectsResult = new ArrayList();
        eObjectsResult.addAll(EcoreUtil.copyAll((Collection)eObjectsToAdd));
        for (EObject eObject : eObjectsResult) {
            if (eObject.eContainer() != null) continue;
            if (eObject instanceof Diagram) {
                this.myModelNotationResource.getContents().add((Object)eObject);
                continue;
            }
            if (eObject instanceof SashWindowsMngr) {
                this.myModelDiResource.getContents().clear();
                this.myModelDiResource.getContents().add((Object)eObject);
                continue;
            }
            this.myModelUMLResource.getContents().add((Object)eObject);
        }
    }

    private Resource loadTemplateResource(String path, ResourceSet resourceSet) {
        URL templateURL = Platform.getBundle((String)this.myPluginId).getResource(path);
        String fullUri = templateURL.getPath();
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(this.myPluginId) + fullUri), (boolean)true);
        Resource resource = resourceSet.getResource(uri, true);
        if (resource.isLoaded()) {
            return resource;
        }
        return null;
    }
}

