/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class SemanticUMLContentProvider
extends SemanticEMFContentProvider {
    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, EObject[] roots) {
        super(editedEObject, feature, roots);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature) {
        this(editedEObject, feature, SemanticUMLContentProvider.findRoots(editedEObject));
    }

    public SemanticUMLContentProvider(EObject[] roots) {
        super(roots);
    }

    public SemanticUMLContentProvider(ResourceSet root) {
        this(null, null, root);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, ResourceSet root) {
        this(editedEObject, feature, SemanticUMLContentProvider.getRoots(root));
    }

    protected static EObject[] findRoots(EObject source) {
        if (source.eResource() == null || source.eResource().getResourceSet() == null) {
            return SemanticEMFContentProvider.findRoots((EObject)source);
        }
        return SemanticUMLContentProvider.getRoots(source.eResource().getResourceSet());
    }

    protected static EObject[] getRoots(ResourceSet root) {
        if (root instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)root;
            try {
                return new EObject[]{UmlUtils.getUmlModel(modelSet).lookupRoot()};
            }
            catch (NotFoundException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return SemanticEMFContentProvider.getRoots((ResourceSet)root);
    }

    protected boolean isCompatibleMetaclass(Object containerElement, Object metaclass) {
        Element semanticElement = UMLUtil.resolveUMLElement((Object)containerElement);
        if (semanticElement == null) {
            return false;
        }
        if (metaclass instanceof Stereotype) {
            boolean res;
            Stereotype stereotype = (Stereotype)metaclass;
            boolean bl = res = semanticElement.getAppliedStereotype(stereotype.getQualifiedName()) != null;
            if (!res) {
                EClass definition = stereotype.getDefinition();
                for (EObject e : semanticElement.getStereotypeApplications()) {
                    EClass c = e.eClass();
                    if (definition == null || !definition.isSuperTypeOf(c)) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        if (metaclass instanceof EClassifier) {
            return ((EClassifier)metaclass).isInstance((Object)semanticElement);
        }
        return false;
    }

    public Object getAdaptedValue(Object containerElement) {
        Object semanticElement = super.getAdaptedValue(containerElement);
        if (semanticElement instanceof Element) {
            Element element = (Element)semanticElement;
            for (Object metaclassWanted : this.getWantedMetaclasses()) {
                if (!(metaclassWanted instanceof Stereotype)) continue;
                EObject stereotypeApplication = null;
                stereotypeApplication = element.getStereotypeApplication((Stereotype)metaclassWanted);
                if (stereotypeApplication == null) {
                    EList subStereotypes = element.getAppliedSubstereotypes((Stereotype)metaclassWanted);
                    for (Stereotype subSteretoype : subStereotypes) {
                        stereotypeApplication = element.getStereotypeApplication(subSteretoype);
                        if (stereotypeApplication != null) break;
                    }
                }
                if (stereotypeApplication == null) continue;
                return stereotypeApplication;
            }
        }
        return semanticElement;
    }
}

