/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStereotypePropertyContentProvider
implements IHierarchicContentProvider {
    private List<Profile> profiles;
    private boolean baseProperty;

    public UMLStereotypePropertyContentProvider(List<Profile> profiles) {
        this(profiles, false);
    }

    public UMLStereotypePropertyContentProvider(List<Profile> profiles, boolean baseProperty) {
        this.profiles = profiles;
        this.baseProperty = baseProperty;
    }

    public Object[] getElements() {
        return this.profiles.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        if (this.hasChildren(parentElement)) {
            if (parentElement instanceof Package) {
                for (EObject current : ((Package)parentElement).getOwnedMembers()) {
                    if (!this.hasChildren(current)) continue;
                    children.add(current);
                }
            } else if (parentElement instanceof Stereotype) {
                if (this.baseProperty) {
                    children.addAll((Collection<EObject>)((Stereotype)parentElement).getOwnedAttributes());
                } else {
                    children.addAll(StereotypeUtil.getStereotypePropertiesWithoutBaseProperties((Stereotype)((Stereotype)parentElement)));
                }
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Element) {
            TreeIterator iter = ((EObject)element).eAllContents();
            while (iter.hasNext()) {
                if (!this.isValidValue(iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isValidValue(Object element) {
        if (element instanceof Element) {
            boolean result;
            boolean bl = result = element instanceof Property && ((Element)element).eContainer() instanceof Stereotype;
            if (result && !this.baseProperty) {
                return StereotypeUtil.isValidStereotypeProperty((Property)((Property)element));
            }
            return result;
        }
        return false;
    }
}

