/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences.BlockDefinitionDiagramNodePreferencePage;
import org.eclipse.papyrus.sysml.diagram.common.preferences.LabelPreferenceHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FlowPropertyPreferencePage
extends BlockDefinitionDiagramNodePreferencePage {
    public static String prefKey = "BlockDefinition_shape_sysml_flowproperty_as_label";
    protected Button bttnDirection;
    protected Button bttnVisibility;
    protected Button bttnDerive;
    protected Button bttnName;
    protected Button bttnType;
    protected Button bttnUndefined_Type;
    protected Button bttnMultiplicity;
    protected Button bttnDefault_Multiplicity;
    protected Button bttnDefaultValue;
    protected Button bttnModifiers;
    public static String prefLabelKey = "BlockDefinition_shape_sysml_flowproperty_as_label";
    private String labelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)prefLabelKey, (String)"label.display");
    private int propertyValue = this.getPreferenceStore().getInt(this.labelDisplayPreferenceKey);

    public FlowPropertyPreferencePage() {
        this.setPreferenceKey("BlockDefinition_shape_sysml_flowproperty_as_label");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)prefKey, (String)"label.display"), 2097432);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnDirection = this.createCheckButton((Composite)group, "Direction", 256);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnDirection.setLayoutData((Object)data);
        this.bttnVisibility = this.createCheckButton((Composite)group, "Visibility", 2);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnDirection, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnVisibility.setLayoutData((Object)data);
        this.bttnDerive = this.createCheckButton((Composite)group, "Derive", 4);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnDerive.setLayoutData((Object)data);
        this.bttnName = this.createCheckButton((Composite)group, "Name", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnDerive, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnName.setLayoutData((Object)data);
        this.bttnType = this.createCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.bttnDirection, 5);
        this.bttnType.setLayoutData((Object)data);
        this.bttnUndefined_Type = this.createCheckButton((Composite)group, "Undefined_Type", 0x200000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnDirection, 85);
        data.top = new FormAttachment((Control)this.bttnDirection, 5);
        this.bttnUndefined_Type.setLayoutData((Object)data);
        this.bttnMultiplicity = this.createCheckButton((Composite)group, "Multiplicity", 32);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnVisibility, 85);
        data.top = new FormAttachment((Control)this.bttnDirection, 5);
        this.bttnMultiplicity.setLayoutData((Object)data);
        this.bttnDefault_Multiplicity = this.createCheckButton((Composite)group, "Default_Multiplicity", 0x100000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnDerive, 85);
        data.top = new FormAttachment((Control)this.bttnDirection, 5);
        this.bttnDefault_Multiplicity.setLayoutData((Object)data);
        this.bttnDefaultValue = this.createCheckButton((Composite)group, "DefaultValue", 64);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.bttnType, 5);
        this.bttnDefaultValue.setLayoutData((Object)data);
        this.bttnModifiers = this.createCheckButton((Composite)group, "Modifiers", 128);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnDirection, 85);
        data.top = new FormAttachment((Control)this.bttnType, 5);
        this.bttnModifiers.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.propertyValue = this.getPreferenceStore().getDefaultInt(this.labelDisplayPreferenceKey);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.bttnDirection.setSelection((this.propertyValue & 0x100) == 256);
        this.bttnVisibility.setSelection((this.propertyValue & 2) == 2);
        this.bttnDerive.setSelection((this.propertyValue & 4) == 4);
        this.bttnName.setSelection((this.propertyValue & 8) == 8);
        this.bttnType.setSelection((this.propertyValue & 0x10) == 16);
        this.bttnUndefined_Type.setSelection((this.propertyValue & 0x200000) == 0x200000);
        this.bttnMultiplicity.setSelection((this.propertyValue & 0x20) == 32);
        this.bttnDefault_Multiplicity.setSelection((this.propertyValue & 0x100000) == 0x100000);
        this.bttnDefaultValue.setSelection((this.propertyValue & 0x40) == 64);
        this.bttnModifiers.setSelection((this.propertyValue & 0x80) == 128);
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.propertyValue != store.getInt(this.labelDisplayPreferenceKey)) {
            store.setValue(this.labelDisplayPreferenceKey, this.propertyValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FlowPropertyPreferencePage flowPropertyPreferencePage = FlowPropertyPreferencePage.this;
            flowPropertyPreferencePage.propertyValue = flowPropertyPreferencePage.propertyValue ^ this.style;
            FlowPropertyPreferencePage.this.refreshButtons();
        }
    }
}

