/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.pages;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.papyrus.uml.search.ui.CheckBoxFilteredTree;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.actions.ReplaceAction;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeLabelProvider;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusQuery;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.scope.ScopeCollector;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private static final String REGULAR_EXPRESSION_ILLFORMED = Messages.PapyrusSearchPage_0;
    private static final String SEARCH_ISSUE = Messages.PapyrusSearchPage_1;
    private static final String SEARCH_IN_ALL_STRINGS = Messages.PapyrusSearchPage_2;
    private static final String SEARCH_IN_STEREOTYPE_ATTRIBUTES = Messages.PapyrusSearchPage_3;
    private Text searchQueryText;
    private ISearchPageContainer container;
    private CheckBoxFilteredTree participantTypesTree;
    private CheckboxTreeViewer participantTypesTreeViewer;
    private Label searchQueryExplanatoryLabel;
    private Button btnRegularExpression;
    private Button btnCaseSensitive;
    private Button btnSearchAllStringAttributes;
    private Button btnSearchInStereotypeAttributes;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setFont(parent.getFont());
        searchComposite.setLayout((Layout)new GridLayout(1, false));
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblSearchString = new Label(searchComposite, 0);
        lblSearchString.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblSearchString.setText(Messages.PapyrusSearchPage_4);
        Composite queryComposite = new Composite(searchComposite, 0);
        queryComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        queryComposite.setLayout((Layout)new GridLayout(2, false));
        this.searchQueryText = new Text(queryComposite, 2048);
        this.searchQueryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchQueryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PapyrusSearchPage.this.validateRegex();
            }
        });
        this.searchQueryText.setFocus();
        Composite compositeParameters = new Composite(queryComposite, 0);
        compositeParameters.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        compositeParameters.setLayout((Layout)new GridLayout(1, false));
        this.btnCaseSensitive = new Button(compositeParameters, 32);
        this.btnCaseSensitive.setText(Messages.PapyrusSearchPage_5);
        this.btnRegularExpression = new Button(compositeParameters, 32);
        this.btnRegularExpression.setText(Messages.PapyrusSearchPage_6);
        this.btnRegularExpression.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusSearchPage.this.btnCaseSensitive.setEnabled(!PapyrusSearchPage.this.btnRegularExpression.getSelection());
                PapyrusSearchPage.this.validateRegex();
                PapyrusSearchPage.this.searchQueryText.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.searchQueryExplanatoryLabel = new Label(queryComposite, 0);
        this.searchQueryExplanatoryLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Group grpSearchFor = new Group(searchComposite, 0);
        grpSearchFor.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpSearchFor.setLayout((Layout)new GridLayout(4, false));
        grpSearchFor.setText(Messages.PapyrusSearchPage_8);
        this.participantTypesTree = new CheckBoxFilteredTree((Composite)grpSearchFor, 2816, new PatternFilter(), true);
        this.participantTypesTree.setLayout((Layout)new GridLayout());
        GridData chechboxTreeViewerGridData = new GridData(4, 4, true, true, 4, 1);
        chechboxTreeViewerGridData.heightHint = 150;
        this.participantTypesTree.setLayoutData(chechboxTreeViewerGridData);
        this.participantTypesTreeViewer = (CheckboxTreeViewer)this.participantTypesTree.getViewer();
        this.participantTypesTreeViewer.setContentProvider((IContentProvider)new ParticipantTypeContentProvider(this));
        this.participantTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new ParticipantTypeLabelProvider());
        Button btnSelectAll = new Button((Composite)grpSearchFor, 8);
        btnSelectAll.setText(Messages.PapyrusSearchPage_9);
        btnSelectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PapyrusSearchPage.this.participantTypesTreeViewer.setAllChecked(true);
            }
        });
        Button btnDeselectAll = new Button((Composite)grpSearchFor, 8);
        btnDeselectAll.setText(Messages.PapyrusSearchPage_10);
        btnDeselectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PapyrusSearchPage.this.participantTypesTreeViewer.setAllChecked(false);
            }
        });
        this.btnSearchAllStringAttributes = new Button((Composite)grpSearchFor, 32);
        this.btnSearchAllStringAttributes.setText(SEARCH_IN_ALL_STRINGS);
        this.btnSearchAllStringAttributes.setLayoutData((Object)new GridData(131072, 4, true, false, 0, 0));
        this.btnSearchAllStringAttributes.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PapyrusSearchPage.this.participantTypesTreeViewer.refresh();
            }
        });
        this.btnSearchInStereotypeAttributes = new Button((Composite)grpSearchFor, 32);
        this.btnSearchInStereotypeAttributes.setText(SEARCH_IN_STEREOTYPE_ATTRIBUTES);
        this.btnSearchInStereotypeAttributes.setLayoutData((Object)new GridData(131072, 4, false, false, 0, 0));
        this.btnSearchInStereotypeAttributes.setSelection(true);
        this.participantTypesTreeViewer.setInput((Object)UMLPackage.eINSTANCE);
        this.participantTypesTreeViewer.setAllChecked(true);
        this.setControl((Control)parent);
    }

    public boolean getSearchAllStringAttributes() {
        if (this.btnSearchAllStringAttributes != null) {
            return this.btnSearchAllStringAttributes.getSelection();
        }
        return false;
    }

    private boolean validateRegex() {
        try {
            PatternHelper.getInstance().createPattern(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection());
            this.searchQueryExplanatoryLabel.setForeground(this.getControl().getForeground());
            this.searchQueryExplanatoryLabel.setText("");
            return true;
        }
        catch (PatternSyntaxException e) {
            this.searchQueryExplanatoryLabel.setForeground(Display.getDefault().getSystemColor(3));
            this.searchQueryExplanatoryLabel.setText(e.getDescription());
            return false;
        }
    }

    private Collection<ScopeEntry> createScopeEntries(Collection<IResource> scope) {
        HashSet<ScopeEntry> results = new HashSet<ScopeEntry>();
        for (IResource resource : scope) {
            ScopeEntry scopeEntry = new ScopeEntry(resource);
            results.add(scopeEntry);
        }
        return results;
    }

    public boolean performAction() {
        if (this.validateRegex()) {
            Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
            Collection<ScopeEntry> scopeEntries = this.createScopeEntries(scope);
            PapyrusQuery query = new PapyrusQuery(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchInStereotypeAttributes.getSelection(), scopeEntries, this.participantTypesTreeViewer.getCheckedElements(), this.btnSearchAllStringAttributes.getSelection());
            if (query.canRunInBackground()) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return true;
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
        this.container.setPerformActionEnabled(true);
    }

    public boolean performReplace() {
        if (this.validateRegex()) {
            Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
            Collection<ScopeEntry> scopeEntries = this.createScopeEntries(scope);
            PapyrusQuery query = new PapyrusQuery(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchInStereotypeAttributes.getSelection(), scopeEntries, this.participantTypesTreeViewer.getCheckedElements(), this.btnSearchAllStringAttributes.getSelection());
            NewSearchUI.runQueryInForeground((IRunnableContext)this.container.getRunnableContext(), (ISearchQuery)query);
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    ISearchResultPage page;
                    ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                    if (view != null && (page = view.getActivePage()) instanceof PapyrusSearchResultPage) {
                        PapyrusSearchResultPage resultPage = (PapyrusSearchResultPage)page;
                        ReplaceAction replaceAction = new ReplaceAction(resultPage.getSite().getShell(), resultPage, null);
                        replaceAction.run();
                    }
                }
            });
            NewSearchUI.runQueryInForeground((IRunnableContext)this.container.getRunnableContext(), (ISearchQuery)query);
            return true;
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
        return false;
    }
}

