/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.ModelMatch;
import org.eclipse.papyrus.views.search.results.ResultEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultContentProvider
implements ITreeContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult = null;
    private PapyrusSearchResultPage fPage = null;
    private AbstractTreeViewer fViewer;
    private Map<Object, Set<Object>> fChildrenMap;

    public ResultContentProvider(PapyrusSearchResultPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fViewer = viewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof PapyrusSearchResult) {
            this.fResult = (AbstractTextSearchResult)newInput;
            this.initialize();
        }
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.length) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children;
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    public void clear() {
        this.initialize();
        this.fViewer.refresh();
    }

    private void initialize() {
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
        Set realMatches = MatchUtils.getMatches((AbstractTextSearchResult)this.fResult, (boolean)true);
        for (AbstractResultEntry resultEntry : realMatches) {
            this.insert(resultEntry, false);
        }
    }

    protected boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        boolean found = false;
        for (Object object : children) {
            if (!(child instanceof AbstractResultEntry) || !(object instanceof AbstractResultEntry) || !((AbstractResultEntry)object).equals((Object)((AbstractResultEntry)child))) continue;
            found = true;
            break;
        }
        if (!found) {
            children.add(child);
            return true;
        }
        return false;
    }

    protected Object getUpdateParent(Object child) {
        Object parent = this.getParent(child);
        for (Object key : this.fChildrenMap.keySet()) {
            if (!(key instanceof AbstractResultEntry) || !((AbstractResultEntry)key).equals(parent)) continue;
            if (parent instanceof ModelMatch && key instanceof ResultEntry) {
                for (Object childInMap : this.fChildrenMap.get(key)) {
                    if (!(childInMap instanceof AbstractResultEntry)) continue;
                    ((AbstractResultEntry)childInMap).setParent(parent);
                }
                key = parent;
                continue;
            }
            parent = key;
            ((AbstractResultEntry)child).setParent(parent);
        }
        return parent;
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getUpdateParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getUpdateParent(child);
        }
        if (this.insertChild(this.fResult, child) && refreshViewer) {
            this.fViewer.add((Object)this.fResult, child);
        }
    }

    protected boolean hasChild(Object parent, Object child, Map<Object, Set<Object>> fChildrenMap) {
        Set<Object> children = fChildrenMap.get(parent);
        return children != null && children.contains(child);
    }

    protected void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fViewer.refresh(element);
            }
        } else {
            this.fChildrenMap.remove(element);
            Object parent = this.getUpdateParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (updatedElements[i] instanceof AbstractResultEntry) {
                Set matches = MatchUtils.getMatches((AbstractTextSearchResult)this.fResult, (boolean)true);
                if (matches.contains(updatedElements[i])) {
                    AbstractResultEntry resultEntry = (AbstractResultEntry)updatedElements[i];
                    Object parent = this.getUpdateParent(updatedElements[i]);
                    if (this.hasChild(parent, updatedElements[i], this.fChildrenMap)) {
                        this.fViewer.update(new Object[]{resultEntry, parent}, null);
                    } else {
                        this.insert(updatedElements[i], true);
                    }
                } else {
                    this.remove(updatedElements[i], true);
                }
            } else if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof AbstractResultEntry) {
            AbstractResultEntry match = (AbstractResultEntry)element;
            return match.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

