/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.results;

import com.swtdesigner.ResourceManager;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusQuery;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;

public class PapyrusSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    MatchFilter[] possibleMatchFilter;
    private PapyrusQuery searchQuery;

    public PapyrusSearchResult(PapyrusQuery query) {
        this.searchQuery = query;
        this.possibleMatchFilter = new MatchFilter[0];
    }

    public PapyrusQuery getQuery() {
        return this.searchQuery;
    }

    public void setPossibleMatchFilter(MatchFilter[] possibleMatchFilter) {
        this.possibleMatchFilter = possibleMatchFilter;
    }

    public MatchFilter[] getAllMatchFilters() {
        return this.possibleMatchFilter;
    }

    public String getLabel() {
        return String.valueOf(this.getMatchCount()) + Messages.PapyrusSearchResult_0 + this.searchQuery.getSearchQueryText() + Messages.PapyrusSearchResult_1;
    }

    public String getTooltip() {
        return Messages.PapyrusSearchResult_2;
    }

    public ImageDescriptor getImageDescriptor() {
        return ResourceManager.getPluginImageDescriptor("org.eclipse.papyrus.uml.search.ui", "icons/PapyrusSearch.png");
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        HashSet<AbstractResultEntry> results = new HashSet<AbstractResultEntry>();
        Set allMatches = MatchUtils.getMatches((AbstractTextSearchResult)result, (boolean)true);
        for (AbstractResultEntry modelMatch : allMatches) {
            Object element = modelMatch.getElement();
            if (!(element instanceof ScopeEntry) || !((ScopeEntry)element).getResource().equals((Object)file)) continue;
            results.add(modelMatch);
        }
        Match[] arrayResult = new Match[results.size()];
        return results.toArray(arrayResult);
    }

    public IFile getFile(Object element) {
        if (element instanceof ScopeEntry && ((ScopeEntry)element).getResource() instanceof IFile) {
            return (IFile)((ScopeEntry)element).getResource();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element;
        if (match instanceof AbstractResultEntry && (element = match.getElement()) instanceof ScopeEntry) {
            ((ScopeEntry)element).getResource();
            if (((ScopeEntry)element).getResource().equals((Object)ResourceUtil.getResource((IEditorInput)editor.getEditorInput()))) {
                return true;
            }
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        HashSet<AbstractResultEntry> results = new HashSet<AbstractResultEntry>();
        Set allMatches = MatchUtils.getMatches((AbstractTextSearchResult)result, (boolean)true);
        for (AbstractResultEntry modelMatch : allMatches) {
            Object element = modelMatch.getElement();
            if (!(element instanceof ScopeEntry) || !((ScopeEntry)element).getResource().equals((Object)ResourceUtil.getResource((IEditorInput)editor.getEditorInput()))) continue;
            results.add(modelMatch);
        }
        Match[] arrayResult = new Match[results.size()];
        return results.toArray(arrayResult);
    }
}

