/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstanceSpecificationRoleDisplayEditPolicy
extends GraphicalEditPolicyEx
implements NotificationListener,
IPapyrusListener {
    public static String INSTANCE_SPECIFICATION_ROLE_DISPLAY = "INSTANCE_SPECIFICATION_ROLE_DISPLAY";
    protected Element hostSemanticElement;
    private Property interestingProperty;

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected Element initSemanticElement() {
        return (Element)this.getView().getElement();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.initSemanticElement();
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            if (this.getInterestingProperty() != null) {
                this.getDiagramEventBroker().addNotificationListener((EObject)this.getInterestingProperty(), (NotificationListener)this);
            }
            this.refreshDisplay();
        } else {
            Activator.log.error("No semantic element was found during activation of the mask managed label edit policy", null);
        }
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        if (this.getInterestingProperty() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.getInterestingProperty(), (NotificationListener)this);
        }
        this.hostSemanticElement = null;
    }

    public abstract InstanceSpecification getEnd();

    public Property getInterestingProperty() {
        if (this.interestingProperty != null) {
            return this.interestingProperty;
        }
        if (this.hostSemanticElement != null) {
            ArrayList<Property> array = new ArrayList<Property>();
            InstanceSpecification instanceSpecification = (InstanceSpecification)this.hostSemanticElement;
            if (instanceSpecification.getClassifiers().size() > 0 && instanceSpecification.getClassifiers().get(0) instanceof Association) {
                Association association = (Association)instanceSpecification.getClassifiers().get(0);
                InstanceSpecification sourceElt = this.getEnd();
                for (Property property : association.getMemberEnds()) {
                    if (!sourceElt.getClassifiers().contains((Object)property.getType())) continue;
                    array.add(property);
                }
            }
            if (array.size() == 1) {
                this.interestingProperty = (Property)array.get(0);
            } else if (array.size() > 1) {
                this.interestingProperty = this.getprefvalue(array);
            }
        }
        return this.interestingProperty;
    }

    protected abstract Property getprefvalue(ArrayList<Property> var1);

    protected void refreshDisplay() {
        if (this.hostSemanticElement != null && this.getInterestingProperty() != null) {
            ((WrappingLabel)this.getHostFigure()).setText(this.getInterestingProperty().getName());
        }
    }

    public void notifyChanged(Notification notification) {
        this.refreshDisplay();
    }
}

