/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class SlotDisplayEditPolicy
extends GraphicalEditPolicyEx
implements NotificationListener,
IPapyrusListener {
    public static String SLOT_DISPLAY = "SLOT_DISPLAY";
    protected Element hostSemanticElement;

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected Element initSemanticElement() {
        return (Element)this.getView().getElement();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.initSemanticElement();
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            if (this.hostSemanticElement != null) {
                Slot slot = (Slot)this.hostSemanticElement;
                for (ValueSpecification valueSpecification : slot.getValues()) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)valueSpecification, (NotificationListener)this);
                }
            }
            this.refreshDisplay();
        } else {
            Activator.log.error("No semantic element was found during activation of the mask managed label edit policy", null);
        }
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        if (this.hostSemanticElement != null) {
            Slot slot = (Slot)this.hostSemanticElement;
            for (ValueSpecification valueSpecification : slot.getValues()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)valueSpecification, (NotificationListener)this);
            }
        }
        this.hostSemanticElement = null;
    }

    protected void refreshDisplay() {
        this.getHost().refresh();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 3) {
            if (notification.getFeature().equals(UMLPackage.eINSTANCE.getSlot_Value())) {
                this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
            }
        } else if (notification.getEventType() == 4 && notification.getFeature().equals(UMLPackage.eINSTANCE.getSlot_Value())) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
        }
        this.refreshDisplay();
    }
}

