/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class BlockDropHelper
extends ElementHelper {
    public BlockDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropAsStructureItemOnPart(DropObjectsRequest request, GraphicalEditPart host, IElementType elementType) {
        String label = "";
        if (elementType == SysMLElementTypes.PART_PROPERTY) {
            label = "Create a new Part";
        }
        if (elementType == SysMLElementTypes.REFERENCE_PROPERTY) {
            label = "Create a new Reference";
        }
        if (elementType == SysMLElementTypes.ACTOR_PART_PROPERTY) {
            label = "Create a new ActorPart";
        }
        if (elementType == SysMLElementTypes.VALUE_PROPERTY) {
            label = "Create a new Value";
        }
        if (elementType == UMLElementTypes.PROPERTY) {
            label = "Create a new Property";
        }
        CompoundCommand cc = new CompoundCommand(label);
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidStructureItemType(droppedEObject, elementType)) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject target = this.getHostEObject(host);
        if (!(target instanceof TypedElement) || ((TypedElement)target).getType() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Type targetType = ((TypedElement)target).getType();
        if (!((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)targetType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)targetType, elementType);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetType);
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    public Command getDropAsStructureItem(DropObjectsRequest request, GraphicalEditPart host, IElementType elementType) {
        String label = "";
        if (elementType == SysMLElementTypes.PART_PROPERTY) {
            label = "Create a new Part";
        }
        if (elementType == SysMLElementTypes.REFERENCE_PROPERTY) {
            label = "Create a new Reference";
        }
        if (elementType == SysMLElementTypes.ACTOR_PART_PROPERTY) {
            label = "Create a new ActorPart";
        }
        if (elementType == SysMLElementTypes.VALUE_PROPERTY) {
            label = "Create a new Value";
        }
        if (elementType == UMLElementTypes.PROPERTY) {
            label = "Create a new Property";
        }
        CompoundCommand cc = new CompoundCommand(label);
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidStructureItemType(droppedEObject, elementType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), this.getHostEObject(host), elementType);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getHostEObject(host));
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    private boolean isValidStructureItemType(Object object, IElementType elementType) {
        boolean isValid = false;
        if (object != null && object instanceof Type && !(object instanceof Association)) {
            Type type = (Type)object;
            if ((elementType == SysMLElementTypes.PART_PROPERTY || elementType == SysMLElementTypes.REFERENCE_PROPERTY) && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)type)) {
                isValid = true;
            }
            if (elementType == SysMLElementTypes.ACTOR_PART_PROPERTY && type instanceof Actor) {
                isValid = true;
            }
            if (elementType == SysMLElementTypes.VALUE_PROPERTY && (((ISpecializationType)SysMLElementTypes.VALUE_TYPE).getMatcher().matches((EObject)type) || type instanceof DataType)) {
                isValid = true;
            }
            if (!(elementType != UMLElementTypes.PROPERTY || ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)type) || type instanceof Actor || type instanceof DataType || ((ISpecializationType)SysMLElementTypes.VALUE_TYPE).getMatcher().matches((EObject)type))) {
                isValid = true;
            }
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

