/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.controlmode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.util.TableContentsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTableCommand
extends AbstractTransactionalCommand {
    protected ControlModeRequest request;

    public ControlTableCommand(ControlModeRequest request) {
        super(request.getEditingDomain(), "Move table to new resource", null);
        this.request = request;
        try {
            this.getAffectedFiles().addAll(ControlTableCommand.getWorkspaceFiles(this.getTables()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject objectTOControl = this.request.getTargetObject();
        EMFHelper.getUsages((EObject)objectTOControl);
        Resource newDiResource = this.getTargetDiResource();
        if (newDiResource == null) {
            return CommandResult.newErrorCommandResult((String)"The di model has not been created");
        }
        List<EObject> tables = this.getTables();
        if (!tables.isEmpty()) {
            for (EObject tab : tables) {
                if (!(tab instanceof PapyrusTableInstance)) continue;
                newDiResource.getContents().add((Object)tab);
                newDiResource.getContents().add((Object)((PapyrusTableInstance)tab).getTable());
            }
            this.addMovedTabToRequest(tables);
        }
        return CommandResult.newOKCommandResult((Object)newDiResource);
    }

    protected Resource getTargetDiResource() {
        return this.request.getTargetResource("di");
    }

    public void addMovedTabToRequest(List<EObject> tables) {
        ArrayList<EObject> openables = (ArrayList<EObject>)this.request.getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (openables == null) {
            openables = new ArrayList<EObject>();
        }
        openables.addAll(tables);
        this.request.addParameters(Collections.singletonMap("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables", openables));
    }

    protected List<EObject> getTables() throws ExecutionException {
        return Lists.newArrayList((Iterable)TableContentsUtils.createDescendantTablesIterable((EObject)this.request.getTargetObject()));
    }

    public URI getOldNotationURI() throws ExecutionException {
        URI uri = this.request.getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("di");
        }
        throw new ExecutionException("Unable to retreive URI of the old di model");
    }
}

