/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.preferences.PapyrusScopedPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.dialog.ApplyValueOnPreferenceKeyDialog;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.osgi.service.prefs.Preferences;

public class PapyrusPreferenceStore
extends PapyrusScopedPreferenceStore {
    public void deleteAllSubPreference(String level) {
        ArrayList<Object> keytoRemove = new ArrayList();
        ArrayList<String> elementKey = new ArrayList<String>();
        try {
            int i = 0;
            while (i < this.getStorePreferences().keys().length) {
                if (level.startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
                    if (this.getStorePreferences().keys()[i].startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT)) {
                        elementKey.add(this.getStorePreferences().keys()[i]);
                    }
                } else if (level.startsWith(PreferenceConstantHelper.PAPYRUS_EDITOR_PREFERENCE_PREFIX) && (this.getStorePreferences().keys()[i].startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT) || this.getStorePreferences().keys()[i].startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX))) {
                    elementKey.add(this.getStorePreferences().keys()[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (elementKey.size() > 0) {
            String[] keyRoconsult = new String[elementKey.size()];
            ApplyValueOnPreferenceKeyDialog dialog = new ApplyValueOnPreferenceKeyDialog(elementKey.toArray(keyRoconsult));
            dialog.open();
            keytoRemove = dialog.getKeyToRemove();
            for (String string : keytoRemove) {
                this.getStorePreferences().remove(string);
            }
        }
    }

    public PapyrusPreferenceStore(IScopeContext context, String qualifier) {
        super(context, qualifier);
    }

    public PapyrusPreferenceStore(IScopeContext context, String qualifier, String defaultQualifierPath) {
        super(context, qualifier, defaultQualifierPath);
    }

    protected String findKeyWithAValue(String initialKey) {
        String foundedKey = null;
        foundedKey = this.findKeyAStoreValue(initialKey);
        if (foundedKey == null) {
            foundedKey = this.findKeyWithADefaultValue(initialKey);
        }
        if (foundedKey == null) {
            foundedKey = initialKey;
        }
        return foundedKey;
    }

    protected String findKeyAStoreValue(String initialKey) {
        String foundedKey = null;
        if (this.getStorePreferences().get(initialKey, null) != null) {
            foundedKey = initialKey;
        }
        if (foundedKey == null && this.hasPrefix(initialKey)) {
            foundedKey = this.findKeyAStoreValue(this.getUpperKey(initialKey));
        }
        return foundedKey;
    }

    protected String findKeyWithADefaultValue(String initialKey) {
        String foundedKey = null;
        if (this.getDefaultPreferences().get(initialKey, null) != null) {
            foundedKey = initialKey;
        }
        if (foundedKey == null && this.hasPrefix(initialKey)) {
            return this.findKeyWithADefaultValue(this.getUpperKey(initialKey));
        }
        foundedKey = initialKey;
        return foundedKey;
    }

    protected String getUpperKey(String initialKey) {
        String out = initialKey.toString();
        if (initialKey.startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT)) {
            out = initialKey.toString().replaceAll(PreferenceConstantHelper.DIAGRAM_ELEMENT, PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX);
            out = String.valueOf(out.substring(0, out.lastIndexOf("_"))) + out.substring(out.indexOf("."), out.length());
        }
        if (initialKey.startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
            out = String.valueOf(PreferenceConstantHelper.PAPYRUS_EDITOR_PREFERENCE_PREFIX) + out.substring(out.indexOf("."), out.length());
        }
        return out;
    }

    protected boolean hasPrefix(String key) {
        return key.startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT) || key.startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX);
    }

    protected String internalGet(String key) {
        String newKey = this.findKeyWithAValue(key);
        return Platform.getPreferencesService().get(newKey, null, (Preferences[])this.getPreferenceNodes(true));
    }

    public boolean getDefaultBoolean(String name) {
        return super.getDefaultBoolean(this.findKeyWithADefaultValue(name));
    }

    public double getDefaultDouble(String name) {
        return super.getDefaultDouble(this.findKeyWithADefaultValue(name));
    }

    public float getDefaultFloat(String name) {
        return super.getDefaultFloat(this.findKeyWithADefaultValue(name));
    }

    public int getDefaultInt(String name) {
        return super.getDefaultInt(this.findKeyWithADefaultValue(name));
    }

    public long getDefaultLong(String name) {
        return super.getDefaultLong(this.findKeyWithADefaultValue(name));
    }

    public String getDefaultString(String name) {
        return super.getDefaultString(this.findKeyWithADefaultValue(name));
    }
}

