/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCompartmentGroup
extends AbstractGroup {
    private final List<String> myCompartments;
    private final IPreferenceStore myPreferenceStore;
    private final Set<String> compartmentsWithTitle;

    public NodeCompartmentGroup(Composite parent, String title, DialogPage dialogPage, List<String> compartmentsName, Set<String> compartmentsWithTitle, IPreferenceStore store) {
        super(parent, title, dialogPage);
        this.myCompartments = compartmentsName;
        this.compartmentsWithTitle = compartmentsWithTitle;
        this.myPreferenceStore = store;
        this.createContent(parent);
    }

    protected void createContent(Composite parent) {
        for (String compartment : this.myCompartments) {
            this.addCompartmentVisibilityGroup(parent, compartment);
        }
    }

    private void addCompartmentVisibilityGroup(Composite parent, String compartment) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setText(compartment);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        String compartmentVisibilityPreference = PreferenceConstantHelper.getCompartmentElementConstant(this.getKey(), compartment, 18);
        String compartmentVisibilityLabel = "Show compartment";
        Button showCompartmentButton = this.addCheckboxField((Composite)group, compartmentVisibilityPreference, compartmentVisibilityLabel);
        if (this.compartmentsWithTitle.contains(compartment)) {
            boolean showCompartmentIsNotChecked;
            String compartmentNameVisibilityPreference = PreferenceConstantHelper.getCompartmentElementConstant(this.getKey(), compartment, 19);
            String compartmentNameVisibilityLabel = "Show title";
            Button showNameButton = this.addCheckboxField((Composite)group, compartmentNameVisibilityPreference, compartmentNameVisibilityLabel);
            boolean bl = showCompartmentIsNotChecked = !this.myPreferenceStore.getBoolean(compartmentVisibilityPreference);
            if (showCompartmentIsNotChecked) {
                showNameButton.setEnabled(false);
            }
            this.createDependency(showCompartmentButton, new Control[]{showNameButton});
        }
    }

    private Button addCheckboxField(Composite parent, String preferenceKey, String label) {
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData());
        CheckBoxFieldEditor compartmentVisibilityBooleanFieldEditor = new CheckBoxFieldEditor(preferenceKey, label, plate);
        Button checkbox = compartmentVisibilityBooleanFieldEditor.getCheckbox();
        compartmentVisibilityBooleanFieldEditor.setPage(this.getDialogPage());
        this.addFieldEditor((FieldEditor)compartmentVisibilityBooleanFieldEditor);
        return checkbox;
    }

    private void createDependency(final Button master, final Control[] slaves) {
        SelectionListener dependencyListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(dependencyListener);
    }
}

