/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AbstractPreferenceKeyDialog
extends StatusDialog {
    protected Table keyTable;
    protected TableViewer tableViewer;
    protected String[] keys;

    public AbstractPreferenceKeyDialog(String[] keys) {
        super(new Shell());
        this.keys = keys;
        this.setStatusLineAboveButtons(true);
        this.updateStatus((IStatus)new Status(1, "org.eclipse.papyrus.infra.gmfdiag.preferences", "Would you like to overload those preferences?"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.keyTable = new Table(composite, 2080);
        this.tableViewer = new TableViewer(this.keyTable);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new KeyLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new KeyContentProvider());
        TableColumn column = new TableColumn(this.keyTable, 0);
        column.setWidth(150);
        column.setText("Pref. kind ");
        column = new TableColumn(this.keyTable, 0);
        column.setWidth(90);
        column.setText("Level");
        column = new TableColumn(this.keyTable, 0);
        column.setWidth(200);
        column.setText("Localization");
        this.tableViewer.setInput((Object)this.keys);
        this.keyTable.setHeaderVisible(true);
        return composite;
    }

    protected class KeyContentProvider
    implements IStructuredContentProvider {
        protected KeyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < AbstractPreferenceKeyDialog.this.keys.length) {
                if (AbstractPreferenceKeyDialog.this.keys[i].startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
                    result.add(AbstractPreferenceKeyDialog.this.keys[i]);
                }
                if (AbstractPreferenceKeyDialog.this.keys[i].startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT)) {
                    result.add(AbstractPreferenceKeyDialog.this.keys[i]);
                }
                ++i;
            }
            return result.toArray();
        }
    }

    protected class KeyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        protected KeyLabelProvider() {
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element.toString().startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT)) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.infra.gmfdiag.preferences", "/icons/pref.gif");
                }
                if (element.toString().startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.infra.gmfdiag.preferences", "/icons/diag.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String initialKey = element.toString();
            String out = initialKey.toString();
            if (columnIndex == 0) {
                out = out.substring(out.indexOf(".") + 1, out.length()).toUpperCase();
            }
            if (columnIndex == 1) {
                if (element.toString().startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT)) {
                    return "ELEMENT";
                }
                if (element.toString().startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
                    return "DIAGRAM";
                }
            }
            if (columnIndex == 2) {
                String beforePoint;
                if (initialKey.startsWith(PreferenceConstantHelper.DIAGRAM_ELEMENT) && (out = initialKey.toString().replaceAll(PreferenceConstantHelper.DIAGRAM_ELEMENT, "")).indexOf(".") > 0 && (beforePoint = out.substring(0, out.indexOf("."))).lastIndexOf("_") > 0) {
                    out = String.valueOf(out.substring(beforePoint.lastIndexOf("_") + 1, out.indexOf("."))) + " (" + beforePoint.substring(0, beforePoint.lastIndexOf("_")) + ")";
                }
                if (initialKey.startsWith(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX)) {
                    out = initialKey.toString().replaceAll(PreferenceConstantHelper.DIAGRAM_PREFERENCE_PREFIX, "");
                    out = out.substring(0, out.indexOf("."));
                }
            }
            return out;
        }
    }
}

