/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension.diagrameditor;

import org.eclipse.papyrus.infra.core.editorsfactory.IEditorFactory;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.IPluggableEditorFactory;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;

public class EditorFactoryProxy
implements IEditorFactory {
    private IPluggableEditorFactory editorFactory;
    protected EditorDescriptor editorDescriptor;
    private ServicesRegistry serviceRegistry;

    public EditorFactoryProxy(ServicesRegistry serviceRegistry, EditorDescriptor editorDescriptor) {
        this.serviceRegistry = serviceRegistry;
        this.editorDescriptor = editorDescriptor;
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        try {
            return this.getEditorFactory().createIPageModel(pageIdentifier);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        try {
            return this.getEditorFactory().isPageModelFactoryFor(pageIdentifier);
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected IPluggableEditorFactory getEditorFactory() {
        if (this.editorFactory == null) {
            this.editorFactory = this.createEditorFactory();
        }
        return this.editorFactory;
    }

    private IPluggableEditorFactory createEditorFactory() {
        try {
            this.editorFactory = this.editorDescriptor.getEditorFactoryClass().newInstance();
            this.editorFactory.init(this.serviceRegistry, this.editorDescriptor);
            return this.editorFactory;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

