/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.modelsetquery.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.infra.core.modelsetquery.IFillableModelSetQueryAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSetQueryAdapterSizeMatters
extends EContentAdapter
implements IFillableModelSetQueryAdapter {
    private Map<EClassifier, Collection<EObject>> cache = Collections.synchronizedMap(new IdentityHashMap());
    private Map<EClassifier, Collection<EClassifier>> subTypes = Collections.synchronizedMap(new IdentityHashMap());

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        if (notifier instanceof EObject) {
            EObject eobject = (EObject)notifier;
            this.addObjectInCache(eobject);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
        if (notifier instanceof EObject) {
            EObject eobject = (EObject)notifier;
            this.removeObjectFromCache(eobject);
        }
    }

    private void addObjectInCache(EObject newObj) {
        this.putObjectInCache(newObj);
    }

    private void putObjectInCache(EObject newObj) {
        this.putObjectInMap((EClassifier)newObj.eClass(), newObj);
        this.addSubTypes(newObj.eClass());
    }

    private void addSubTypes(EClass eClassifier) {
        for (EClass superType : eClassifier.getESuperTypes()) {
            this.addSubType(superType, (EClassifier)eClassifier);
            this.addSubTypes(superType);
        }
    }

    protected void addSubType(EClass superType, EClassifier eClassifier) {
        Collection<EClassifier> result = this.subTypes.get(superType);
        if (result == null) {
            result = new HashSet<EClassifier>();
            this.subTypes.put((EClassifier)superType, result);
        }
        result.add(eClassifier);
    }

    private void putObjectInMap(EClassifier eClassifier, EObject obj) {
        Collection<EObject> result = this.cache.get(eClassifier);
        if (result == null) {
            result = new HashSet<EObject>();
            this.cache.put(eClassifier, result);
        }
        result.add(obj);
    }

    private void removeObjectFromCache(EObject newObj) {
        EClass eClass = newObj.eClass();
        this.removeObjectFromCache((EClassifier)eClass, newObj);
    }

    private void removeObjectFromCache(EClassifier eClassifier, EObject newObj) {
        Collection<EObject> listOfClassifiers = this.cache.get(eClassifier);
        if (listOfClassifiers != null) {
            listOfClassifiers.remove(newObj);
            if (listOfClassifiers.isEmpty()) {
                this.cache.remove(eClassifier);
            }
        }
    }

    @Override
    public Collection<EObject> getReachableObjectsOfType(EObject object, EClassifier type) {
        HashSet<EObject> buffer = new HashSet<EObject>();
        HashSet<EClassifier> alreadyComputed = new HashSet<EClassifier>();
        Stack<EClassifier> types = new Stack<EClassifier>();
        types.push(type);
        while (!types.isEmpty()) {
            Collection<EClassifier> c2;
            EClassifier top = (EClassifier)types.pop();
            alreadyComputed.add(top);
            Collection<EObject> c = this.cache.get(top);
            if (c != null) {
                buffer.addAll(c);
            }
            if ((c2 = this.subTypes.get(top)) == null || alreadyComputed.contains(c2)) continue;
            types.addAll(c2);
        }
        return buffer;
    }

    public void dispose() {
        this.cache.clear();
        this.subTypes.clear();
        this.cache = null;
        this.subTypes = null;
    }

    @Override
    public void addEntriesInCache(EClassifier type, HashSet<EObject> list) {
        for (EObject e : list) {
            this.addObjectInCache(e);
        }
    }

    @Override
    public boolean isAlreadyComputed(EClassifier type) {
        return this.cache.containsKey(type);
    }
}

