/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.IVersionableModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelSnippetList;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseModel
implements IVersionableModel {
    public static final String ENCODING = "UTF-8";
    private ModelSet modelSet;
    protected ModelSnippetList snippets = new ModelSnippetList();
    protected Resource resource;
    protected URI resourceURI;

    @Override
    public void init(ModelSet modelManager) {
        this.modelSet = modelManager;
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }

    protected ResourceSet getResourceSet() {
        return this.modelSet;
    }

    public Resource getResource() {
        return this.resource;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    @Override
    public abstract String getIdentifier();

    protected abstract String getModelFileExtension();

    protected boolean resourceIsSet() {
        return this.resource != null;
    }

    @Override
    @Deprecated
    public void createModel(IPath fullPath) {
        this.createModel(this.getPlatformURI(fullPath));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void createModel(URI uri) {
        this.resourceURI = uri.appendFileExtension(this.getModelFileExtension());
        modelSet = this.getModelManager();
        this.resource = modelSet.getResource(this.resourceURI, false);
        if (this.resource != null) {
            try {
                modelSet.getResource(this.resourceURI, true);
            }
            catch (RuntimeException e) {
                attributes = modelSet.getURIConverter().getAttributes(this.resourceURI, Collections.singletonMap("requestedAttributes", Collections.singleton("length")));
                length = (Number)attributes.get("length");
                if (length == null || length.longValue() <= 0L) ** GOTO lbl15
                throw e;
            }
        } else {
            this.resource = this.getModelManager().createResource(this.resourceURI);
        }
lbl15:
        // 3 sources

        this.configureResource(this.resource);
    }

    protected void configureResource(Resource resource) {
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).getDefaultSaveOptions().putAll(this.getSaveOptions());
            ((XMIResource)resource).setEncoding(ENCODING);
        }
    }

    protected URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public void loadModel(IFile file) {
        this.loadModel(file.getFullPath().removeFileExtension());
    }

    @Override
    @Deprecated
    public void loadModel(IPath fullPathWithoutExtension) {
        this.loadModel(this.getPlatformURI(fullPathWithoutExtension));
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource = this.modelSet.getResource(this.resourceURI, true);
        this.configureResource(this.resource);
        this.snippets.performStart(this);
    }

    @Override
    @Deprecated
    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    @Override
    public void importModel(URI uriWithoutExtension) {
        this.loadModel(uriWithoutExtension);
    }

    @Override
    public void saveModel() throws IOException {
        if (!this.getModelManager().getTransactionalEditingDomain().isReadOnly(this.resource) && !ModelUtils.resourceFailedOnLoad(this.resource)) {
            this.resource.save(null);
        }
    }

    @Override
    @Deprecated
    public void changeModelPath(IPath fullPath) {
        this.setModelURI(this.getPlatformURI(fullPath));
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource.setURI(this.resourceURI);
    }

    @Override
    public void unload() {
        this.snippets.performDispose(this);
        if (this.resource != null) {
            this.resource.unload();
            this.resource = null;
        }
    }

    @Override
    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }

    protected Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", ENCODING);
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }

    @Override
    public void saveCopy(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        HashMap<String, SaveCopyURIHandlerImp> saveOptions = new HashMap<String, SaveCopyURIHandlerImp>();
        URI targetURI = this.getTargetURI(targetPathWithoutExtension);
        saveOptions.put("URI_HANDLER", new SaveCopyURIHandlerImp(targetMap, targetURI));
        try {
            OutputStream outputStream = this.modelSet.getURIConverter().createOutputStream(targetURI);
            this.resource.save(outputStream, saveOptions);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void fillTargetMap(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        targetMap.put(this.getResourceURI(), this.getTargetURI(targetPathWithoutExtension));
    }

    protected URI getTargetURI(IPath targetPathWithoutExtension) {
        String resourceSegment = this.resourceURI.lastSegment();
        int index = resourceSegment.lastIndexOf(".");
        if (index > -1) {
            String extension = resourceSegment.substring(index + 1);
            IPath targetPath = targetPathWithoutExtension.addFileExtension(extension);
            URI targetURI = targetPath.getDevice() == null ? URI.createPlatformResourceURI((String)targetPath.toOSString(), (boolean)true) : URI.createFileURI((String)targetPath.toString());
            return targetURI;
        }
        return null;
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    @Override
    public Set<URI> getModifiedURIs() {
        if (this.getResource() != null && (!this.getResource().isTrackingModification() || this.getResource().isModified())) {
            return Collections.singleton(this.getResource().getURI());
        }
        return Collections.emptySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SaveCopyURIHandlerImp
    extends URIHandlerImpl.PlatformSchemeAware {
        private Map<Object, Object> targetMap;
        private URI targetURI;

        public SaveCopyURIHandlerImp(Map<Object, Object> targetMap, URI targetURI) {
            this.targetMap = targetMap;
            this.targetURI = targetURI;
        }

        public void setBaseURI(URI baseURI) {
            super.setBaseURI(this.targetURI);
        }

        public URI deresolve(URI uri) {
            Object target;
            URI resourceURI = uri.trimFragment();
            if (!AbstractBaseModel.this.resourceURI.equals(resourceURI) && this.targetMap.containsKey(resourceURI) && (target = this.targetMap.get(resourceURI)) instanceof URI) {
                URI targetURI = (URI)target;
                if (uri.fragment() != null) {
                    targetURI = targetURI.appendFragment(uri.fragment());
                }
                return targetURI;
            }
            return super.deresolve(uri);
        }
    }
}

