/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.EditingDomainManager;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.BadStateException;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.IVersionableModel;
import org.eclipse.papyrus.infra.core.resource.ModelException;
import org.eclipse.papyrus.infra.core.resource.ModelIdentifiers;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.ProxyModificationTrackingAdapter;
import org.eclipse.papyrus.infra.core.resource.TransactionalEditingDomainManager;
import org.eclipse.papyrus.infra.core.resource.additional.AdditionalResourcesModel;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSet
extends ResourceSetImpl {
    public static final String PAPYRUS_EDITING_DOMAIN_ID = "org.eclipse.papyrus.SharedEditingDomainID";
    protected Map<String, IModel> models = new HashMap<String, IModel>();
    protected ModelSetSnippetList snippets = new ModelSetSnippetList();
    protected AdditionalResourcesModel additional = new AdditionalResourcesModel();
    protected TransactionalEditingDomain transactionalEditingDomain;
    protected URI uriWithoutExtension;
    protected Adapter modificationTrackingAdapter;
    protected IReadOnlyHandler roHandler;
    protected Set<URI> toDeleteOnSave = new HashSet<URI>();

    public ModelSet() {
        this.registerModel(this.additional);
        this.setTrackingModification(true);
        this.getLoadOptions().put("DEFER_ATTACHMENT", true);
        this.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        this.getLoadOptions().put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        this.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
    }

    public void registerModel(IModel model) {
        IModel existing = this.models.get(model.getIdentifier());
        if (existing == null || existing.getClass().isAssignableFrom(model.getClass().getSuperclass())) {
            this.doRegisterModel(model);
        }
    }

    protected void doRegisterModel(IModel model) {
        this.models.put(model.getIdentifier(), model);
        model.init(this);
    }

    public IModel getModel(String key) {
        return this.models.get(key);
    }

    public IModel getModelChecked(String key) throws NotFoundException {
        IModel model = this.models.get(key);
        if (model == null) {
            throw new NotFoundException("Can't find model for identifier '" + key + "'.");
        }
        return model;
    }

    public Resource createResource(URI uri, String contentType) {
        return this.setResourceOptions(super.createResource(uri, contentType));
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource r = null;
        try {
            r = super.getResource(uri, loadOnDemand);
        }
        catch (WrappedException e) {
            if (ModelUtils.isDegradedModeAllowed(e.getCause())) {
                r = super.getResource(uri, false);
                if (r == null) {
                    throw e;
                }
            }
            throw e;
        }
        return this.setResourceOptions(r);
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
        super.handleDemandLoadException(resource, exception);
    }

    public void setTrackingModification(boolean isTrackingModification) {
        boolean oldIsTrackingModification;
        boolean bl = oldIsTrackingModification = this.modificationTrackingAdapter != null;
        if (oldIsTrackingModification != isTrackingModification) {
            if (isTrackingModification) {
                this.modificationTrackingAdapter = this.createModificationTrackingAdapter();
                this.eAdapters().add((Object)this.modificationTrackingAdapter);
            } else {
                Adapter oldModificationTrackingAdapter = this.modificationTrackingAdapter;
                this.modificationTrackingAdapter = null;
                this.eAdapters().remove((Object)oldModificationTrackingAdapter);
            }
        }
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ProxyModificationTrackingAdapter();
    }

    public boolean isTrackingModification() {
        return this.modificationTrackingAdapter != null;
    }

    @Deprecated
    public Resource getAssociatedResource(EObject modelElement, String associatedResourceExtension) {
        return this.getAssociatedResource(modelElement, associatedResourceExtension, true);
    }

    @Deprecated
    public Resource getAssociatedResource(Resource modelResource, String associatedResourceExtension) {
        return this.getAssociatedResource(modelResource, associatedResourceExtension, true);
    }

    public Resource getAssociatedResource(EObject modelElement, String associatedResourceExtension, boolean loadOnDemand) {
        if (modelElement != null) {
            return this.getAssociatedResource(modelElement.eResource(), associatedResourceExtension, loadOnDemand);
        }
        return null;
    }

    public Resource getAssociatedResource(Resource modelResource, String associatedResourceExtension, boolean loadOnDemand) {
        Resource r = null;
        if (modelResource != null) {
            URI trimmedModelURI = modelResource.getURI().trimFileExtension();
            r = this.getResource(trimmedModelURI.appendFileExtension(associatedResourceExtension), loadOnDemand);
        }
        return r;
    }

    protected Resource setResourceOptions(Resource r) {
        if (r != null && this.isTrackingModification() && !r.isTrackingModification()) {
            r.setTrackingModification(true);
        }
        return r;
    }

    protected void demandLoad(Resource resource) throws IOException {
        super.demandLoad(this.setResourceOptions(resource));
    }

    public synchronized TransactionalEditingDomain getTransactionalEditingDomain() {
        this.transactionalEditingDomain = TransactionalEditingDomainManager.getTransactionalEditingDomain((ResourceSet)this);
        if (this.transactionalEditingDomain == null) {
            this.transactionalEditingDomain = TransactionalEditingDomainManager.createTransactionalEditingDomain((ResourceSet)this);
            EditingDomainManager.getInstance().configureListeners(PAPYRUS_EDITING_DOMAIN_ID, this.transactionalEditingDomain);
        }
        return this.transactionalEditingDomain;
    }

    @Deprecated
    public IPath getFilenameWithoutExtension() {
        Path result = null;
        if (this.uriWithoutExtension != null) {
            if (this.uriWithoutExtension.isPlatformResource()) {
                result = new Path(this.uriWithoutExtension.toPlatformString(true));
            } else {
                throw new IllegalStateException("URI is not a platform:/resource URI");
            }
        }
        return result;
    }

    public URI getURIWithoutExtension() {
        return this.uriWithoutExtension;
    }

    protected URI getURIWithoutExtensionChecked() throws BadStateException {
        if (this.uriWithoutExtension == null) {
            throw new BadStateException("Path should be set prior calling any operations.");
        }
        return this.uriWithoutExtension;
    }

    protected void setURIWithoutExtension(URI uriWithoutExtension) {
        this.uriWithoutExtension = uriWithoutExtension;
    }

    @Deprecated
    public void createsModels(IFile newFile) {
        this.createModels(this.createURI(newFile));
    }

    public void createModels(URI newURI) {
        this.setURIWithoutExtension(newURI.trimFileExtension());
        for (IModel model : this.models.values()) {
            model.createModel(this.uriWithoutExtension);
        }
        this.snippets.performStart(this);
    }

    public void createsModels(ModelIdentifiers modelIdentifiers) {
        for (String modelId : modelIdentifiers) {
            IModel model = this.getModel(modelId);
            model.createModel(this.uriWithoutExtension);
        }
    }

    public IModel loadModel(String modelIdentifier) throws BadStateException {
        IModel model = this.getModel(modelIdentifier);
        model.loadModel(this.getURIWithoutExtensionChecked());
        return model;
    }

    @Deprecated
    public IModel loadModel(String modelIdentifier, IFile file) throws ModelException {
        this.importModels(new ModelIdentifiers(modelIdentifier), file);
        return this.getModel(modelIdentifier);
    }

    @Deprecated
    public void loadModels(IFile file) throws ModelMultiException {
        this.loadModels(this.createURI(file));
    }

    protected URI createURI(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public void loadModels(URI uri) throws ModelMultiException {
        this.uriWithoutExtension = uri.trimFileExtension();
        ModelMultiException exceptions = null;
        for (IModel model : this.models.values()) {
            try {
                model.loadModel(this.uriWithoutExtension);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ModelMultiException("Problems encountered while loading one of the models.");
                }
                exceptions.addException(model.getIdentifier(), e);
            }
        }
        this.snippets.performStart(this);
        if (exceptions != null) {
            throw exceptions;
        }
    }

    @Deprecated
    public void importModels(ModelIdentifiers modelIdentifiers, IFile file) throws ModelException {
        this.importModels(modelIdentifiers, this.createURI(file));
    }

    public void importModels(ModelIdentifiers modelIdentifiers, URI uri) throws ModelException {
        URI toImport = uri.trimFileExtension();
        for (String modelId : modelIdentifiers) {
            IModel model = this.getModel(modelId);
            model.importModel(toImport);
            if (uri == null) continue;
            model.setModelURI(this.uriWithoutExtension);
        }
    }

    @Deprecated
    public IModel importModel(String modelIdentifier, IFile file) throws ModelException {
        return this.importModel(modelIdentifier, this.createURI(file));
    }

    public IModel importModel(String modelIdentifier, URI uri) throws ModelException {
        this.importModels(new ModelIdentifiers(modelIdentifier), uri);
        return this.getModel(modelIdentifier);
    }

    public void createMissingModels() throws ModelException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void loadMissingModels() throws ModelException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void save(IProgressMonitor monitor) throws IOException {
        Collection<IModel> modelList = this.models.values();
        monitor.beginTask("Saving resources", modelList.size());
        if (this.isTrackingModification() && this.getReadOnlyHandler() != null) {
            Optional<Boolean> authorizeSave;
            HashSet<URI> roUris = new HashSet<URI>();
            for (IModel model : modelList) {
                Set<URI> uris = model.getModifiedURIs();
                for (URI u : uris) {
                    Optional<Boolean> res = this.getReadOnlyHandler().anyReadOnly(new URI[]{u});
                    if (!res.isPresent() || !((Boolean)res.get()).booleanValue()) continue;
                    roUris.add(u);
                }
            }
            for (URI u : this.getResourcesToDeleteOnSave()) {
                Optional<Boolean> res = this.getReadOnlyHandler().anyReadOnly(new URI[]{u});
                if (!res.isPresent() || !((Boolean)res.get()).booleanValue()) continue;
                roUris.add(u);
            }
            if (!roUris.isEmpty() && (authorizeSave = this.getReadOnlyHandler().makeWritable(roUris.toArray(new URI[roUris.size()]))).isPresent() && !((Boolean)authorizeSave.get()).booleanValue()) {
                monitor.done();
            }
        }
        try {
            for (IModel model : modelList) {
                if (model instanceof AdditionalResourcesModel) continue;
                model.saveModel();
                monitor.worked(1);
            }
            this.additional.saveModel();
            this.handleResourcesToDelete();
        }
        finally {
            monitor.done();
        }
    }

    public Set<URI> getResourcesToDeleteOnSave() {
        return this.toDeleteOnSave;
    }

    protected void handleResourcesToDelete() {
        Iterator<URI> uriIterator = this.getResourcesToDeleteOnSave().iterator();
        while (uriIterator.hasNext()) {
            URI uri = uriIterator.next();
            Resource resource = this.getResource(uri, false);
            if (resource != null) {
                String warMessage = "The resource " + resource.getURI().lastSegment() + " was about to deleted but was still contained in the resource set. The will not be deleted";
                Activator.log.warn(warMessage);
                continue;
            }
            IFile file = this.getFile(uri);
            if (file == null || !file.exists()) continue;
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                uriIterator.remove();
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected IFile getFile(URI uri) {
        URI normalized;
        IFile result = null;
        if (uri.isPlatformPlugin()) {
            return result;
        }
        if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (this.uriConverter != null && !uri.equals(normalized = this.uriConverter.normalize(uri))) {
            result = this.getFile(normalized);
        }
        if (result == null && !uri.isRelative()) {
            try {
                IFile[] files;
                java.net.URI location = new java.net.URI(uri.toString());
                if (this.hasRegisteredEFS(location) && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()))).length > 0) {
                    result = files[0];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean hasRegisteredEFS(java.net.URI location) {
        try {
            return EFS.getStore((java.net.URI)location) != null;
        }
        catch (CoreException ex) {
            return false;
        }
    }

    @Deprecated
    public void saveAs(IPath path) throws IOException {
        this.saveAs(URI.createPlatformResourceURI((String)path.toString(), (boolean)true));
    }

    public void saveAs(URI uri) throws IOException {
        this.uriWithoutExtension = uri.trimFileExtension();
        for (IModel model : this.models.values()) {
            model.setModelURI(this.uriWithoutExtension);
        }
        this.save((IProgressMonitor)new NullProgressMonitor());
    }

    public void unload() {
        EList adapters;
        this.snippets.performDispose(this);
        this.snippets.clear();
        for (IModel model : this.models.values()) {
            if (model instanceof AdditionalResourcesModel) continue;
            model.unload();
        }
        this.additional.unload();
        Iterator iter = this.getResources().iterator();
        while (iter.hasNext()) {
            ((Resource)iter.next()).unload();
            iter.remove();
        }
        if (this.transactionalEditingDomain != null) {
            this.transactionalEditingDomain.dispose();
            this.transactionalEditingDomain = null;
        }
        if (this.adapterFactories != null) {
            this.adapterFactories.clear();
        }
        if ((adapters = this.eAdapters()) != null) {
            adapters.clear();
        }
    }

    public IReadOnlyHandler getReadOnlyHandler() {
        TransactionalEditingDomain editingDomain;
        Object handler;
        if (this.roHandler == null && (handler = PlatformHelper.getAdapter((Object)(editingDomain = this.getTransactionalEditingDomain()), IReadOnlyHandler.class)) instanceof IReadOnlyHandler) {
            this.roHandler = (IReadOnlyHandler)handler;
        }
        return this.roHandler;
    }

    public Internal getInternal() {
        return new Internal(){

            public void setPrimaryModelResourceURI(URI uri) {
                ModelSet.this.setURIWithoutExtension(uri.trimFileExtension());
            }

            public void registerModel(IModel model, boolean force) {
                if (force) {
                    ModelSet.this.doRegisterModel(model);
                } else {
                    ModelSet.this.registerModel(model);
                }
            }
        };
    }

    public void addModelSetSnippet(IModelSetSnippet snippet) {
        this.snippets.add(snippet);
    }

    public void saveCopy(IPath targetPathWithoutExtension) {
        LinkedList<IVersionableModel> versionableModels = new LinkedList<IVersionableModel>();
        HashMap<Object, Object> targetMap = new HashMap<Object, Object>();
        for (IModel iModel : this.models.values()) {
            if (!(iModel instanceof IVersionableModel)) continue;
            IVersionableModel versionable = (IVersionableModel)iModel;
            versionable.fillTargetMap(targetPathWithoutExtension, targetMap);
            versionableModels.add(versionable);
        }
        for (IVersionableModel iVersionableModel : versionableModels) {
            iVersionableModel.saveCopy(targetPathWithoutExtension, targetMap);
        }
    }

    public static interface Internal {
        public void setPrimaryModelResourceURI(URI var1);

        public void registerModel(IModel var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ModelSetSnippetList
    extends ArrayList<IModelSetSnippet> {
        private static final long serialVersionUID = 1L;

        public void performStart(ModelSet modelsManager) {
            for (IModelSetSnippet snippet : this) {
                snippet.start(modelsManager);
            }
        }

        public void performDispose(ModelSet modelsManager) {
            for (IModelSetSnippet snippet : this) {
                snippet.dispose(modelsManager);
            }
        }
    }
}

