/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionServicesRegistry
extends ServicesRegistry {
    public static final String SERVICE_EXTENSION_ID = "service";
    protected String extensionPointNamespace;
    public static final String SERVICE_EXTENSIONPOINT = "service";
    public static final String SERVICE_FACTORY_ELEMENT_NAME = "serviceFactory";
    public static final String CONTEXTCLASS_ATTRIBUTE = "contextClass";
    private static final String STARTKIND_PROPERTY = "startKind";
    private static final String DEPENDSON_ELEMENT_NAME = "dependsOn";
    private static final String DEPENDSON_KEY_ATTRIBUTE_NAME = "serviceKeyRef";

    public ExtensionServicesRegistry(String extensionPointNamespace) throws ServiceException {
        this.extensionPointNamespace = extensionPointNamespace;
        this.registerDeclaredExtensions();
    }

    private void registerDeclaredExtensions() throws ServiceException {
        IConfigurationElement[] configElements;
        ArrayList<ServiceDescriptor> descriptors = new ArrayList<ServiceDescriptor>();
        ArrayList<ServiceException> exceptions = null;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, "service");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceDescriptor desc;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("service".equals(ele.getName())) {
                try {
                    desc = this.readServiceDescriptor(ele);
                    desc.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.service);
                    descriptors.add(desc);
                }
                catch (ServiceException e) {
                    if (exceptions == null) {
                        exceptions = new ArrayList<ServiceException>();
                    }
                    exceptions.add(e);
                }
            } else if (SERVICE_FACTORY_ELEMENT_NAME.equals(ele.getName())) {
                try {
                    desc = this.readServiceDescriptor(ele);
                    desc.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
                    descriptors.add(desc);
                }
                catch (ServiceException e) {
                    if (exceptions == null) {
                        exceptions = new ArrayList();
                    }
                    exceptions.add(e);
                }
            }
            ++n2;
        }
        for (ServiceDescriptor desc : descriptors) {
            this.add(desc);
        }
        if (exceptions != null) {
            if (exceptions.size() == 1) {
                throw (ServiceException)exceptions.get(0);
            }
            throw new ServiceException("Somme services are not started (first is shown)", (Throwable)exceptions.get(0));
        }
    }

    private ServiceDescriptor readServiceDescriptor(IConfigurationElement ele) throws ServiceException {
        String serviceClassname = ele.getAttribute("classname");
        String key = ele.getAttribute("id");
        if (key == null || key.length() == 0) {
            key = serviceClassname;
        }
        ServiceStartKind serviceStartKind = ServiceStartKind.LAZY;
        String serviceStartKindStr = ele.getAttribute(STARTKIND_PROPERTY);
        if (serviceStartKindStr != null && serviceStartKindStr.length() > 0) {
            try {
                serviceStartKind = ServiceStartKind.valueOf(serviceStartKindStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException("Can't convert property startKind(plugin=" + ele.getContributor() + "declaringExtension=" + ele.getDeclaringExtension() + ")", e);
            }
        }
        int priority = 1;
        String priorityStr = ele.getAttribute("priority");
        if (priorityStr != null && priorityStr.length() > 0) {
            try {
                priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        List<String> keys = this.getDependsOn(ele);
        ServiceDescriptor desc = new ServiceDescriptor(key, serviceClassname, serviceStartKind, priority);
        desc.setClassBundleID(ele.getContributor().getName());
        if (keys.size() > 0) {
            desc.setRequiredServiceKeys(keys);
        }
        return desc;
    }

    private List<String> getDependsOn(IConfigurationElement parentElement) {
        IConfigurationElement[] configElements;
        ArrayList<String> keys = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = configElements = parentElement.getChildren(DEPENDSON_ELEMENT_NAME);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            String key = ele.getAttribute(DEPENDSON_KEY_ATTRIBUTE_NAME);
            if (key != null && key.length() > 0) {
                keys.add(key.trim());
            }
            ++n2;
        }
        if (keys.size() == 0) {
            return Collections.emptyList();
        }
        return keys;
    }
}

