/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.papyrus.infra.core.utils.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredListView
extends AbstractSequentialList<Object>
implements List<Object> {
    private List<Object> list;
    private IFilter filter;
    private int size = -1;

    public FilteredListView(List<Object> list, IFilter filter) {
        this.list = list;
        this.filter = filter;
    }

    public void setBackupList(List aList) {
        this.list = aList;
    }

    public void setFilter(IFilter aFilter) {
        this.filter = aFilter;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new FilteredListIterator(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredListIterator
    implements ListIterator<Object> {
        Object current;
        Object next;
        Object previous;
        int currentIndex;
        int previousIndex;
        int nextIndex;
        int eleIndex = -1;
        int index = 0;
        ListIterator<Object> listIterator;

        FilteredListIterator(int index) {
            this.listIterator = FilteredListView.this.list.listIterator(0);
            this.nextIndex = -1;
            this.next = this.nextFilteredObject();
            this.previous = null;
            this.previousIndex = -1;
            this.current = this.next;
            this.currentIndex = 0;
            while (this.hasNext() && this.nextIndex() < index) {
                this.next();
            }
        }

        protected Object nextFilteredObject() {
            while (this.listIterator.hasNext()) {
                int curIndex = this.listIterator.nextIndex();
                Object ele = this.listIterator.next();
                if (!FilteredListView.this.filter.isAllowed(ele) || curIndex <= this.nextIndex) continue;
                this.nextIndex = curIndex;
                return ele;
            }
            return null;
        }

        protected Object previousFilteredObject() {
            while (this.listIterator.hasPrevious()) {
                int curIndex = this.listIterator.previousIndex();
                Object ele = this.listIterator.previous();
                if (!FilteredListView.this.filter.isAllowed(ele) || curIndex >= this.previousIndex) continue;
                this.previousIndex = curIndex;
                return ele;
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.index > this.eleIndex) {
                this.previous = this.current;
                this.previousIndex = this.currentIndex;
                this.current = this.next;
                this.currentIndex = this.nextIndex;
                this.next = this.nextFilteredObject();
                ++this.index;
                ++this.eleIndex;
                return this.current;
            }
            ++this.index;
            return this.current;
        }

        @Override
        public Object previous() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            if (this.index > this.eleIndex) {
                --this.index;
                return this.current;
            }
            this.next = this.current;
            this.nextIndex = this.currentIndex;
            this.current = this.previous;
            this.currentIndex = this.previousIndex;
            this.previous = this.previousFilteredObject();
            --this.index;
            --this.eleIndex;
            return this.current;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

