/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.command.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.CollaborationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.CompositeLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.ConnectorHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TimeObservationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TypeHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.composite.custom.log.Log;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)CompositeLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualId = new HashSet<Integer>();
        droppableElementsVisualId.add(2060);
        droppableElementsVisualId.add(2061);
        droppableElementsVisualId.add(2062);
        droppableElementsVisualId.add(2063);
        droppableElementsVisualId.add(2064);
        droppableElementsVisualId.add(2065);
        droppableElementsVisualId.add(2069);
        droppableElementsVisualId.add(2070);
        droppableElementsVisualId.add(2071);
        droppableElementsVisualId.add(2072);
        droppableElementsVisualId.add(2073);
        droppableElementsVisualId.add(2075);
        droppableElementsVisualId.add(2076);
        droppableElementsVisualId.add(2066);
        droppableElementsVisualId.add(2067);
        droppableElementsVisualId.add(2068);
        droppableElementsVisualId.add(2077);
        droppableElementsVisualId.add(2078);
        droppableElementsVisualId.add(2079);
        droppableElementsVisualId.add(2080);
        droppableElementsVisualId.add(2081);
        droppableElementsVisualId.add(2082);
        droppableElementsVisualId.add(2083);
        droppableElementsVisualId.add(2084);
        droppableElementsVisualId.add(2085);
        droppableElementsVisualId.add(2088);
        droppableElementsVisualId.add(2089);
        droppableElementsVisualId.add(2095);
        droppableElementsVisualId.add(2096);
        droppableElementsVisualId.add(2097);
        droppableElementsVisualId.add(2098);
        droppableElementsVisualId.add(2099);
        droppableElementsVisualId.add(2100);
        droppableElementsVisualId.add(2101);
        droppableElementsVisualId.add(2102);
        droppableElementsVisualId.add(2103);
        droppableElementsVisualId.add(2104);
        droppableElementsVisualId.add(2107);
        droppableElementsVisualId.add(2108);
        droppableElementsVisualId.add(2109);
        droppableElementsVisualId.add(2110);
        droppableElementsVisualId.add(2111);
        droppableElementsVisualId.add(2112);
        droppableElementsVisualId.add(2113);
        droppableElementsVisualId.add(2114);
        droppableElementsVisualId.add(3072);
        droppableElementsVisualId.add(3073);
        droppableElementsVisualId.add(3074);
        droppableElementsVisualId.add(3075);
        droppableElementsVisualId.add(3076);
        droppableElementsVisualId.add(3077);
        droppableElementsVisualId.add(3081);
        droppableElementsVisualId.add(3082);
        droppableElementsVisualId.add(3083);
        droppableElementsVisualId.add(3084);
        droppableElementsVisualId.add(3085);
        droppableElementsVisualId.add(3086);
        droppableElementsVisualId.add(3086);
        droppableElementsVisualId.add(4010);
        droppableElementsVisualId.add(4017);
        droppableElementsVisualId.add(4013);
        droppableElementsVisualId.add(3069);
        droppableElementsVisualId.add(3088);
        droppableElementsVisualId.add(3070);
        droppableElementsVisualId.add(2094);
        droppableElementsVisualId.add(2093);
        droppableElementsVisualId.add(3097);
        droppableElementsVisualId.add(3120);
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        switch (linkVISUALID) {
            case 4010: {
                return this.dropDependency(dropRequest, semanticElement, linkVISUALID);
            }
            case 4017: {
                return this.dropRoleBinding(dropRequest, semanticElement, linkVISUALID);
            }
            case 4013: {
                return this.dropConnector(dropRequest, semanticElement, linkVISUALID);
            }
        }
        switch (nodeVISUALID) {
            case 2060: 
            case 2061: 
            case 2062: 
            case 2063: 
            case 2064: 
            case 2065: 
            case 2066: 
            case 2067: 
            case 2068: 
            case 2069: 
            case 2070: 
            case 2071: 
            case 2072: 
            case 2073: 
            case 2075: 
            case 2076: 
            case 2077: 
            case 2078: 
            case 2079: 
            case 2080: 
            case 2081: 
            case 2082: 
            case 2083: 
            case 2084: 
            case 2085: 
            case 2088: 
            case 2089: 
            case 2095: 
            case 2096: 
            case 2097: 
            case 2098: 
            case 2099: 
            case 2100: 
            case 2101: 
            case 2102: 
            case 2103: 
            case 2104: 
            case 2107: 
            case 2108: 
            case 2110: 
            case 2111: 
            case 2112: 
            case 2113: {
                return this.dropTopLevelNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
            }
            case 3069: {
                return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
            }
            case 3088: {
                return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
            }
            case 3070: {
                return this.dropProperty(dropRequest, (Property)semanticElement, nodeVISUALID);
            }
            case 2094: {
                return this.dropTimeObservation(dropRequest, (TimeObservation)semanticElement, nodeVISUALID);
            }
            case 2093: {
                return this.dropDurationObservation(dropRequest, (DurationObservation)semanticElement, nodeVISUALID);
            }
            case 2109: 
            case 3097: {
                return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
            }
            case 2114: 
            case 3120: {
                return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (nodeVISUALID == 2109) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_2109, (IHintedType)UMLElementTypes.CommentAnnotatedElement_4002);
        }
        if (nodeVISUALID == 3097) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_3097, (IHintedType)UMLElementTypes.CommentAnnotatedElement_4002);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (nodeVISUALID == 2114) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_2114, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4003);
        }
        if (nodeVISUALID == 3120) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_3120, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4003);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sourceEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = CompositeLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Dependency"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropRoleBinding(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sourceEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = CompositeLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = semanticLink.getOwner();
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop RoleBinding"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConnector(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> connectorEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        if (connectorEnds != null && connectorEnds.size() == 2) {
            ConnectorHelper helper = new ConnectorHelper(this.getEditingDomain());
            return new ICommandProxy((ICommand)helper.dropConnector((Connector)semanticLink, linkVISUALID, this.getViewer(), this.getHost(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView()));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropProperty(DropObjectsRequest dropRequest, Property droppedElement, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        Point location = dropRequest.getLocation().getCopy();
        if (!(droppedElement instanceof Port)) {
            Type type;
            if (graphicalParentObject instanceof Classifier && ((Classifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement && (type = ((ConnectableElement)graphicalParentObject).getType()) != null && type instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAffixedNode(DropObjectsRequest dropRequest, Element droppedElement, int nodeVISUALID) {
        if (!(droppedElement instanceof Port) && !(droppedElement instanceof Parameter)) {
            Log.getInstance().error(new Exception("Incorrect parameter type (droppedElement should be a Port or Parameter)"));
            return UnexecutableCommand.INSTANCE;
        }
        Boolean isCompartmentTarget = false;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        Point dropLocation = dropRequest.getLocation().getCopy();
        if (graphicalParentEditPart instanceof ShapeCompartmentEditPart) {
            isCompartmentTarget = true;
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent();
            Point targetLocation = graphicalParentEditPart.getContentPane().getBounds().getLocation();
            ShapeCompartmentFigure compartmentFigure = (ShapeCompartmentFigure)this.getHostFigure();
            Viewport compartmentViewPort = compartmentFigure.getScrollPane().getViewport();
            Point compartmentViewPortLocation = compartmentViewPort.getLocation();
            Point compartmentViewPortViewLocation = compartmentViewPort.getViewLocation();
            Point delta = compartmentViewPortLocation.translate(targetLocation.negate());
            delta = delta.translate(compartmentViewPortViewLocation.negate());
            dropLocation = dropRequest.getLocation().getTranslated(delta);
        }
        Point parentLoc = graphicalParentEditPart.getFigure().getBounds().getLocation().getCopy();
        PortPositionLocator locator = new PortPositionLocator(graphicalParentEditPart.getFigure(), 0);
        Rectangle proposedBounds = new Rectangle(dropLocation, new Dimension(20, 20));
        proposedBounds = proposedBounds.getTranslated(parentLoc);
        Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        dropLocation = creationBounds.getLocation();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        if (graphicalParentObject instanceof ConnectableElement) {
            Type type = ((ConnectableElement)graphicalParentObject).getType();
            if (type != null && type instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)type).getAllAttributes().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
        } else if (graphicalParentObject instanceof Behavior && ((Behavior)graphicalParentObject).getOwnedParameters().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDurationObservation(DropObjectsRequest dropRequest, DurationObservation droppedElement, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        DurationObservationHelper durationObservationHelper = new DurationObservationHelper(this.getEditingDomain());
        return durationObservationHelper.dropDurationObservation(droppedElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropTimeObservation(DropObjectsRequest dropRequest, TimeObservation droppedElement, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        TimeObservationHelper timeObservationHelper = new TimeObservationHelper(this.getEditingDomain());
        return timeObservationHelper.dropTimeObservation(droppedElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropTopLevelNode(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CompoundCommand getDropAffixedNodeInCompartmentCommand(int nodeVISUALID, Point location, EObject droppedObject) {
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getModel());
        cc.add((Command)new ICommandProxy((ICommand)createCommand));
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        return cc;
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        CompoundCommand cc = new CompoundCommand("Drop");
        Iterator iter = dropRequest.getObjects().iterator();
        if (dropRequest.getObjects().size() > 0 && dropRequest.getObjects().get(0) instanceof String) {
            return this.getDropFileCommand(dropRequest);
        }
        Point location = dropRequest.getLocation().getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)location);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)location);
        location.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        View graphicalParentView = (View)((GraphicalEditPart)this.getHost()).getModel();
        while (!(graphicalParentView instanceof Diagram) && graphicalParentObject != null && iter.hasNext()) {
            ElementHelper helper;
            EObject droppedObject = (EObject)iter.next();
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration) {
                    helper = new CollaborationHelper(this.getEditingDomain());
                    cc.add((Command)helper.dropCollaborationAsCollaborationUse((GraphicalEditPart)this.getHost(), (Collaboration)droppedObject, location));
                    continue;
                }
                if (!(droppedObject instanceof Class)) continue;
                helper = new TypeHelper(this.getEditingDomain());
                cc.add((Command)helper.dropTypeAsTypedProperty((GraphicalEditPart)this.getHost(), (Type)((Class)droppedObject), location));
                continue;
            }
            if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration) {
                    helper = new CollaborationHelper(this.getEditingDomain());
                    cc.add((Command)helper.dropCollaborationAsCollaborationUse((GraphicalEditPart)this.getHost(), (Collaboration)droppedObject, location));
                    continue;
                }
                if (!(droppedObject instanceof Classifier)) continue;
                helper = new TypeHelper(this.getEditingDomain());
                cc.setLabel("Drop type as typed property");
                cc.add((Command)helper.dropTypeAsTypedProperty((GraphicalEditPart)this.getHost(), (Type)((Classifier)droppedObject), location));
                continue;
            }
            if (graphicalParentObject instanceof TypedElement) {
                if (!(droppedObject instanceof Type)) continue;
                helper = new TypeHelper(this.getEditingDomain());
                cc.add((Command)helper.dropTypeOnTypedElement((GraphicalEditPart)this.getHost(), (Type)droppedObject, location));
                continue;
            }
            if (!(graphicalParentObject instanceof CollaborationUse) || !(droppedObject instanceof Collaboration)) continue;
            helper = new CollaborationHelper(this.getEditingDomain());
            cc.add((Command)helper.dropCollaborationOnCollaborationUse((GraphicalEditPart)this.getHost(), (Type)((Collaboration)droppedObject), location));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return super.getDropObjectsCommand(dropRequest);
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrag = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrag = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrag.booleanValue()) {
            return null;
        }
        return super.getDragCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrop = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrop = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrop.booleanValue()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return super.getDropCommand(request);
    }

    protected boolean isSpecificDropActionExpected(GraphicalEditPart graphicalParent, EObject droppedObject) {
        boolean isSpecificDropActionExpected = false;
        EObject graphicalParentObject = graphicalParent.resolveSemanticElement();
        if (graphicalParentObject != null) {
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof TypedElement) {
                if (droppedObject instanceof Type) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof CollaborationUse && droppedObject instanceof Collaboration) {
                isSpecificDropActionExpected = true;
            }
        }
        return isSpecificDropActionExpected;
    }
}

