/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class IntegerSpinner
extends AbstractValueEditor {
    protected Spinner spinner = this.createSpinner();
    protected IConverter targetToModelConverter;

    public IntegerSpinner(Composite parent, int style) {
        super(parent, style);
        this.setWidgetObservable((IObservableValue)new AbstractObservableValue(){

            public Object getValueType() {
                return Integer.class;
            }

            protected Integer doGetValue() {
                return (Integer)IntegerSpinner.this.targetToModelConverter.convert((Object)IntegerSpinner.this.spinner.getText());
            }

            protected void doSetValue(Object value) {
                IntegerSpinner.this.spinner.setSelection(((Integer)value).intValue());
            }
        });
        this.targetToModelConverter = StringToNumberConverter.toInteger((boolean)false);
    }

    protected Spinner createSpinner() {
        return new Spinner((Composite)this, factory.getBorderStyle());
    }

    public void doBinding() {
        this.spinner.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                IntegerSpinner.this.binding.updateTargetToModel();
            }
        });
        super.doBinding();
    }

    public Object getValue() {
        String value = this.spinner.getText();
        return this.targetToModelConverter.convert((Object)value);
    }

    public Object getEditableType() {
        return Integer.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.spinner.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.spinner.isEnabled();
    }

    public void setToolTipText(String text) {
        this.spinner.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void setMinimum(int minimum) {
        this.spinner.setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.spinner.setMaximum(maximum);
    }

    public void setIncrement(int increment) {
        this.spinner.setIncrement(increment);
    }
}

