/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TreeSelectorDialog
extends SelectionDialog
implements ITreeSelectorDialog {
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private TreeViewer treeViewer;
    private Label descriptionLabel;
    private Object input = null;
    private final Set<ICommitListener> commitListeners = new HashSet<ICommitListener>();

    public TreeSelectorDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
        if (this.treeViewer != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
        if (this.treeViewer != null) {
            this.initViewerAndProvider();
        }
        if (this.contentProvider instanceof ICommitListener) {
            this.commitListeners.add((ICommitListener)this.contentProvider);
        }
    }

    protected void initViewerAndProvider() {
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (this.treeViewer.getInput() == null) {
            this.doSetInput();
        }
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void create() {
        super.create();
        this.descriptionLabel = new Label(this.getDialogArea(), 64);
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.treeViewer = new TreeViewer(this.getDialogArea(), 2048);
        if (this.labelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        if (this.contentProvider != null) {
            this.initViewerAndProvider();
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Object selectedElement = null;
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IStructuredSelection sSelection = (IStructuredSelection)selection;
                    selectedElement = sSelection.getFirstElement();
                }
                if (TreeSelectorDialog.this.contentProvider instanceof IHierarchicContentProvider) {
                    boolean isValidValue = ((IHierarchicContentProvider)TreeSelectorDialog.this.contentProvider).isValidValue(selectedElement);
                    if (TreeSelectorDialog.this.contentProvider instanceof IAdaptableContentProvider) {
                        selectedElement = ((IAdaptableContentProvider)TreeSelectorDialog.this.contentProvider).getAdaptedValue(selectedElement);
                    }
                    if (isValidValue) {
                        TreeSelectorDialog.this.setResult(Collections.singletonList(selectedElement));
                    } else {
                        TreeSelectorDialog.this.setResult(Collections.EMPTY_LIST);
                    }
                    TreeSelectorDialog.this.getOkButton().setEnabled(isValidValue);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TreeSelectorDialog.this.getOkButton().isEnabled()) {
                    TreeSelectorDialog.this.okPressed();
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 300;
        data.minimumWidth = 300;
        this.treeViewer.getTree().setLayoutData((Object)data);
        if (this.contentProvider instanceof IGraphicalContentProvider) {
            IGraphicalContentProvider graphicalContentProvider = (IGraphicalContentProvider)this.contentProvider;
            Composite beforeTreeComposite = new Composite(this.getDialogArea(), 0);
            beforeTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            beforeTreeComposite.setLayout((Layout)new FillLayout());
            graphicalContentProvider.createBefore(beforeTreeComposite);
            beforeTreeComposite.moveAbove((Control)this.treeViewer.getTree());
            Composite afterTreeComposite = new Composite(this.getDialogArea(), 0);
            afterTreeComposite.setLayout((Layout)new FillLayout());
            afterTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            graphicalContentProvider.createAfter(afterTreeComposite);
        }
        List initialSelection = this.getInitialElementSelections();
        if (this.contentProvider instanceof IRevealSemanticElement) {
            ((IRevealSemanticElement)this.contentProvider).revealSemanticElement(initialSelection);
        } else if (!initialSelection.isEmpty()) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(initialSelection.get(0)), true);
        }
        this.getShell().setDefaultButton(null);
        this.getButton(0).setFocus();
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        this.getShell().pack();
    }

    public void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }

    protected TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    private void doSetInput() {
        if (this.input == null) {
            this.treeViewer.setInput((Object)"");
        } else {
            this.treeViewer.setInput(this.input);
        }
    }

    public void okPressed() {
        for (ICommitListener listener : this.commitListeners) {
            listener.commit(null);
        }
        super.okPressed();
    }
}

