/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import com.ibm.icu.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticWorkspaceContentProvider
extends AbstractStaticContentProvider
implements IHierarchicContentProvider {
    private static final Comparator<IResource> resourceComparator = SemanticWorkspaceContentProvider.createComparator();

    @Override
    public Object[] getElements() {
        try {
            return this.filterAccessibleElements(ResourcesPlugin.getWorkspace().getRoot().members());
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return new Object[0];
        }
    }

    protected Object[] filterAccessibleElements(IResource[] members) {
        List accessibleElements = ListHelper.asList((Object[])members);
        Iterator resourceIterator = accessibleElements.iterator();
        while (resourceIterator.hasNext()) {
            IResource resource = (IResource)resourceIterator.next();
            if (resource.isAccessible()) continue;
            resourceIterator.remove();
        }
        Collections.sort(accessibleElements, resourceComparator);
        return accessibleElements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            try {
                IResource[] members = ((IContainer)parentElement).members();
                return this.filterAccessibleElements(members);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IContainer) {
            return ((IContainer)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public boolean isValidValue(Object element) {
        return !(element instanceof IWorkspaceRoot);
    }

    private static Comparator<IResource> createComparator() {
        int folderTypes = 14;
        return new Comparator<IResource>(){

            @Override
            public int compare(IResource resource1, IResource resource2) {
                int typeCompare = this.compareType(resource1, resource2);
                if (typeCompare == 0) {
                    return this.compareName(resource1, resource2);
                }
                return typeCompare;
            }

            private int compareType(IResource resource1, IResource resource2) {
                if (resource1.getType() == resource2.getType()) {
                    return 0;
                }
                if ((resource1.getType() & 0xE) > (resource2.getType() & 0xE)) {
                    return -1;
                }
                return 1;
            }

            private int compareName(IResource resource1, IResource resource2) {
                return Collator.getInstance().compare(resource1.getName(), resource2.getName());
            }
        };
    }
}

