/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.validator;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.infra.widgets.messages.Messages;

public class UnlimitedNaturalInputValidator
implements IInputValidator {
    public static final String INFINITE_STAR = "*";
    public static final String INFINITE_MINUS_ONE = "-1";

    public String isValid(String newText) {
        if (INFINITE_STAR.equals(newText) || INFINITE_MINUS_ONE.equals(newText)) {
            return null;
        }
        boolean isValid = true;
        try {
            Integer myUnlimitedNatural = new Integer(newText);
            if (myUnlimitedNatural < -1) {
                isValid = false;
            }
        }
        catch (NumberFormatException e) {
            isValid = false;
        }
        if (!isValid) {
            return Messages.UnlimitedNaturalInputValidator_NotAnUnlimitedNaturalMessage;
        }
        return null;
    }
}

