/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.sysml.service.types.helper.AbstractPropertyEditHelperAdvice;
import org.eclipse.papyrus.sysml.service.types.matcher.BlockMatcher;
import org.eclipse.papyrus.sysml.service.types.matcher.PartPropertyMatcher;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class PartPropertyEditHelperAdvice
extends AbstractPropertyEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        Element contextElement;
        BlockMatcher matcher;
        GetEditContextRequest editContextRequest;
        boolean isApproved = super.approveRequest(request);
        if (request != null && request instanceof GetEditContextRequest && (editContextRequest = (GetEditContextRequest)request).getEditContext() instanceof Element && !(matcher = new BlockMatcher()).matches((EObject)(contextElement = (Element)editContextRequest.getEditContext()))) {
            isApproved = false;
        }
        return isApproved;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Property element = (Property)request.getElementToConfigure();
                if (element != null) {
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)"part", (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                    element.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getAfterConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Property sourcePart = (Property)request.getElementToConfigure();
                if (sourcePart != null && sourcePart.getType() != null) {
                    Class sourceType = sourcePart.getClass_();
                    Package associationContainer = sourceType.getNearestPackage();
                    Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                    targetProperty.setType((Type)sourceType);
                    targetProperty.setName("");
                    Association association = UMLFactory.eINSTANCE.createAssociation();
                    association.getMemberEnds().add((Object)sourcePart);
                    association.getOwnedEnds().add((Object)targetProperty);
                    association.getMemberEnds().add((Object)targetProperty);
                    String associationName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)"Association", (Collection)associationContainer.eContents());
                    association.setName(associationName);
                    ElementUtil.addNature((Element)association, (String)"SysML_Nature");
                    association.setPackage(associationContainer);
                }
                return CommandResult.newOKCommandResult((Object)sourcePart);
            }
        };
    }

    protected Property getDuplicatedProperty(DuplicateElementsRequest request) {
        List elementsToBeDuplicated = request.getElementsToBeDuplicated();
        if (elementsToBeDuplicated == null || elementsToBeDuplicated.isEmpty()) {
            return null;
        }
        Object firstElement = elementsToBeDuplicated.get(0);
        if (!(firstElement instanceof Property)) {
            return null;
        }
        PartPropertyMatcher matcher = new PartPropertyMatcher();
        return matcher.matches((EObject)((Property)firstElement)) ? (Property)firstElement : null;
    }
}

