/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEvent;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLUtil {
    public static Element resolveUMLElement(Object source) {
        EObject eElement = EMFHelper.getEObject((Object)source);
        if (eElement instanceof Element) {
            return (Element)eElement;
        }
        return null;
    }

    public static boolean isSubClass(String className, String superclassName) {
        EClass eClass = (EClass)UMLUtil.getUMLMetamodel().getEClassifier(className);
        EClass superClass = (EClass)UMLUtil.getUMLMetamodel().getEClassifier(superclassName);
        return EMFHelper.isSubclass((EClass)eClass, (EClass)superClass);
    }

    public static EditingDomain resolveEditingDomain(Object source) {
        return EMFHelper.resolveEditingDomain((EObject)UMLUtil.resolveUMLElement(source));
    }

    public static EPackage getUMLMetamodel() {
        return UMLPackage.eINSTANCE;
    }

    public static Stereotype getAppliedStereotype(Element umlElement, String stereotypeName, boolean strict) {
        if (umlElement == null || stereotypeName == null) {
            return null;
        }
        Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeName);
        if (strict || stereotype != null) {
            return stereotype;
        }
        List<Stereotype> subStereotypes = UMLUtil.findSubstereotypes(umlElement, stereotypeName);
        for (Stereotype subStereotype : subStereotypes) {
            if (!umlElement.getAppliedStereotypes().contains((Object)subStereotype)) continue;
            return subStereotype;
        }
        return null;
    }

    public static Stereotype findStereotype(Element umlElement, String stereotypeName) {
        if (umlElement == null || stereotypeName == null) {
            return null;
        }
        Stereotype stereotype = null;
        Package umlPackage = umlElement.getNearestPackage();
        if (umlPackage == null) {
            stereotype = umlElement.getApplicableStereotype(stereotypeName);
        } else {
            block0: for (Profile profile : umlPackage.getAllAppliedProfiles()) {
                for (Stereotype ownedStereotype : profile.getOwnedStereotypes()) {
                    if (!ownedStereotype.getQualifiedName().equals(stereotypeName)) continue;
                    stereotype = ownedStereotype;
                    break block0;
                }
            }
        }
        return stereotype;
    }

    public static List<Stereotype> findSubstereotypes(Element umlElement, String stereotypeName) {
        if (umlElement == null || stereotypeName == null) {
            return null;
        }
        HashSet<Stereotype> stereotypes = new HashSet<Stereotype>();
        Package umlPackage = umlElement.getNearestPackage();
        if (umlPackage == null) {
            Stereotype stereotype = umlElement.getApplicableStereotype(stereotypeName);
            if (stereotype != null) {
                stereotypes.add(stereotype);
            }
        } else {
            for (Profile profile : umlPackage.getAllAppliedProfiles()) {
                for (Stereotype ownedStereotype : profile.getOwnedStereotypes()) {
                    for (Stereotype superStereotype : UMLUtil.getAllSuperStereotypes(ownedStereotype)) {
                        if (!stereotypeName.equals(superStereotype.getQualifiedName())) continue;
                        stereotypes.add(ownedStereotype);
                    }
                }
            }
        }
        return new LinkedList<Stereotype>(stereotypes);
    }

    public static Collection<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        HashSet<Stereotype> result = new HashSet<Stereotype>();
        if (stereotype != null) {
            UMLUtil.getAllSuperStereotypes(stereotype, result);
        }
        return result;
    }

    private static void getAllSuperStereotypes(Stereotype stereotype, Set<Stereotype> result) {
        result.add(stereotype);
        for (Classifier superClassifier : stereotype.getGenerals()) {
            if (!(superClassifier instanceof Stereotype) || result.contains(superClassifier)) continue;
            UMLUtil.getAllSuperStereotypes((Stereotype)superClassifier, result);
        }
    }

    public static Class getContextClassForMessage(Message message) {
        MessageOccurrenceSpecification receiveEvent = (MessageOccurrenceSpecification)message.getReceiveEvent();
        if (receiveEvent == null) {
            return null;
        }
        return UMLUtil.getContextClassForMessageOccurrence(receiveEvent);
    }

    public static Class getContextClassForMessageOccurrence(MessageOccurrenceSpecification messageOccurrence) {
        EList lifelines = messageOccurrence.getCovereds();
        if (lifelines.isEmpty()) {
            return null;
        }
        if (lifelines.size() == 1) {
            Lifeline lifeline = (Lifeline)lifelines.get(0);
            ConnectableElement element = lifeline.getRepresents();
            if (element == null) {
                return null;
            }
            Type type = element.getType();
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz;
            }
            return null;
        }
        return null;
    }

    public static Class getContextClassForMessageEvent(MessageEvent event) {
        Collection settings = EMFHelper.getUsages((EObject)event);
        if (settings.isEmpty()) {
            return null;
        }
        if (settings.size() == 1) {
            EObject referer = ((EStructuralFeature.Setting)settings.iterator().next()).getEObject();
            if (referer instanceof MessageOccurrenceSpecification) {
                return UMLUtil.getContextClassForMessageOccurrence((MessageOccurrenceSpecification)referer);
            }
            return null;
        }
        MessageOccurrenceSpecification referer = null;
        EObject newReferer = null;
        for (EStructuralFeature.Setting setting : settings) {
            newReferer = setting.getEObject();
            if (!(newReferer instanceof MessageOccurrenceSpecification)) continue;
            if (referer == null || referer == newReferer) {
                referer = (MessageOccurrenceSpecification)newReferer;
                continue;
            }
            referer = null;
            break;
        }
        if (referer == null) {
            return null;
        }
        return UMLUtil.getContextClassForMessageOccurrence(referer);
    }
}

