/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.commands;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.uml2.uml.Element;

public final class MoveStereotypeApplicationToControlResource
extends AbstractControlCommand {
    public MoveStereotypeApplicationToControlResource(List affectedFiles, ControlModeRequest request) {
        super("Move stereotype application", affectedFiles, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Element elem = (Element)this.getRequest().getTargetObject();
        HashSet elements = Sets.newHashSet((Object[])new Element[]{elem});
        TreeIterator contents = EcoreUtil.getAllProperContents((EObject)elem, (boolean)true);
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (!(eObject instanceof Element)) continue;
            elements.add((Element)eObject);
        }
        Resource targetResource = this.getRequest().getTargetResource("uml");
        if (targetResource == null) {
            return this.createNewControlCommandError("No uml resource created");
        }
        for (Element e : elements) {
            EList stereotypeApplications = e.getStereotypeApplications();
            targetResource.getContents().addAll((Collection)stereotypeApplications);
        }
        return CommandResult.newOKCommandResult();
    }
}

