/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseAllDiagramsCommand
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        IPageManager pageMngr;
        try {
            pageMngr = this.getPageManager(event);
            editingDomain = this.getTransactionalEditingDomain(event);
        }
        catch (NullPointerException e) {
            return null;
        }
        this.execute(pageMngr, editingDomain);
        return null;
    }

    private IPageManager getPageManager(ExecutionEvent event) {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IPageManager pageMngr = (IPageManager)part.getAdapter(IPageManager.class);
        return pageMngr;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain(ExecutionEvent event) {
        IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)activePart.getAdapter(TransactionalEditingDomain.class);
        return editingDomain;
    }

    public void execute(final IPageManager pageMngr, TransactionalEditingDomain editingDomain) throws ExecutionException {
        if (editingDomain == null) {
            throw new ExecutionException("Editing domain not found");
        }
        boolean atLeastOneOpenPage = false;
        for (Object pageIdentifier : pageMngr.allPages()) {
            if (!pageMngr.isOpen(pageIdentifier)) continue;
            atLeastOneOpenPage = true;
            break;
        }
        if (!atLeastOneOpenPage) {
            return;
        }
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Close all pages"){

            protected void doExecute() {
                pageMngr.closeAllOpenedPages();
            }
        });
    }
}

