/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt;

import java.net.URL;
import org.eclipse.papyrus.xwt.ILoadingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLoadingContext
implements ILoadingContext {
    public static final DefaultLoadingContext defaultLoadingContext = new DefaultLoadingContext();
    protected ClassLoader classLoader;

    public DefaultLoadingContext() {
    }

    public DefaultLoadingContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getNamespace() {
        return "http://www.eclipse.org/xwt/presentation";
    }

    @Override
    public Class<?> loadClass(String name) {
        Class<?> type = this.doLoadClass(name);
        if (type != null) {
            return type;
        }
        int index = name.lastIndexOf(46);
        while (index != -1) {
            type = this.doLoadClass(name = String.valueOf(name.substring(0, index)) + "$" + name.substring(index + 1));
            if (type != null) {
                return type;
            }
            index = name.lastIndexOf(46);
        }
        return null;
    }

    protected Class<?> doLoadClass(String name) {
        try {
            return this.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        return this.getClassLoader().getResource(name);
    }
}

