/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.papyrus.xwt.collection.GroupDescription;
import org.eclipse.papyrus.xwt.collection.SortDescription;
import org.eclipse.papyrus.xwt.core.ICollectionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionView<T>
implements ICollectionView<T> {
    private T currentItem;
    private int currentPosition = 0;
    private Collection<T> sourceCollection = Collections.emptyList();
    private GroupDescription[] groupDescription = GroupDescription.EMPTY_ARRAY;
    private Collection<T> groups = Collections.emptyList();
    private Locale locale = Locale.getDefault();
    private SortDescription[] sortDescription = SortDescription.EMPTY_ARRAY;

    @Override
    public GroupDescription[] getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(GroupDescription[] groupDescription) {
        this.groupDescription = groupDescription;
    }

    @Override
    public Collection<T> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<T> groups) {
        this.groups = groups;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public SortDescription[] getSortDescription() {
        return this.sortDescription;
    }

    public void setSortDescription(SortDescription[] sortDescription) {
        this.sortDescription = sortDescription;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    public void setSourceCollection(Collection<T> sourceCollection) {
        this.sourceCollection = sourceCollection;
    }

    @Override
    public boolean canFilter() {
        return false;
    }

    @Override
    public boolean canGroup() {
        return this.groupDescription.length > 0;
    }

    @Override
    public boolean canSort() {
        return this.sortDescription.length > 0;
    }

    @Override
    public T getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(T currentItem) {
        this.currentItem = currentItem;
    }

    @Override
    public int getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public Collection<T> getSourceCollection() {
        return this.sourceCollection;
    }

    @Override
    public boolean isEmpty() {
        if (this.canGroup()) {
            return this.groups.isEmpty();
        }
        return this.sourceCollection.isEmpty();
    }
}

