/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.databinding;

import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.papyrus.xwt.databinding.IBindingContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public class BindingContext
implements IBindingContext {
    private DataBindingContext context;
    private Realm realm;
    private AggregateValidationStatus status;
    private int statusType = 2;
    private final Widget parent;

    public BindingContext(Widget parent) {
        this.parent = parent;
    }

    public DataBindingContext getContext() {
        if (this.context == null) {
            this.context = this.realm != null ? new DataBindingContext(this.realm) : new DataBindingContext(XWT.getRealm());
            if (this.parent != null) {
                this.parent.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        BindingContext.this.context.dispose();
                    }
                });
            }
        }
        return this.context;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public AggregateValidationStatus getStatus() {
        if (this.status == null) {
            this.status = new AggregateValidationStatus(this.getContext(), this.statusType);
            if (this.parent != null) {
                this.parent.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        BindingContext.this.status.dispose();
                    }
                });
            }
        }
        return this.status;
    }

    public int getStatusType() {
        return this.statusType;
    }

    public final Binding bindValue(IObservableValue targetObservableValue, IObservableValue modelObservableValue) {
        return this.getContext().bindValue(targetObservableValue, modelObservableValue);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BindingContext)) {
            return false;
        }
        DataBindingContext context = this.getContext();
        if (context != null) {
            return context.equals(((BindingContext)obj).getContext());
        }
        if (((BindingContext)obj).getContext() != null) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getContext().hashCode();
    }

    public final Binding bindValue(IObservableValue targetObservableValue, IObservableValue modelObservableValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        return this.getContext().bindValue(targetObservableValue, modelObservableValue, targetToModel, modelToTarget);
    }

    public final Binding bindList(IObservableList targetObservableList, IObservableList modelObservableList) {
        return this.getContext().bindList(targetObservableList, modelObservableList);
    }

    public final Binding bindList(IObservableList targetObservableList, IObservableList modelObservableList, UpdateListStrategy targetToModel, UpdateListStrategy modelToTarget) {
        return this.getContext().bindList(targetObservableList, modelObservableList, targetToModel, modelToTarget);
    }

    public final Binding bindSet(IObservableSet targetObservableSet, IObservableSet modelObservableSet) {
        return this.getContext().bindSet(targetObservableSet, modelObservableSet);
    }

    public final Binding bindSet(IObservableSet targetObservableSet, IObservableSet modelObservableSet, UpdateSetStrategy targetToModel, UpdateSetStrategy modelToTarget) {
        return this.getContext().bindSet(targetObservableSet, modelObservableSet, targetToModel, modelToTarget);
    }

    public final void dispose() {
        this.getContext().dispose();
    }

    public final IObservableList getBindings() {
        return this.getContext().getBindings();
    }

    public final IObservableList getValidationStatusProviders() {
        return this.getContext().getValidationStatusProviders();
    }

    public final IObservableMap getValidationStatusMap() {
        return this.getContext().getValidationStatusMap();
    }

    public void addBinding(Binding binding) {
        this.getContext().addBinding(binding);
    }

    public void addValidationStatusProvider(ValidationStatusProvider validationStatusProvider) {
        this.getContext().addValidationStatusProvider(validationStatusProvider);
    }

    public final void updateModels() {
        this.getContext().updateModels();
    }

    public final void updateTargets() {
        this.getContext().updateTargets();
    }

    public boolean removeBinding(Binding binding) {
        return this.getContext().removeBinding(binding);
    }

    public boolean removeValidationStatusProvider(ValidationStatusProvider validationStatusProvider) {
        return this.getContext().removeValidationStatusProvider(validationStatusProvider);
    }

    public final Realm getValidationRealm() {
        return this.getContext().getValidationRealm();
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public void setStatusType(int statusType) {
        this.statusType = statusType;
    }
}

